

package gov.va.med.cds.testharness;


import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.FactoryConfigurationError;

import org.apache.commons.logging.Log;
import org.apache.logging.log4j.core.LoggerContext;
//import org.apache.logging.log4j.xml.DOMConfigurator;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;

import gov.va.med.cds.properties.PropertiesUtil;


public class LoggingAndPropertyConfigurator
{
    private static final String LOGGER_CONFIG_PATH = "src/test/resources/log4j2.xml";
    private static final String APPLICATION_NAME = "CDS";


    public String getDefaultLoggingConfigFilePath( )
    {
        return LOGGER_CONFIG_PATH;
    }


    static public void configureLoggingAndProperties( Log logger, String logfilePath )
        throws FactoryConfigurationError,
            IOException
    {

        new PropertiesUtil().loadSystemRunProperties();

        // Setup logger
        if ( logfilePath == null )
            logfilePath = LOGGER_CONFIG_PATH;

        File logFile = new File( logfilePath );
        //InputStream is = new FileInputStream(logfilePath);
        String absolutePath = logFile.getAbsolutePath();//may need this ???
        InputStream is = new FileInputStream(absolutePath); 
        BufferedInputStream bis = new BufferedInputStream(is);
        ConfigurationSource cs = new ConfigurationSource(bis);
        LoggerContext loggerContext =  new LoggerContext("GovCDS");
        XmlConfiguration configuration = new XmlConfiguration( loggerContext, cs);
        //DOMConfigurator.configure( logFile.getAbsolutePath() );

        if ( logger.isDebugEnabled() )
        {
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, APPLICATION_NAME, "using log file: "
                            + logFile.getAbsolutePath() ) );
        }
    }

}
