

package gov.va.med.tfs.persistence;


import static org.junit.Assert.assertNotNull;

import java.util.List;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.tfs.tfdm.TemplateMetaData;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/tfs/config/nonWeblogicApplicationContext.xml",
                "classpath:gov/va/med/tfs/config/nonWeblogicTfrDataSourceContext.xml" } )
public class TemplateSchemaMappingTest
{
    private static ReadPersistenceManagerInterface readManager;

    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testCreateReadPersistenceManager( )
    {
        System.out.println("+++");
        System.out.println( "test created readManager: " + readManager );
        assertNotNull( readManager );
        System.out.println("+++");
    }
    

    private void testCode( String aTemplateId )
        throws Exception
    {
        System.out.println( "--- this read manager:" + readManager );
        System.out.println( "thread Id: " + Thread.currentThread().getName() );
        
        TemplateMetaData template = null;

        System.out.println( "this2: " + this );
        template = readManager.readTemplateData( aTemplateId );
        assertNotNull( template );

//        System.out.println("template: " + template.getTemplateName() + ": " + template.getTemplateDescription());
        System.out.println( "template: " + template );
        System.out.println( "---" );

    }


    @Resource
    public void setReadManager( ReadPersistenceManagerInterface aReadManager )
    {
        System.out.println( "***" );
        System.out.println( "thread Id: " + Thread.currentThread().getName() );
        System.out.println( "injected readManager: " + aReadManager );
        System.out.println( "this: " + this );
        System.out.println( "***" );
        readManager = aReadManager;
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void firstReadTest( )
        throws Exception    
    {
        testCode( "LabRead40010" );
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void multiReadTest( )
        throws Exception
    {
        testCode( "RDIIntoleranceConditionPharmacyRead40010" );
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void readActiveTemplateIdsTest( )
        throws Exception
    {
        System.err.println( "enter: -x-x- readActiveTemplateIdsTest" );
        
        
        
        List<String> templates = null;
        
        System.out.println( "this2: " + this );
        
        List<String> vhimVersions = null;
        vhimVersions = readManager.readVhimVersions();
        for ( String vhimVersion : vhimVersions )
        {
            templates = readManager.readActiveTemplateIds( vhimVersion );
            System.err.println( "templates for vhim version " + vhimVersion + ": " + templates );
            System.err.println( "-x-x-" );
            
        }
        System.err.println( "exit: -x-x- readActiveTemplateIdsTest" );

    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void readVhimVersionsTest( )
        throws Exception
    {
        System.out.println( "-x-x- this read manager:" + readManager );
        
        List<String> vhimVersions = null;
        
        System.out.println( "this2: " + this );
        vhimVersions = readManager.readVhimVersions();

        System.out.println( "vhimVersions: " + vhimVersions );
        System.out.println( "-x-x-" );
    }
    
}
