/**
 * 
 */


package gov.va.med.tfs.tfdm;


import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.hibernate.engine.jdbc.NonContextualLobCreator;


/**
 * @author vhaislecclej
 * @generated "UML to Java V5.0
 *            (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
 */
public class TemplateMetaData
    implements
        TemplateMetaDataInterface,
        Serializable
{
    private static final long serialVersionUID = 414300865982739266L;
    private Set<DomainEntryPoint> domainEntryPoints;
    private Set<String> vhimVersions;
    private String cdsVdm;
    private HashSet<String> readCdsVdms;
    private String templateName;
    private String templateDescription;
    private String operation;
    private boolean testOnly;
    private String templateId;
    private Date dateAdded;
    private Date dateDeprecated;
    private Date dateActivated;
    private Date dateDeactivated;
    private Date dateUpdated;
    private String status;
    private byte[] templateJar;


    public Set<DomainEntryPoint> getDomainEntryPoints( )
    {
        return domainEntryPoints;
    }


    public void setDomainEntryPoints( Set<DomainEntryPoint> theDomainEntryPoints )
    {
        domainEntryPoints = theDomainEntryPoints;
    }


    public String getWriteCdsVdm( )
    {
        return cdsVdm;
    }


    public void setWriteCdsVdm( String aCdsVdm )
    {
        cdsVdm = aCdsVdm;
    }


    public HashSet<String> getReadCdsVdms( )
    {
        if ( readCdsVdms == null )
        {
            readCdsVdms = new HashSet<String>();
        }

        return readCdsVdms;
    }


    public void setReadCdsVdms( HashSet<String> aCdsVdms )
    {
        readCdsVdms = aCdsVdms;
    }


    public Set<String> getVhimVersions( )
    {
        return vhimVersions;
    }


    public void setVhimVersions( Set<String> aVhimVersions )
    {
        vhimVersions = aVhimVersions;
    }

    private Set<VhimVersionWrapper> vhimVersionWrappers = null;


    // adding hibernate and template service specific methods
    public Set<VhimVersionWrapper> getVhimVersionWrappers( )
    {
        if ( vhimVersionWrappers == null && vhimVersions != null )
        {
            vhimVersionWrappers = new HashSet<VhimVersionWrapper>( vhimVersions.size() );
            VhimVersionWrapper vvw;
            for ( String vhimVersion : vhimVersions )
            {
                vvw = new VhimVersionWrapper();
                vvw.setVersion( vhimVersion );
                vhimVersionWrappers.add( vvw );
            }
        }

        return vhimVersionWrappers;
    }


    public void setVhimVersionWrappers( Set<VhimVersionWrapper> aVhimVersions )
    {
        vhimVersionWrappers = aVhimVersions;

        if ( vhimVersions == null && aVhimVersions != null )
        {
            vhimVersions = new HashSet<String>( aVhimVersions.size() );
            for ( VhimVersionWrapper vhimVersionWrapper : aVhimVersions )
            {
                vhimVersions.add( vhimVersionWrapper.getVersion() );
            }
        }
    }


    public String getTemplateId( )
    {
        return templateId;
    }


    public void setTemplateId( String theTemplateId )
    {
        templateId = theTemplateId;
    }


    public String getTemplateName( )
    {
        return templateName;
    }


    public void setTemplateName( String theTemplateName )
    {
        templateName = theTemplateName;
    }


    public String getTemplateDescription( )
    {
        return templateDescription;
    }


    public void setTemplateDescription( String theTemplateDescription )
    {
        templateDescription = theTemplateDescription;
    }


    public String getOperation( )
    {
        return operation;
    }


    public void setOperation( String theOperation )
    {
        operation = theOperation;
    }


    public boolean getTestOnly( )
    {
        return testOnly;
    }


    public void setTestOnly( boolean aTestOnly )
    {
        this.testOnly = aTestOnly;
    }


    public void setTestOnly( String aTrueOrFalse )
    {
        this.testOnly = Boolean.parseBoolean( aTrueOrFalse );
    }


    public Date getDateAdded( )
    {
        return dateAdded;
    }


    public void setDateAdded( Date dateAdded )
    {
        this.dateAdded = dateAdded;
    }


    public Date getDateDeprecated( )
    {
        return dateDeprecated;
    }


    public void setDateDeprecated( Date dateDeprecated )
    {
        this.dateDeprecated = dateDeprecated;
    }


    public Date getDateActivated( )
    {
        return dateActivated;
    }


    public void setDateActivated( Date dateActivated )
    {
        this.dateActivated = dateActivated;
    }


    public Date getDateDeactivated( )
    {
        return dateDeactivated;
    }


    public void setDateDeactivated( Date dateDeactivated )
    {
        this.dateDeactivated = dateDeactivated;
    }


    public Date getDateUpdated( )
    {
        return dateUpdated;
    }


    public void setDateUpdated( Date dateUpdated )
    {
        this.dateUpdated = dateUpdated;
    }


    public String getStatus( )
    {
        return status;
    }


    public void setStatus( String status )
    {
        this.status = status;
    }


    public void setTemplateJar( byte[] jar )
    {
        this.templateJar = jar;
    }


    public byte[] getTemplateJar( )
    {
        return templateJar;
    }


    @SuppressWarnings("unused")
    private void setBlob( Blob jar )
    {
        this.templateJar = toByteArray( jar );
    }


    @SuppressWarnings("unused")
    private Blob getBlob( )
    {
        return this.createBlob( this.templateJar );
    }


    /**
     * Method duplicates original functionality of the deprecated
     * Hibernate.createBlob - this method is the exact functionality for CDS use
     * it seems sufficient as we do not have a context to create a session to
     * get a LobCreator.
     * 
     * @param bytes
     * @return
     */
    private java.sql.Blob createBlob( byte[] bytes )
    {
        Blob blob = null;
        blob = NonContextualLobCreator.INSTANCE.wrap( NonContextualLobCreator.INSTANCE.createBlob( bytes ) );
        return blob;
    }


    private byte[] toByteArray( Blob fromJar )
    {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try
        {
            return toByteArrayImpl( fromJar, baos );
        }
        catch ( Exception e )
        {
        }

        return null;
    }


    private byte[] toByteArrayImpl( Blob fromJar, ByteArrayOutputStream baos ) 
        throws 
            SQLException, 
            IOException
    {
        byte buf[] = new byte[4000];
        int dataSize;
        InputStream is = fromJar.getBinaryStream();

        try
        {
            while ( ( dataSize = is.read( buf ) ) != -1 )
            {
                baos.write( buf, 0, dataSize );
            }
        }
        finally
        {
            if ( is != null )
            {
                is.close();
            }
        }

        return baos.toByteArray();
    }


    public String toString( )
    {
        return "id: " + getTemplateId() + ", name: " + getTemplateName() + ", desc: " + getTemplateDescription() + ", dateAdded: "
                + dateAdded + ", status: " + status + ", vhims: " + getVhimVersions() + ", domainEntryPoints: " + getDomainEntryPoints()
                + "\nBLOB size: " + getTemplateJar().length + ", value: " + getTemplateJar();
    }
}
