

package gov.va.med.tfs.tfdm;



import org.xml.sax.SAXException;

import java.io.Serializable;
import java.io.StringReader;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.xml.XMLConstants;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;


/**
 * This class implements the methods required for handling the Filter Cache Metadata. The Metadata consists
 * of: 
 * <li>FilterId
 * <li>Filter Schema (XSD)
 * <li>Validator
 * <li>VHIM Version
 * <li>Domain Entry Points
 * <br>
 * 
 */
public class FilterMetaData
    implements
        FilterMetaDataInterface,
        Serializable
{
    private String filterId;
    private String filterString;
    private Set<EntryFilter> entryFilters;
    private Set<String> vhimVersions;
    private Schema filterSchema;
    private String filterDescription;
    private boolean containsCorrelation;
    private Date dateAdded;
    private Date dateDeprecated;
    private Date dateActivated;
    private Date dateDeactivated;
    private Date dateUpdated;
    private String status;
    private String filterSchemaXml;


    /**
     * Get the filterId.
     * 
     * @return the filterId
     */
    public String getFilterId( )
    {
        return filterId;
    }


    /**
     * Set the filterId.
     * 
     * @param aFilterId the filterId to set
     */
    public void setFilterId( String aFilterId )
    {
        filterId = aFilterId;
    }


    /**
     * Get the filterSchema String which is the XML schema (XSD).
     * 
     * @return the filterSchemaString
     */
    public String getFilterString( )
    {
        return filterString;
    }


    /**
     * Set the Filter Schema String.
     * 
     * @param theFilterSchemaString the filterSchemaString to set
     */
    public void setFilterString( String aFilterString )
    {
        filterString = aFilterString;
    }

    
    public Set<String> getVhimVersions( )
    {
        return vhimVersions;
    }

    
    public void setVhimVersions( Set<String> aVhimVersions )
    {
        vhimVersions = aVhimVersions;
    }
    
    
    private Set<VhimVersionWrapper> vhimVersionWrappers = null;
    
    
    public Set<VhimVersionWrapper> getVhimVersionWrappers( )
    {
        if ( vhimVersionWrappers == null && vhimVersions != null )
        {
            vhimVersionWrappers = new HashSet<VhimVersionWrapper>( vhimVersions.size() );
            VhimVersionWrapper vvw;
            for ( String vhimVersion : vhimVersions )
            {
                vvw = new VhimVersionWrapper();
                vvw.setVersion( vhimVersion );
                vhimVersionWrappers.add( vvw );
            }
        }
        return vhimVersionWrappers;
    }
    
    
    public void setVhimVersionWrappers( Set<VhimVersionWrapper> aVhimVersionWrappers )
    {
        vhimVersionWrappers = aVhimVersionWrappers;
        
        if ( vhimVersions == null && aVhimVersionWrappers != null )
        {
            vhimVersions = new HashSet<String>( aVhimVersionWrappers.size() );
            for ( VhimVersionWrapper vhimVersionWrapper : aVhimVersionWrappers )
            {
                vhimVersions.add( vhimVersionWrapper.getVersion() );
            }
        }
    }

    
    /**
     * Get the Schema.
     * 
     * @return the schema associated with the filter
     */
    public Schema getFilterSchema( )
    {
        return filterSchema;
    }


    /**
     * Set the Filter Schema using the passed in schema.
     * 
     * @param aFilterSchema the schema
     */
    public void setFilterSchema( Schema aFilterSchema )
    {
        filterSchema = aFilterSchema;
    }
    
    
    public Date getDateAdded( )
    {
        return dateAdded;
    }


    public void setDateAdded( Date aDateAdded )
    {
        this.dateAdded = aDateAdded;
    }


    public Date getDateDeprecated( )
    {
        return dateDeprecated;
    }


    public void setDateDeprecated( Date aDateDeprecated )
    {
        this.dateDeprecated = aDateDeprecated;
    }


    public Date getDateActivated( )
    {
        return dateActivated;
    }


    public void setDateActivated( Date aDateActivated )
    {
        this.dateActivated = aDateActivated;
    }


    public Date getDateDeactivated( )
    {
        return dateDeactivated;
    }


    public void setDateDeactivated( Date aDateDeactivated )
    {
        this.dateDeactivated = aDateDeactivated;
    }


    public Date getDateUpdated( )
    {
        return dateUpdated;
    }


    public void setDateUpdated( Date aDateUpdated )
    {
        this.dateUpdated = aDateUpdated;
    }


    public String getStatus( )
    {
        return status;
    }


    public void setStatus( String aStatus )
    {
        this.status = aStatus;
    }

    public void setFilterSchemaXml( String aFilterSchemaXml )
    {
        this.filterSchemaXml = aFilterSchemaXml;
    }


    public String getFilterSchemaXml( )
    {
        return filterSchemaXml;
    }


    /**
     * Set the Filter Schema using the passed in string schema.
     * 
     * @param aFilterStringSchema the string schema
     */
    public void setFilterSchema( String aFilterStringSchema )
    {
        try
        {
            //SchemaFactory schemaFactory = SchemaFactory.newInstance( XMLConstants.W3C_XML_SCHEMA_NS_URI );
            SchemaFactory schemaFactory = SchemaFactory.newInstance( "http://www.w3.org/2001/XMLSchema-instance" );
            this.filterSchema = schemaFactory.newSchema( new StreamSource( new StringReader( aFilterStringSchema ) ) );
        }
        // TODO make better exception handling
        catch ( SAXException e )
        {
            throw new RuntimeException( "Provided Filter schema is invalid : " + filterId, e );
        }
    }


    public void setFilterDescription( String aFilterDescription )
    {
        this.filterDescription = aFilterDescription;
    }


    public String getFilterDescription( )
    {
        return filterDescription;
    }


    public void setContainsCorrelation( boolean aContainsCorrelation )
    {
        this.containsCorrelation = aContainsCorrelation;
    }


    public boolean isContainsCorrelation( )
    {
        return containsCorrelation;
    }


    public void setEntryFilters( Set<EntryFilter> aEntryFilters )
    {
        this.entryFilters = aEntryFilters;
    }


    public Set<EntryFilter> getEntryFilters( )
    {
        return entryFilters;
    }

    public String toString()
    {
        return "id: " + getFilterId() + ", desc: " + getFilterDescription() + ", dateAdded: " + dateAdded + ", status: " + status + ", vhims: " + getVhimVersions() + ", entryFilters: " + getEntryFilters() + "\nXML: " + getFilterSchemaXml();
    }

}
