

package gov.va.med.tfs.persistence.hibernate;


import java.util.List;

import gov.va.med.tfs.persistence.ReadPersistenceManagerInterface;
import gov.va.med.tfs.tfdm.FilterMetaData;
import gov.va.med.tfs.tfdm.TemplateMetaData;

import org.hibernate.query.Query;
import org.hibernate.Session;


public class ReadableHibernatePersistenceManager
    extends
        AbstractHibernatePersistenceManager
    implements
        ReadPersistenceManagerInterface
{

    protected TemplateMetaData readTemplateData( Session aSession, String aTemplateId )
    {
        TemplateMetaData queryResults = null;
        try
        {
            Query query = buildTemplateQuery( aSession, aTemplateId );
            
            queryResults = (TemplateMetaData)query.uniqueResult();
        }
        catch ( Exception e )
        {
            e.printStackTrace();
        }

        return queryResults;
    }


    protected FilterMetaData readFilterData( Session aSession, String aFilterId )
    {
        FilterMetaData queryResults = null;
        try
        {
            Query query = buildFilterQuery( aSession, aFilterId );
            
            queryResults = (FilterMetaData)query.uniqueResult();
        }
        catch ( Exception e )
        {
            e.printStackTrace();
        }

        return queryResults;
    }


    /** public entry point to this class **/
    public TemplateMetaData readTemplateData( String aTemplateId )
        throws Exception
    {
        // TODO change for transactional use
//        Session session = sessionFactory.getCurrentSession();  // used with transactions
        Session session = sessionFactory.openSession();
        TemplateMetaData hibernateQueryResult = null;

        try
        {
            hibernateQueryResult = readTemplateData( session, aTemplateId );
        }
        finally
        {
            // Multiple read requests will be coming here so needed to clear cache between calls
            session.clear();
        }

        return hibernateQueryResult;
    }

    /** public entry point to this class **/
    public FilterMetaData readFilterData( String aFilterId )
        throws Exception
    {
        // TODO change for transactional use
//        Session session = sessionFactory.getCurrentSession();  // used with transactions
        Session session = sessionFactory.openSession();
        FilterMetaData hibernateQueryResult = null;

        try
        {
            hibernateQueryResult = readFilterData( session, aFilterId );
        }
        finally
        {
            // Multiple read requests will be coming here so needed to clear cache between calls
            session.clear();
        }

        return hibernateQueryResult;
    }

    @SuppressWarnings( "unchecked" )
    public List<String> readActiveTemplateIds( String vhimVersion )
    {
        Session session = sessionFactory.openSession();
        Query query = session.getNamedQuery( "TemplateSchemaIdsByStatus" );
        query.setParameter( "vhimVersion", vhimVersion );
        query.setParameter( "status", "ACTIVE" );

        List<String> templates = query.list();
        return templates;
    }
    
    
    @SuppressWarnings( "unchecked" )
    public List<String> readActiveFilterIds( String vhimVersion )
    {
        Session session = sessionFactory.openSession();
        Query query = session.getNamedQuery( "FilterSchemaIdsByStatus" );
        query.setParameter( "vhimVersion", vhimVersion );
        query.setParameter( "status", "ACTIVE" );

        List<String> templates = query.list();
        return templates;
    }
    
    
    private Query buildTemplateQuery( Session aSession, String aTemplateId )
        throws Exception
    {
        String queryName = "TemplateSchemaIdByStatus";
        Query query = aSession.getNamedQuery( queryName );
    
        query.setParameter( "templateId", aTemplateId );
        query.setParameter( "status", "ACTIVE" );
        return query;
    }


    private Query buildFilterQuery( Session aSession, String aFilterId )
        throws Exception
    {
        String queryName = "FilterSchemaIdByStatus";
        Query query = aSession.getNamedQuery( queryName );
    
        query.setParameter( "filterId", aFilterId );
        query.setParameter( "status", "ACTIVE" );
        return query;
    }


    public String getManagerIdentifier( )
    {
        // TODO figure out TFS persistence manager identifier
        return null;
    }
    
    @SuppressWarnings( "unchecked" )
    public List<String> readVhimVersions( )
    {
        Session session = sessionFactory.openSession();
        Query query = session.getNamedQuery( "AllVhimVersions" );


        List<String> vhimVersions = query.list();
        return vhimVersions;
    }
       

}
