package gov.va.med.tfs.persistence.hibernate;


import gov.va.med.tfs.persistence.DeletePersistenceManagerInterface;
import gov.va.med.tfs.tfdm.FilterMetaData;
import gov.va.med.tfs.tfdm.TemplateMetaData;

import org.hibernate.query.Query;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.hibernate.Session;

@EnableTransactionManagement
@EnableAspectJAutoProxy
public class DeletableHibernatePersistenceManager
    extends
        AbstractHibernatePersistenceManager
    implements
        DeletePersistenceManagerInterface
{
    private String DELETE_FILTER_SUCCESSFUL = "Sucessfully Deleted Filter - Thank You";
    private String FILTER_NO_EXISTS = "Filter Not Found -- Filter Not Deleted";
    private String DELETING_FILTER = "Deleting Filter";
    private String DELETE_TEMPLATE_SUCCESSFUL = "Sucessfully Deleted Template - Thank You";
    private String TEMPLATE_NO_EXISTS = "Template Not Found -- Template Not Deleted";
    private String DELETING_TEMPLATE = "Deleting Template";

    /** public entry point to this class **/
    @Transactional(value="hdr2TransactionManager", propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, readOnly=false)   
    public String deleteTemplateData( String aTemplateId )
        throws Exception
    {
        // TODO change for transactional use
        Session session = sessionFactory.getCurrentSession();  // used with transactions
        //Session session = sessionFactory.openSession();
        TemplateMetaData hibernateQueryResult = null;
        String hibernateDeleteResult = DELETING_TEMPLATE;
        Query query = session.getNamedQuery( "TemplateSchemaId" ).setParameter( "templateId", aTemplateId );
                
        try
        {
        	hibernateQueryResult = (TemplateMetaData)query.uniqueResult();
        	if ( hibernateQueryResult != null )
        	{
        		session.delete( hibernateQueryResult );
        		session.flush();
        		hibernateDeleteResult = DELETE_TEMPLATE_SUCCESSFUL;
        	} else
        	{
        		hibernateDeleteResult = TEMPLATE_NO_EXISTS;
        	}        	
        }
        finally
        {
            // Multiple read requests will be coming here so needed to clear cache between calls
            session.clear();
        }

        return hibernateDeleteResult;
    }

    /** public entry point to this class **/
    @Transactional(value="hdr2TransactionManager", propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, readOnly=false)    
    public String deleteFilterData( String aFilterId )
        throws Exception
    {
        // TODO change for transactional use
        Session session = sessionFactory.getCurrentSession();  // used with transactions
        //Session session = sessionFactory.openSession();
        FilterMetaData hibernateQueryResult = null;
        String hibernateDeleteResult = DELETING_FILTER;
        Query query = session.getNamedQuery( "FilterSchemaId" ).setParameter( "filterId", aFilterId );
        
        try
        {
        	hibernateQueryResult = (FilterMetaData)query.uniqueResult();
        	if ( hibernateQueryResult != null )
        	{
        		session.delete( hibernateQueryResult );
        		session.flush();
        		hibernateDeleteResult = DELETE_FILTER_SUCCESSFUL;
        	} else
        	{
        		hibernateDeleteResult = FILTER_NO_EXISTS;
        	}
        }
        finally
        {
            // Multiple read requests will be coming here so needed to clear cache between calls
            session.clear();
        }

        return hibernateDeleteResult;
    }
}
