package gov.va.med.tfs.persistence.hibernate;


import gov.va.med.tfs.tfdm.TemplateMetaData;
import gov.va.med.tfs.tfdm.TemplateMetaDataInterface;
import gov.va.med.tfs.persistence.CreateTemplatePersistenceManagerInterface;
import gov.va.med.tfs.persistence.hibernate.AbstractTfsHibernatePersistenceManager;

/*import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.hibernate.HibernateException;*/
import org.hibernate.query.Query;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.hibernate.Session;


@EnableTransactionManagement
@EnableAspectJAutoProxy
public class CreatableHibernateTemplatePersistenceManager
    extends
        AbstractTfsHibernatePersistenceManager
    implements
        CreateTemplatePersistenceManagerInterface
{
	
    private String PERSIST_SUCCESSFUL = "Sucessfully Persisted Template - Thank You";
    private String RECORD_EXISTS = "Record already exists -- Template Not Persisted";
    private String PERSISTING_RECORD = "Persisting Record";
 
    /**
     * Persists a single templates to the template_schema table.
     * 
     * @param aInputStream an {@code InputStream} of the template. This is expected to be a Java archive (jar) file.
     * @param aTemplateMetaData meta data referring to the template to be persisted. This information is also persisted
     *            in the template_schema table.
     * @throws TemplateCacheException if exception occurs during the database persistence of the template
     */
    @Transactional(value="hdr2TransactionManager", propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, readOnly=false)    
    public final String createTemplateData( TemplateMetaDataInterface aTemplateMetaData )
        throws Exception
    {
        Session session = this.sessionFactory.getCurrentSession();
    	//Session session = sessionFactory.openSession();
        /*
         * JLA Fortify Quality Code Scan, Poor Style: Value Never Read
         *   commenting out persistReturn
         */
//    	String persistReturn = PERSISTING_RECORD;
        
       	persistifyVhimVersions( session, aTemplateMetaData.getVhimVersionWrappers() );
        
        persistifyDomainEntryPoints( session, aTemplateMetaData.getDomainEntryPoints() );
        
        //persistReturn = persistifyTemplate( session, aTemplateMetaData );
        return persistifyTemplate( session, aTemplateMetaData );
        
        /*if ( persistReturn.equals(PERSIST_SUCCESSFUL) )
        {
         	session.flush();
        }
        
        session.close();
        return persistReturn;*/

    }

    private String persistifyTemplate( Session aSession, TemplateMetaDataInterface aTemplateMetaData )
    {
        TemplateMetaData queryResult = null;
        String persistifyTemplateReturn = RECORD_EXISTS;
        
        // check to see if that template already exists in the database
        // if it does, replace the one in the TMD collection with the persistent version.
        Query query = aSession.getNamedQuery( "TemplateSchemaId" ).setParameter( "templateId", aTemplateMetaData.getTemplateId() );
        queryResult = (TemplateMetaData)query.uniqueResult();
            
        if ( queryResult == null )
        {
            aSession.save( aTemplateMetaData );
            persistifyTemplateReturn = PERSIST_SUCCESSFUL;
            // we never give back the persistent object if it already existed - hope that's not a problem.
        }
        return persistifyTemplateReturn;
    }
    
}
