insert into tfr.vhim_version (select * from filters.vhim_version);

insert into tfr.domain_entry_point  (select domain_entry_point_id, name, 'TEMP' from filters.domain_entry_point);

insert into tfr.entry_filter columns(entry_filter_id, domain_entry_point_id) (select * from filters.entry_filter);

INSERT INTO TFR.FILTER_SCHEMA (
   FILTER_SCHEMA_ID, 
   FILTER_IDENTIFIER, 
   FILTER_SCHEMA_TXT, 
   CONTAINS_CORRELATION
) 
(select  FILTER_SCHEMA_ID, 
   FILTER_IDENTIFIER, 
   FILTER_SCHEMA_TXT, 
   CONTAINS_CORRELATION
 from filters.filter_schema);

insert into tfr.filter_schema_entry_filter (select * from filters.filter_schema_entry_filter);

INSERT INTO TFR.TEMPLATE_SCHEMA (
   TEMPLATE_SCHEMA_ID, 
   TEMPLATE_ID, 
   REQUEST_TYPE, 
   TEMPLATE_NAME, 
   TEMPLATE_DESCRIPTION, 
   TEST_ONLY, 
   TEMPLATE_SCHEMA_BLOB
) 
SELECT 
T.TEMPLATE_SCHEMA_ID, 
T.TEMPLATE_ID,
--(select vhim_version_id from tfr.vhim_version v 
-- where substr(t.vhim_version,2,length(t.vhim_version)-2) = v.vhim_version_txt),
   --T.ENTRY_POINT, 
   T.REQUEST_TYPE, 
   T.TEMPLATE_NAME, 
   T.TEMPLATE_DESCRIPTION, 
  -- T.TARGET_NAMESPACE, 
  -- T.CLINICAL_DOMAIN, 
   T.TEST_ONLY, 
   T.TEMPLATE_SCHEMA_BLOB
FROM TEMPLATES.TEMPLATE_SCHEMA T
;


COMMIT;


------
-- MANY-TO-MANYS
-------

insert into tfr.template_schema_vhim_version
( template_schema_id, vhim_version_id )
select template_schema_id, (select vhim_version_id from tfr.vhim_version)
 from tfr.template_schema 
;


insert into tfr.filter_schema_vhim_version
( filter_schema_id, vhim_version_id )
select filter_schema_id, (select vhim_version_id from tfr.vhim_version)
 from tfr.filter_schema 
;


COMMIT;

-- get first entry points
insert into tfr.template_schema_entry_point
(
  select template_schema_id,
         nvl(
              (select domain_entry_point_id from tfr.domain_entry_point d
                where substr(t.entry_point,2,length(t.entry_point)-2) = d.name),
              (select domain_entry_point_id from tfr.domain_entry_point dep where dep.name = 'IntoleranceCondition')
            ) 
 from templates.template_schema t
);

-- get 2nds of entry points
insert into tfr.template_schema_entry_point
(
  select template_schema_id,
         (select domain_entry_point_id from tfr.domain_entry_point d
          where substr(t.entry_point, INSTR(t.entry_point, ',')+2,
          INSTR(t.entry_point, ']')-INSTR(t.entry_point, ',')-2) = d.name)
 from templates.template_schema t
 where instr(t.entry_point,',') > 0
);

COMMIT;


update tfr.domain_entry_point
set domain = 'ALLERGY'
where name in('IntoleranceCondition','AllergyAssessment');

update tfr.domain_entry_point
set domain = 'VITAL'
where name in('VitalSignObservationEvent');

update tfr.domain_entry_point
set domain = 'PHARMACY'
where name in('OutpatientMedicationPromise');

update tfr.domain_entry_point
set domain = 'LAB'
where name in('LabTestPromise');


COMMIT;


-- Need to update XPath in ENTRY_FILTER
-- Need to update FILTER_SCHEMA with filter descriptions
-- Need to update FILTER_SCHEMA with date and status attributes
-- Need to update TEMPLATE_SCHEMA with date and status attributes


