

package gov.va.med.tfs.mapping.tfstocds;


import gov.va.med.tfs.client.webservice.DomainEntryPoint;
import gov.va.med.tfs.client.webservice.TemplateMetaData;
import gov.va.med.tfs.mapping.MapperInterface;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.xml.datatype.XMLGregorianCalendar;


public class TemplateMetaDataMapper
    implements
        MapperInterface<TemplateMetaData, gov.va.med.cds.clinicaldata.TemplateMetaData>
{
    private static TemplateMetaDataMapper templateMetaDataMapper = new TemplateMetaDataMapper();


    private TemplateMetaDataMapper( )
    {
    }


    public static TemplateMetaDataMapper getInstance( )
    {
        return templateMetaDataMapper;
    }


    @Override
    public gov.va.med.cds.clinicaldata.TemplateMetaData map( TemplateMetaData fromTfsTemplateMetaData )
        throws Exception
    {
        gov.va.med.cds.clinicaldata.TemplateMetaData toCdsTemplateMetaData = new gov.va.med.cds.clinicaldata.TemplateMetaData();

        XMLGregorianCalendar fromTfsDateActivated = fromTfsTemplateMetaData.getDateActivated();
        if ( fromTfsDateActivated != null )
        {
            toCdsTemplateMetaData.setDateActivated( fromTfsDateActivated.toGregorianCalendar().getTime() );
        }

        XMLGregorianCalendar fromTfsDateAdded = fromTfsTemplateMetaData.getDateAdded();
        if ( fromTfsDateAdded != null )
        {
            toCdsTemplateMetaData.setDateAdded( fromTfsDateAdded.toGregorianCalendar().getTime() );
        }

        XMLGregorianCalendar fromTfsDateDeactivated = fromTfsTemplateMetaData.getDateDeactivated();
        if ( fromTfsDateDeactivated != null )
        {
            toCdsTemplateMetaData.setDateDeactivated( fromTfsDateDeactivated.toGregorianCalendar().getTime() );
        }

        XMLGregorianCalendar fromTfsDateDeprecated = fromTfsTemplateMetaData.getDateDeprecated();
        if ( fromTfsDateDeprecated != null )
        {
            toCdsTemplateMetaData.setDateDeprecated( fromTfsDateDeprecated.toGregorianCalendar().getTime() );
        }

        XMLGregorianCalendar fromTfsDateUpdated = fromTfsTemplateMetaData.getDateUpdated();
        if ( fromTfsDateUpdated != null )
        {
            toCdsTemplateMetaData.setDateUpdated( fromTfsDateUpdated.toGregorianCalendar().getTime() );
        }

        List<DomainEntryPoint> fromTfsDomainEntryPoints = fromTfsTemplateMetaData.getDomainEntryPoints();

        if ( fromTfsDomainEntryPoints != null )
        {
            Set<gov.va.med.cds.clinicaldata.DomainEntryPoint> toCdsDomainEntryPoints = new HashSet<gov.va.med.cds.clinicaldata.DomainEntryPoint>();
            for ( DomainEntryPoint fromTfsDomainEntryPoint : fromTfsDomainEntryPoints )
            {
                if ( fromTfsDomainEntryPoint != null )
                {
                    toCdsDomainEntryPoints.add( DomainEntryPointMapper.getInstance().map( fromTfsDomainEntryPoint ) );
                }
            }
            toCdsTemplateMetaData.setDomainEntryPoints( toCdsDomainEntryPoints );
        }

        String fromTfsOperation = fromTfsTemplateMetaData.getOperation();
        if ( fromTfsOperation != null )
        {
            toCdsTemplateMetaData.setOperationAsString( fromTfsOperation );
        }

        List<String> fromTfsReadCdsVdms = fromTfsTemplateMetaData.getReadCdsVdms();

        if ( fromTfsReadCdsVdms != null )
        {
            HashSet<String> toCdsReadCdsVdms = new HashSet<String>();
            for ( String fromTfsReadCdsVdm : fromTfsReadCdsVdms )
            {
                if ( fromTfsReadCdsVdm != null )
                {
                    toCdsReadCdsVdms.add( fromTfsReadCdsVdm );
                }
            }
            toCdsTemplateMetaData.setReadCdsVdms( toCdsReadCdsVdms );
        }

        String fromTfsStatus = fromTfsTemplateMetaData.getStatus();
        if ( fromTfsStatus != null )
        {
            toCdsTemplateMetaData.setStatus( fromTfsStatus );
        }

        String fromTfsTemplateDescription = fromTfsTemplateMetaData.getTemplateDescription();
        if ( fromTfsTemplateDescription != null )
        {
            toCdsTemplateMetaData.setTemplateDescription( fromTfsTemplateDescription );
        }

        String fromTfsTemplateId = fromTfsTemplateMetaData.getTemplateId();
        if ( fromTfsTemplateId != null )
        {
            toCdsTemplateMetaData.setTemplateId( fromTfsTemplateId );
        }

        byte[] fromTfsTemplateJar = fromTfsTemplateMetaData.getTemplateJar();
        if ( fromTfsTemplateJar != null )
        {
            toCdsTemplateMetaData.setTemplateJar( fromTfsTemplateJar );
        }

        String fromTfsTemplateName = fromTfsTemplateMetaData.getTemplateName();
        if ( fromTfsTemplateName != null )
        {
            toCdsTemplateMetaData.setTemplateName( fromTfsTemplateName );
        }

        boolean fromTfsTestOnly = fromTfsTemplateMetaData.isTestOnly();
        toCdsTemplateMetaData.setTestOnly( fromTfsTestOnly );

        List<String> fromTfsVhimVersions = fromTfsTemplateMetaData.getVhimVersions();

        if ( fromTfsVhimVersions != null )
        {
            toCdsTemplateMetaData.setVhimVersions( new HashSet<String>( fromTfsVhimVersions ) );
        }

        String fromTfsWriteCdsVdm = fromTfsTemplateMetaData.getWriteCdsVdm();
        if ( fromTfsWriteCdsVdm != null )
        {
            toCdsTemplateMetaData.setWriteCdsVdm( fromTfsWriteCdsVdm );
        }

        return toCdsTemplateMetaData;
    }

}
