

package gov.va.med.cds.socket.server.handler;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.hapi.HL7SupportException;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.logger.ApplicationLoggerInterface;

import java.util.Map;

import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;

import ca.uhn.hl7v2.validation.ValidationException;


@RunWith( SuiteAwareRunner.class )
public class MappingResponseGeneratorTest
{
    private static final String MSG_CTRL_ID = "00000000000001";
    ApplicationLoggerInterface loggerMock = EasyMock.createMock( ApplicationLoggerInterface.class );


	@Test
    @Suite( groups = "checkintest" )
    public void testCreateDefaultResponse( )
    {
         //Test that default response generator is used to create response error when validation failed
         // Message type is not supported
        MappingResponseGenerator responseGenerator = new MappingResponseGenerator();

        Map<String, ResponseGeneratorInterface> responseGeneratorMapMock = EasyMock.createMock( Map.class );
        responseGenerator.setResponseGeneratorMap( responseGeneratorMapMock );

        String response = null;
        String envSpecProcessingId = "T";
        Exception exception = new ValidationException();
        HL7SupportInterface requestHl7SupportMock = EasyMock.createMock( HL7SupportInterface.class );

        EasyMock.expect( requestHl7SupportMock.getSendingApplication() ).andReturn( "Bar" );
        EasyMock.expect( requestHl7SupportMock.getMessageType() ).andReturn( "Foo" );

        EasyMock.expect( responseGeneratorMapMock.get( EasyMock.eq( "Bar~Foo" ) ) ).andReturn( ( ResponseGeneratorInterface )null );
        ResponseGeneratorInterface responseGeneratorMock = EasyMock.createMock( ResponseGeneratorInterface.class );
        EasyMock.expect( responseGeneratorMapMock.get( EasyMock.eq( "DEFAULT" ) ) ).andReturn( responseGeneratorMock );

        EasyMock.expect(responseGeneratorMock.createResponse( EasyMock.isA( HL7SupportInterface.class ), EasyMock.eq( "msg" ), EasyMock.eq( envSpecProcessingId ), EasyMock.eq( response ),
        		EasyMock.eq(MSG_CTRL_ID), EasyMock.eq( exception ) ) ).andReturn( "default error message" );
        EasyMock.replay( requestHl7SupportMock, responseGeneratorMapMock, responseGeneratorMock );

        responseGenerator.createResponse( requestHl7SupportMock, "msg", envSpecProcessingId, response, MSG_CTRL_ID, exception );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testLogIfExceptionThrownWhenParsing( )
    {
        //Test that if parsing Exception is thrown it will be logged in
        MappingResponseGenerator responseGenerator = new MappingResponseGenerator();
        responseGenerator.setLogger( loggerMock );
//        {
//            @Override
//            ApplicationLoggerInterface getLogger( )
//            {
//                return loggerMock;
//            }
//        };

        Exception exception = new ValidationException();
        Map<String, ResponseGeneratorInterface> responseGeneratorMapMock = EasyMock.createMock( Map.class );
        responseGenerator.setResponseGeneratorMap( responseGeneratorMapMock );

        String response = null;
        String envSpecProcessingId = "T";
        Exception hl7SupportException = new HL7SupportException( ErrorCodeEnum.HL7_SUPPORT_HAPI_TERSE_EXCEPTION);

        HL7SupportInterface requestHl7SupportMock = EasyMock.createMock( HL7SupportInterface.class );

        // Log exception
        EasyMock.expect( requestHl7SupportMock.getSendingApplication() ).andThrow( hl7SupportException );
        loggerMock.logMessage( "Error while parsing message for Sending Application and Message Type. ", hl7SupportException );

        ResponseGeneratorInterface responseGeneratorMock = EasyMock.createMock( ResponseGeneratorInterface.class );
        EasyMock.expect( responseGeneratorMapMock.get( EasyMock.eq( "DEFAULT" ) ) ).andReturn( responseGeneratorMock );

        // Response generator uses validation exception for error response message
        EasyMock.expect( responseGeneratorMock.createResponse(
                                        EasyMock.isA( HL7SupportInterface.class ),
                                        EasyMock.eq( "msg" ),
                                        EasyMock.eq( envSpecProcessingId ),
                                        EasyMock.eq( response ),
                                        EasyMock.isA(String.class), EasyMock.eq( exception ) ) ).andReturn( "some error message" );
        EasyMock.replay( requestHl7SupportMock, responseGeneratorMapMock, responseGeneratorMock, loggerMock );

        responseGenerator.createResponse( requestHl7SupportMock, "msg", envSpecProcessingId, response, MSG_CTRL_ID, exception );
    }

}
