

package gov.va.med.cds.socket.server.handler;


import static org.junit.Assert.*;
import junit.framework.Assert;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.hapi.HL7SupportException;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class ChdrLegacyResponseGeneratorTest
{

    @Test
    @Suite( groups = "checkintest" )
    public void testCreateResponse( )
    {
        // When no exceptions during processing hl7 message, just send response message from 
        // EJB back to client
        ChdrLegacyResponseGenerator responseGenerator = new ChdrLegacyResponseGenerator();

        Exception exception = null;
        String response = "success hl7 CHDR response";
        HL7SupportInterface hl7Support = null;
        String actual = responseGenerator.createResponse( hl7Support, "msg", null, response, null, exception );
        Assert.assertEquals( response, actual );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testCreateErrorResponse( )
    {
        //Use hl7 to create generic error message
        ChdrLegacyResponseGenerator responseGenerator = new ChdrLegacyResponseGenerator();

        HL7SupportException hl7SupportException = new HL7SupportException( ErrorCodeEnum.HL7_SUPPORT_HAPI_TERSE_EXCEPTION);
        HL7SupportInterface hl7Support = EasyMock.createMock( HL7SupportInterface.class );
        
        // Set expectations for hl7support
        EasyMock.expect(hl7Support.getSendingApplication()).andReturn("CHDR SENDER");
        EasyMock.expect(hl7Support.getSendingFacility()).andReturn("CHDR");
        EasyMock.expect(hl7Support.createMessageDateTime()).andReturn("20080620150649.582-0400");
        
        EasyMock.replay( hl7Support );
        
        String actual = responseGenerator.createResponse( hl7Support, "msg", null, null, null, hl7SupportException );
        
        String expected = "BHS^~|\\&^VHA_HDR^^CHDR SENDER^CHDR^20080620150649.582-0400\rERR^OBR~~~100&SF\rBTS^0";
        Assert.assertEquals( expected, actual );
    }

    @Test
    @Suite( groups = "checkintest" )
    // Test if parsing exception thrown while creating error response - response is not null
    public void testCreateErrorResponse_ParsingException( )
    {
        //Use hl7 to create generic error message
        ChdrLegacyResponseGenerator responseGenerator = new ChdrLegacyResponseGenerator();

        HL7SupportException hl7SupportException = new HL7SupportException( ErrorCodeEnum.HL7_SUPPORT_HAPI_TERSE_EXCEPTION);
        HL7SupportInterface hl7Support = EasyMock.createMock( HL7SupportInterface.class );
        
        // Set expectations for hl7support
        EasyMock.expect(hl7Support.getSendingApplication()).andThrow(new HL7SupportException( ErrorCodeEnum.HL7_SUPPORT_HAPI_TERSE_EXCEPTION));
        EasyMock.expect(hl7Support.getSendingFacility()).andThrow(new HL7SupportException( ErrorCodeEnum.HL7_SUPPORT_HAPI_TERSE_EXCEPTION));
        EasyMock.expect(hl7Support.createMessageDateTime()).andThrow(new HL7SupportException( ErrorCodeEnum.HL7_SUPPORT_HAPI_TERSE_EXCEPTION));;
        
        EasyMock.replay( hl7Support );
        
        String actual = responseGenerator.createResponse( hl7Support, "msg", null, null, null, hl7SupportException );
        Assert.assertNotNull( actual );
    }


}
