

package gov.va.med.cds.socket.server.handler;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.hapi.HL7SupportException;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import junit.framework.Assert;

import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class AbstractResponseGeneratorTest
{
    // Create concrete class to test abstract base class
    class ResponseGeneratorTest
        extends
            AbstractResponseGenerator
    {

        public String createResponse( HL7SupportInterface hl7Support, String writeRequest, String envSpecProcessingId, String response, String responseMessageControlId, Exception exception )
        {
            return null;
        }
        
        public String createResponse( HL7SupportInterface hl7Support, String writeRequest,  String response, String responseMessageControlId, Exception exception )
        {
            return null;
        }
    };


    @Test
    @Suite( groups = "checkintest" )
    public void testGetErrorText_HL7SupportException( )
    {
        ResponseGeneratorTest baseGenerator = new ResponseGeneratorTest();

        Exception ex = new HL7SupportException( ErrorCodeEnum.HL7_SUPPORT_HAPI_PARSE_EXCEPTION, "Mock Error Message" );
        String actual = baseGenerator.getErrorText( ex );
        String expected = "Error parsing message.";
        Assert.assertEquals( expected, actual );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetErrorText_AccessValidatorException( )
    {
        ResponseGeneratorTest baseGenerator = new ResponseGeneratorTest();
        String[] customMsgValues = { "Foo Bar", };
        Exception ex = new AccessValidatorException( ErrorCodeEnum.ACCESSOR_ENTRYPOINT_INVALID, new Exception( "Boom" ), customMsgValues );
        String actual = baseGenerator.getErrorText( ex );
        String expected = "Entrypoint Foo Bar is not valid";
        Assert.assertEquals( expected, actual );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetErrorText_RuntimeException( )
    {
        ResponseGeneratorTest baseGenerator = new ResponseGeneratorTest();
        Exception ex = new RuntimeException( "Boom !" );
        String actual = baseGenerator.getErrorText( ex );
        String expected = "Boom !";
        Assert.assertEquals( expected, actual );
    }


    @Suite( groups = "checkintest" )
    public void testGetErrorText_VeryLongMessageTruncated( )
    {
        ResponseGeneratorTest baseGenerator = new ResponseGeneratorTest();
        Exception ex = new Exception( "Boom ---------------------------------------------------------------------------------!" );
        String actual = baseGenerator.getErrorText( ex );
        Assert.assertEquals( 80, actual.length() );
    }

}
