

package gov.va.med.cds.socket.server.handler;


import gov.va.med.cds.hapi.HL7SupportException;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.hapi.HL7Utility;
import org.springframework.util.StringUtils;
import gov.va.med.mediator.client.messagemediator.JmsMessageMediatorDelegate;
import gov.va.med.cds.hapi.Hl7SupportHdrLegacy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class SimpleVistACommitAckResponseGenerator
    extends
        AbstractResponseGenerator
{
    private static Log logger = LogFactory.getLog( SimpleVistACommitAckResponseGenerator.class );

    final static String COMMIT_ACK = "CA";
    final static String COMMIT_ERROR = "CE";
    final static String COMMIT_REJECT = "CR";


    /*
     * JLA Fortify Quality Code Scan - Dead Code: Unused Method
     *   commenting out method
    private String getMessageData( HL7SupportInterface aHl7Support, String aTerserPath, String aDefaultValue )
    {
        String messageData = aDefaultValue;

        if ( aHl7Support != null )
        {
            try
            {
                messageData = aHl7Support.getMessageData( aTerserPath );
            }
            catch ( Exception ex )
            {
                // Swallow the exception
            }
        }

        return messageData;
    }
     */


    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.socket.server.handler.ResponseGeneratorInterface#createResponse(gov.va.med.cds.hapi.HL7SupportInterface, java.lang.String, java.lang.Exception)
     */
    public String createResponse( HL7SupportInterface aRequestHl7Support, String aWriteRequest, String anEnvSpecProcessingId, String aResponse,
                    String aResponseMessageControlId, Exception aException )
    {
        HL7SupportInterface hl7Support = null;
        String commitAck = null;
        String msgProcessingId = null;
        /*
         * JLA Fortify Quality Code Scan - Poor Style: Value Never Read
         *   commenting out messageControlId
        String messageControlId = null;
         */
        String commitAckMsg = null;
        String errorText = "";

        if ( aRequestHl7Support == null )
        {
            hl7Support = new Hl7SupportHdrLegacy( aWriteRequest );
        }
        else
        {
            hl7Support = aRequestHl7Support;
        }

        try
        {
            commitAck = getCommitAck( hl7Support, aWriteRequest, "/MSH-15", "ERROR-MSH-15" );
            msgProcessingId = getRequestData( hl7Support, "/MSH-11", "ERROR-MSH-11" );
            /*
             * JLA Fortify Quality Code Scan - Poor Style: Value Never Read
             *   commenting out messageControlId
             *   Need to talk with Sreedevi Kondapalli about this. 
             *   Is this value supposed to be used in the call below to hl7Support.getCommitAcknowledgement?
            messageControlId = getRequestData( hl7Support, "/MSH-10", "ERROR-MSH-10" );
             */
        }
        catch ( Exception e )
        {
            aException = e;
            logger.error( "Fatal error invalid HL7 message", e );
        }

        if ( aException != null )
        {
            errorText = getErrorText( aException );
        }
        else if ( ( aResponse != null ) && aResponse.startsWith( "<" + JmsMessageMediatorDelegate.ERROR_SECTION ) )
        {
            errorText = ( stripErrorSection( aResponse ) );
        }

        boolean isCommitAckType = false;

        try
        {
            isCommitAckType = hl7Support.requiresAcknowledgment( commitAck );
        }
        catch ( Exception e )
        {
            logger.error( "Invalid commit ack", e );
        }
        try
        {
            if ( !isCommitAckType )
            {
                commitAckMsg = null;
            }
            else
            {
                commitAckMsg = hl7Support.getCommitAcknowledgement( getAckType( aException, aResponse, msgProcessingId, anEnvSpecProcessingId ),
                                commitAck, errorText, aResponseMessageControlId, anEnvSpecProcessingId );
            }
        }
        catch ( Exception e )
        {
            logger.error( "Error creating commit ack", e );
        }

        return commitAckMsg;
    }


    /**
     * Removes error section tags form error message to form an error text from it for the Ack.
     * @param aResponse
     * @return
     */
    protected String stripErrorSection( String aResponse )
    {
        String returnStrippedErrorSection = null;

        if ( ( aResponse == null ) || aResponse.equals( JmsMessageMediatorDelegate.SUCCESS ) )
        {
            returnStrippedErrorSection = "";
        }
        else
        {
            // skip <errorSection> at the beginning
            int front = JmsMessageMediatorDelegate.ERROR_SECTION.length() + 2;

            // skip </errorSection> at the end
            int back = JmsMessageMediatorDelegate.ERROR_SECTION.length() + 3;

            String errorText = aResponse.substring( front, aResponse.length() - back );

            returnStrippedErrorSection = trimLengthToEighty( errorText );
        }

        return returnStrippedErrorSection;
    }


    private String getRequestData( HL7SupportInterface aHl7Support, String aTerserPath, String aDefaultVaule )
    {
        String messageData = aDefaultVaule;

        try
        {
            messageData = aHl7Support.getMessageData( aTerserPath );
        }
        catch ( Exception ex )
        {
            /* Swallow the exception */
        }

        return messageData;
    }


    private String getAckType( Exception anException, String aResponse, String aMsgProcessingId, String anEnvSpecProcessingId )
    {
        String returnAckType = null;

        if ( ( anException == null ) && aResponse.equals( JmsMessageMediatorDelegate.SUCCESS ) )
        {
            returnAckType = COMMIT_ACK;
        }
        else
        {
            if ( ( anException instanceof HL7SupportException ) || ( anException instanceof AccessValidatorException )
                            || ( !aMsgProcessingId.equals( anEnvSpecProcessingId ) ) )
            {
                returnAckType = COMMIT_REJECT;
            }
            else
            {
                returnAckType = COMMIT_ERROR;
            }
        }

        return returnAckType;
    }


    private String getCommitAck( HL7SupportInterface aHl7Support, String aWriteRequest, String aTerserPath, String aDefaultValue )
    {
        String messageData = aDefaultValue;

        try
        {
            messageData = aHl7Support.getMessageData( aTerserPath );
        }
        catch ( Exception ex )
        {
            //invalid MSH
            java.lang.String[] msg = StringUtils.tokenizeToStringArray( aWriteRequest, "^" );

            for ( int i = 0; i <= msg.length; i++ )
            {
                /*
                 * JLA Fortify Quality Code Scan - Code Correctness: Erroneous String Compare
                 *   changing == to .equal
                if ( ( msg[9] == "2.4" ) || ( msg[12].startsWith( "USA" ) ) )
                 */
                if ( msg[9].equals( "2.4" ) || msg[12].startsWith( "USA" ) ) 
                {
                    if ( StringUtils.hasLength( msg[10] ) )
                    {
                        messageData = msg[10];
                    }
                    break;
                }
                else if ( i >= 13 )
                {
                    logger.error( "Invalid MSH segment" );
                    break;
                }
            }
        }

        return messageData;
    }


    String createMessageDateTime( )
    {
        return HL7Utility.createMessageDateTime();
    }

}