

package gov.va.med.cds.socket.server.handler;


import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;


public class MinaMllpProtocolDecoder
    extends
        CumulativeProtocolDecoder
{

    /** Start of block byte definition. */
    public static final byte SOB = 0x0B;

    /** End of block byte definition. */
    public static final byte EOB = 0x1C;


    @Override
    protected boolean doDecode( IoSession session, IoBuffer in, ProtocolDecoderOutput out )
        throws Exception
    {

        if ( EOB == in.get( in.limit() - 2 ) )
        {
            IoBuffer tempBuffer = in.slice();

            in.position( in.limit() );

            out.write( tempBuffer );

            return true;
        }

        return false;
    }
}
