

package gov.va.med.cds.socket.server.handler;


import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.logger.ApplicationLoggerInterface;
import gov.va.med.cds.logger.LogApplicationLogger;
import gov.va.med.cds.hapi.Hl7SupportHdrLegacy;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.LogFactory;


public class MappingResponseGenerator
    implements
        ResponseGeneratorInterface
{
    private static final String DEFAULT_RESPONSE_GENERATOR_KEY = "DEFAULT";

    // Logger to be used by the data handler.
    ApplicationLoggerInterface appLogger = getLogger();

    // Collection of response generators available for different message types
    private Map<String, ResponseGeneratorInterface> responseGeneratorMap = new HashMap<String, ResponseGeneratorInterface>();


    public String createResponse( HL7SupportInterface aRequestHl7Support, String writeRequest, String envSpecProcessingId, String aResponse, String aResponseMessageControlId, Exception anException )
    {
        String messageType = DEFAULT_RESPONSE_GENERATOR_KEY;
        HL7SupportInterface hl7Support = null;
        try
        {
            if ( aRequestHl7Support == null )
            {
                hl7Support = new Hl7SupportHdrLegacy( writeRequest );

            }
            else
            {
                hl7Support = aRequestHl7Support;
            }
            messageType = String.format( "%s~%s", hl7Support.getSendingApplication(), hl7Support.getMessageType() );

        }
        catch ( Exception ex )
        {

            // Log the exception, but continue on with processing.
            appLogger.logMessage( "Error while parsing message for Sending Application and Message Type. ", ex );

        }

        ResponseGeneratorInterface responseGenerator = responseGeneratorMap.get( messageType );

        if ( responseGenerator == null )
        {
            // This is the case when message type is not supported by socket facade. Validation already failed.
            // We are going to use default response generator and sent error reply back
            responseGenerator = responseGeneratorMap.get( DEFAULT_RESPONSE_GENERATOR_KEY );
        }

        return responseGenerator.createResponse( aRequestHl7Support, writeRequest, envSpecProcessingId, aResponse, aResponseMessageControlId, anException );
    }


    public void setResponseGeneratorMap( Map<String, ResponseGeneratorInterface> aResponseGeneratorMap )
    {
        this.responseGeneratorMap = aResponseGeneratorMap;
    }


    public void setLogger( ApplicationLoggerInterface aLogger )
    {
        appLogger = aLogger;
    }
    
    
    final ApplicationLoggerInterface getLogger( )
    {
        return new LogApplicationLogger( LogFactory.getLog( MappingResponseGenerator.class ) );
    }
}