

package gov.va.med.cds.socket.server.handler;


import gov.va.med.cds.hapi.HL7SupportInterface;


/**

 * @author susarlan

 *

 */

public interface AccessValidatorInterface

{

    /***
    
     * Check whether the incoming decoded HL7 request message can be passed through
    
     * to the message mediator for processing. Throw exception if it cannot be passed thru.
    
     * 
    
     * @param hl7Support - a handle to the HL7 Support object that gives access 
    
     * to the underlying HL7 message.
    
     * 
    
     */

    public void validateAccess( HL7SupportInterface hl7Support );


    public String getEnvProcessingId( HL7SupportInterface hl7Support );

    public String getRequestId( HL7SupportInterface aHl7Support );
}
