

package gov.va.med.cds.socket.server.handler;


import gov.va.med.cds.exception.AbstractCdsBaseException;

import gov.va.med.cds.exceptionframework.ExceptionUtil;


public abstract class AbstractResponseGenerator
    implements
        ResponseGeneratorInterface
{

    protected String getErrorText( Exception ex )
    {

        String errorMessage = "";

        if ( ex != null )
        {

            if ( ex instanceof AbstractCdsBaseException )
            {

                AbstractCdsBaseException cdsex = ( AbstractCdsBaseException )ex;

                errorMessage = ExceptionUtil.formatMessage( cdsex.getErrorCode().getClientMessage(), cdsex.getCustomMsgValues() );

            }
            else
            {
                errorMessage = ex.getMessage();

            }

        }

        return trimLengthToEighty( errorMessage );

    }


    public String trimLengthToEighty( String errorMessage )
    {
        String trimmed = "";
        if ( errorMessage != null )
            trimmed = errorMessage.substring( 0, ( errorMessage.length() >= 80 ) ? 80 : errorMessage.length() );
        return trimmed;
    }

}
