

package gov.va.med.cds.mediator.work.hapi;


import static org.junit.Assert.assertTrue;

import java.io.FileNotFoundException;
import java.io.IOException;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.FileSystemResource;
import org.springframework.test.context.ContextConfiguration;

import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.mediator.work.MapBackedWorkState;
import gov.va.med.cds.mediator.work.WorkStateException;
import gov.va.med.cds.mediator.work.WorkStateInterface;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.testharness.xml.XmlComparator;
import gov.va.med.cds.testharness.xml.XmlCompareException;
import gov.va.med.cds.util.StreamUtil;

@ContextConfiguration( locations = { "classpath:config/test-message-mediator-context.xml" } )
@RunWith( SuiteAwareSpringRunner.class )
public class HL7XmlToVhimCreateXmlWorkTest
    extends
        AbstractBaseTest
{
    private static Log logger = LogFactory.getLog( HL7XmlToVhimCreateXmlWorkTest.class );

    private HL7XmlToVhimCreateXmlWork hL7XmlToVhimCreateXmlWork;


	@Test
	@Suite(groups = { "checkintest" })
	public void convertCensusSurveyHl7XmltoVhimTest() throws Exception {
		String expectedVhimXml = StreamUtil.resourceToString(
				new FileSystemResource("./src/test/resources/hl7-vhim/expected/censusSurveyCreate40025.xml"));
		String hl7Er7 = StreamUtil.resourceToString(new FileSystemResource(
				"./src/test/resources/vhim-creation-tests/er7-create-requests/MDM_T02_CENSUS_40025.hl7"));

		WorkStateInterface workState = new MapBackedWorkState();
		HL7SupportInterface hl7SupportHAPI = HL7SupportHAPI.createTranslationSupport(hl7Er7);

		workState.registerWorkState("HL7-SUPPORT", hl7SupportHAPI);

		hL7XmlToVhimCreateXmlWork.doWork(workState);
		String vhimResult = (String) workState.locateWorkState(hL7XmlToVhimCreateXmlWork.wsnVhimRequest);
		XmlComparator.assertXMLSimilar(expectedVhimXml, vhimResult);
	}

	
	@Test
	@Suite(groups = { "checkintest" })
	public void convertCensusSurveyHl7XmltoVhimTest_WithErros() throws Exception {
		String expectedExceptionMessage = StreamUtil.resourceToString(
				new FileSystemResource("./src/test/resources/hl7-vhim/expected/CensusSurveyCreate40025WithError.txt"));
		String hl7Er7 = StreamUtil.resourceToString(new FileSystemResource(
				"./src/test/resources/vhim-creation-tests/er7-create-requests/MDM_T02_CENSUS_40025_Invalid.hl7"));

		WorkStateInterface workState = new MapBackedWorkState();
		HL7SupportInterface hl7SupportHAPI = HL7SupportHAPI.createTranslationSupport(hl7Er7);

		workState.registerWorkState("HL7-SUPPORT", hl7SupportHAPI);

		hL7XmlToVhimCreateXmlWork.doWork(workState);
		String exceptionMessage = (String) workState.getFormattedExceptionDetail();
		Assert.assertEquals( expectedExceptionMessage, exceptionMessage );
	}

	@Test
	@Suite(groups = { "checkintest" })
	public void convertCensusSurveyHl7XmltoVhimTest_InvalidDates() throws Exception {
		String expectedExceptionMessage = StreamUtil.resourceToString(
				new FileSystemResource("./src/test/resources/hl7-vhim/expected/CensusSurveyCreate40025_InvalidDates.txt"));
		String hl7Er7 = StreamUtil.resourceToString(new FileSystemResource(
				"./src/test/resources/vhim-creation-tests/er7-create-requests/MDM_T02_CENSUS_40025_InvalidDates.hl7"));

		WorkStateInterface workState = new MapBackedWorkState();
		HL7SupportInterface hl7SupportHAPI = HL7SupportHAPI.createTranslationSupport(hl7Er7);

		workState.registerWorkState("HL7-SUPPORT", hl7SupportHAPI);

		hL7XmlToVhimCreateXmlWork.doWork(workState);
		String exceptionMessage = (String) workState.getFormattedExceptionDetail();
		Assert.assertEquals( expectedExceptionMessage, exceptionMessage );
	}

	@Test
    @Suite( groups = { "checkintest" } )
    public void convertMalformedHl7XmltoVhimTest( )
        throws Exception
    {
        String vhimResult = null;
        String hl7Er7 = StreamUtil
                        .resourceToString( new FileSystemResource( "./src/test/resources/vhim-creation-tests/er7-create-requests/lab.er7" ) );

        WorkStateInterface workState = new MapBackedWorkState();
        HL7SupportInterface hl7SupportHAPI = HL7SupportHAPI.createTranslationSupport( hl7Er7 );

        workState.registerWorkState( "HL7-SUPPORT", hl7SupportHAPI );

        try
        {
            hL7XmlToVhimCreateXmlWork.doWork( workState );
            vhimResult = ( String )workState.locateWorkState( hL7XmlToVhimCreateXmlWork.wsnVhimRequest );
        }
        catch ( WorkStateException e )
        {
            assertTrue( e.getMessage().equals( "WORK_STATE_EXPECTED_DATA_NOT_PRESENT_EXCEPTION" ) );
        }

    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void convertDmpSurveyHl7XmltoVhimTest( )
        throws Exception
    {
        String expectedVhimXml = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/hl7-vhim/expected/dMPSurveyCreate40024.xml" ) );
        String hl7Er7 = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/vhim-creation-tests/er7-create-requests/MDM_T02_DMP_40024.hl7" ) );

        WorkStateInterface workState = new MapBackedWorkState();
        HL7SupportInterface hl7SupportHAPI = HL7SupportHAPI.createTranslationSupport( hl7Er7 );

        workState.registerWorkState( "HL7-SUPPORT", hl7SupportHAPI );

        hL7XmlToVhimCreateXmlWork.doWork( workState );
        String vhimResult = ( String )workState.locateWorkState( hL7XmlToVhimCreateXmlWork.wsnVhimRequest );
        XmlComparator.assertXMLSimilar( expectedVhimXml, vhimResult );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void convertDmpSurveyHl7XmltoVhimValidatorTest( )
        throws Exception
    {
        String expectedExceptionMessage = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/response/DmpSurveyCreate40024ConditionWithConstraintViolation.txt" ) );
        String hl7Er7 = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/vhim-creation-tests/er7-create-requests/MDM_T02_DMP_INVALID_VIM.hl7" ) );

        WorkStateInterface workState = new MapBackedWorkState();
        HL7SupportInterface hl7SupportHAPI = HL7SupportHAPI.createTranslationSupport( hl7Er7 );
        workState.registerWorkState( "HL7-SUPPORT", hl7SupportHAPI );

        hL7XmlToVhimCreateXmlWork.doWork( workState );
        String exceptionMessage = ( String )workState.getFormattedExceptionDetail();
        Assert.assertEquals( expectedExceptionMessage, exceptionMessage );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void convertAdlSurveyHl7XmltoVhimTest( )
        throws Exception
    {
        String expectedVhimXml = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/hl7-vhim/expected/aDLSurveyCreate40024.xml" ) );
        String hl7Er7 = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/vhim-creation-tests/er7-create-requests/MDM_T02_ADL_40024.hl7" ) );

        WorkStateInterface workState = new MapBackedWorkState();
        HL7SupportInterface hl7SupportHAPI = HL7SupportHAPI.createTranslationSupport( hl7Er7 );
        workState.registerWorkState( "HL7-SUPPORT", hl7SupportHAPI );

        hL7XmlToVhimCreateXmlWork.doWork( workState );
        String vhimResult = ( String )workState.locateWorkState( hL7XmlToVhimCreateXmlWork.wsnVhimRequest );

        XmlComparator.assertXMLSimilar( expectedVhimXml, vhimResult );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void convertPS1SurveyHl7XmltoVhimTest( )
        throws Exception
    {
        String expectedVhimXml = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/hl7-vhim/expected/pSSurveyCreate40023.xml" ) );
        String hl7Er7 = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/vhim-creation-tests/er7-create-requests/MDM_T02_PS_40023.hl7" ) );

        WorkStateInterface workState = new MapBackedWorkState();
        HL7SupportInterface hl7SupportHAPI = HL7SupportHAPI.createTranslationSupport( hl7Er7 );
        workState.registerWorkState( "HL7-SUPPORT", hl7SupportHAPI );

        hL7XmlToVhimCreateXmlWork.doWork( workState );
        String vhimResult = ( String )workState.locateWorkState( hL7XmlToVhimCreateXmlWork.wsnVhimRequest );

        XmlComparator.assertXMLSimilar( expectedVhimXml, vhimResult );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void convertPS2SurveyHl7XmltoVhimTest( )
        throws Exception
    {
        String expectedVhimXml = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/hl7-vhim/expected/pSSurveyCreate40025.xml" ) );
        String hl7Er7 = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/vhim-creation-tests/er7-create-requests/MDM_T02_PS_40025.hl7" ) );

        WorkStateInterface workState = new MapBackedWorkState();
        HL7SupportInterface hl7SupportHAPI = HL7SupportHAPI.createTranslationSupport( hl7Er7 );
        workState.registerWorkState( "HL7-SUPPORT", hl7SupportHAPI );

        hL7XmlToVhimCreateXmlWork.doWork( workState );
        String vhimResult = ( String )workState.locateWorkState( hL7XmlToVhimCreateXmlWork.wsnVhimRequest );

        XmlComparator.assertXMLSimilar( expectedVhimXml, vhimResult );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void convertHtVitalHl7XmltoVhimTest( )
        throws Exception
    {
        String expectedVhimXml = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/hl7-vhim/expected/VitalsignsCreateOrUpdate40060.xml" ) );
        String hl7Er7 = StreamUtil.resourceToString( new FileSystemResource(
                        "./src/test/resources/vhim-creation-tests/er7-create-requests/HT_VITAL.hl7" ) );

        WorkStateInterface workState = new MapBackedWorkState();
        HL7SupportInterface hl7SupportHAPI = HL7SupportHAPI.createTranslationSupport( hl7Er7 );
        workState.registerWorkState( "HL7-SUPPORT", hl7SupportHAPI );

        hL7XmlToVhimCreateXmlWork.doWork( workState );
        String vhimResult = ( String )workState.locateWorkState( hL7XmlToVhimCreateXmlWork.wsnVhimRequest );

        XmlComparator.assertXMLSimilar( expectedVhimXml, vhimResult );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testHDRLabEr7XmlToVhimXml( )
        throws FileNotFoundException,
            IOException,
            XmlCompareException
    {
        String expectedVhimXml = StreamUtil
                        .resourceToString( new FileSystemResource( "./src/test/resources/hl7-vhim/expected/hdrlab_cds_data3.xml" ) );
        String hl7Er7 = StreamUtil.resourceToString( new FileSystemResource( "./src/test/resources/hl7-er7/hdrlab_cds_data3.txt" ) );

        WorkStateInterface workState = new MapBackedWorkState();
        HL7SupportInterface hl7SupportHAPI = HL7SupportHAPI.createTranslationSupport( hl7Er7 );
        workState.registerWorkState( "HL7-SUPPORT", hl7SupportHAPI );

        hL7XmlToVhimCreateXmlWork.doWork( workState );
        String vhimResult = ( String )workState.locateWorkState( hL7XmlToVhimCreateXmlWork.wsnVhimRequest );

        XmlComparator.assertXMLSimilar( expectedVhimXml, vhimResult );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testHDRAllergyEr7XmlToVhimXml( )
        throws FileNotFoundException,
            IOException,
            XmlCompareException
    {
        String expectedVhimXml = StreamUtil
                        .resourceToString( new FileSystemResource( "./src/test/resources/hl7-vhim/expected/hdralgy-full.xml" ) );
        String hl7Er7 = StreamUtil.resourceToString( new FileSystemResource( "./src/test/resources/hl7-er7/hdralgy-full.txt" ) );

        WorkStateInterface workState = new MapBackedWorkState();
        HL7SupportInterface hl7SupportHAPI = HL7SupportHAPI.createTranslationSupport( hl7Er7 );
        workState.registerWorkState( "HL7-SUPPORT", hl7SupportHAPI );

        hL7XmlToVhimCreateXmlWork.doWork( workState );
        String vhimResult = ( String )workState.locateWorkState( hL7XmlToVhimCreateXmlWork.wsnVhimRequest );

        XmlComparator.assertXMLSimilar( expectedVhimXml, vhimResult );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testHDRAllergyBadCommentEr7XmlToVhimXml( )
        throws FileNotFoundException,
            IOException,
            XmlCompareException
    {
        String expectedVhimXml = StreamUtil
                        .resourceToString( new FileSystemResource( "./src/test/resources/hl7-vhim/expected/hdralgy-blank-comment.xml" ) );
        String hl7Er7 = StreamUtil.resourceToString( new FileSystemResource( "./src/test/resources/hl7-er7/hdralgy-blank-comment.txt" ) );

        WorkStateInterface workState = new MapBackedWorkState();
        HL7SupportInterface hl7SupportHAPI = HL7SupportHAPI.createTranslationSupport( hl7Er7 );
        workState.registerWorkState( "HL7-SUPPORT", hl7SupportHAPI );

        hL7XmlToVhimCreateXmlWork.doWork( workState );
        String vhimResult = ( String )workState.locateWorkState( hL7XmlToVhimCreateXmlWork.wsnVhimRequest );

        XmlComparator.assertXMLSimilar( expectedVhimXml, vhimResult );
    }


    @Resource
    public void setHL7XmlToVhimCreateXmlWork( HL7XmlToVhimCreateXmlWork hL7XmlToVhimCreateXmlWork )
    {
        this.hL7XmlToVhimCreateXmlWork = hL7XmlToVhimCreateXmlWork;
    }
}
