/**
 * 
 */


package gov.va.med.cds.mediator.work;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;


/**
 * @author vhaislegberb
 * 
 */
@RunWith( SuiteAwareRunner.class )
public class MapBackedWorkStateTest
{
    private static WorkStateInterface workState = null;


    @BeforeClass
    @Suite( groups = { "checkintest" } )
    public static void beforeMapBackedWorkStateTestSetUp( )
    {
        workState = new MapBackedWorkState();
        workState.addException( new Exception( "Test Exception 1" ) );
        workState.addException( new Exception( "Test Exception 2" ) );
        workState.registerWorkState( "workState1", "WORK-STATE-1" );
        workState.registerWorkState( "workState2", "WORK-STATE-2" );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testGetFormattedExceptionDetail( )
    {
        String formattedExceptionDetail = workState.getFormattedExceptionDetail();
        assertEquals( "Mediator Error Detail: (1)Test Exception 1, (2)Test Exception 2", formattedExceptionDetail );
    }


    @Test
    @Suite( order = 2, groups = { "checkintest" }, dependsOnMethods = { "testGetFormattedExceptionDetail" } )
    public void testAddException( )
    {
        workState.addException( new Exception( "Added exception" ) );
        assertEquals( 3, workState.getExceptionCount() );
    }


    @Test
    @Suite( order = 3, groups = { "checkintest" }, dependsOnMethods = { "testAddException" } )
    public void testGetExceptionCount( )
    {
        assertEquals( workState.getExceptionCount(), 3 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testGetExceptions( )
    {
        assertEquals( 2, workState.getExceptions().size() );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testLocateWorkState( )
    {
        assertEquals( "WORK-STATE-1", workState.locateWorkState( "workState1" ) );
        assertEquals( "WORK-STATE-2", workState.locateWorkState( "workState2" ) );
    }


    @Test( expected = WorkStateException.class )
    @Suite( groups = { "checkintest" } )
    public void testLocateUnregisteredWorkState( )
    {
        workState.locateWorkState( "workStateUnregistered" );
        fail();
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testRegisterWorkState( )
    {
        workState.registerWorkState( "workStateRegistered", "WORK-STATE-REGISTERED" );
        assertEquals( "WORK-STATE-REGISTERED", workState.locateWorkState( "workStateRegistered" ) );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testIsWorkStateRegistered( )
    {
        boolean registered = workState.isWorkStateRegistered( "workState2" );
        assertEquals( registered, true );

        registered = workState.isWorkStateRegistered( "NOT_REGISTERED" );
        assertEquals( registered, false );
    }


    @Test( expected = WorkStateException.class )
    @Suite( groups = { "checkintest" } )
    public void testReregisterWorkState( )
    {
        workState.registerWorkState( "workState1", "RE-REG-WORK-STATE" );
        fail();
    }

}
