

package gov.va.med.cds.mediator.config;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.testharness.AbstractLoggingTest;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.context.ApplicationContext;


@RunWith( SuiteAwareRunner.class )
public class SpringApplicationContextAccessorTest
    extends
        AbstractLoggingTest
{

    @Test
    @Suite( groups = { "checkintest" } )
    public void testGetBean( )
    {
        String id = "testId";
        Object returnObj = new String( "test" );

        ApplicationContext applicationContextMock = EasyMock.createMock( ApplicationContext.class );
        EasyMock.expect( applicationContextMock.getBean( id ) ).andReturn( returnObj );
        EasyMock.replay( applicationContextMock );

        SpringApplicationContextAccessor springApplicationContextAccessor = new SpringApplicationContextAccessor();
        springApplicationContextAccessor.setApplicationContext( applicationContextMock );

        Object result = springApplicationContextAccessor.getBean( id );

        Assert.assertEquals( result, returnObj );

    }


    public SpringApplicationContextAccessor getSpringApplicationContextAccessorInstance( )
    {
        return SpringApplicationContextAccessorFactory.getInstance();
    }

}
