

package gov.va.med.cds.hapi;


import static org.junit.Assert.assertEquals;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;


@ContextConfiguration( locations = { "classpath:gov/va/med/cds/hapi/test-message-mediator-context.xml" } )
@RunWith( SuiteAwareSpringRunner.class )
public class HL7UtilityTest
    extends
        AbstractBaseTest
{
    public HL7Utility hl7Utility = null;

    private Log logger = LogFactory.getLog( HL7UtilityTest.class );


    @javax.annotation.Resource
    public void setHl7Utility( HL7Utility hl7Utility )
    {
        this.hl7Utility = hl7Utility;
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testIntegerPadding( )
    {
        logger.info( HL7Utility.createMessageControlId() );
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testGetSendingFacility( )
    {
        String sendingFacility = hl7Utility.getSendingFacility( "675" );
        assertEquals(sendingFacility, "ORLANDOURL        " );
    }
    
}
