<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:saxon="http://saxon.sf.net/"
	exclude-result-prefixes="fn xs xsi xsl saxon"
	xmlns:clinicaldata="Clinicaldata" xmlns="urn:hl7-org:v2xml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes" />
	
	<xsl:param name="global.hl7Support"/>
	<xsl:param name="global.workState"/>
	<xsl:param name="global.hl7Utility"/>
	
	<xsl:template match="/clinicaldata:ClinicalData">
		<xsl:variable name="messageDateTime" as="xs:string"
					select="saxon:create-message-datetime($global.hl7Support)" />
		<QRY_Q01>
			<xsl:call-template name="getBHS">
				<xsl:with-param name="messageDateTime" select="$messageDateTime"/>
			</xsl:call-template>
			<xsl:call-template name="getERR" />
			<xsl:call-template name="getQPD">
				<xsl:with-param name="messageDateTime" select="$messageDateTime"/>
			</xsl:call-template>
			<xsl:call-template name="getRCP" />
			<xsl:call-template name="getRDS" />
			<xsl:call-template name="getBTS" />
		</QRY_Q01>
	</xsl:template>
	<xsl:template name="getBHS">
		<xsl:param name="messageDateTime" />
		<BHS>
			<BHS.1>^</BHS.1>
			<BHS.2>~|\&amp;</BHS.2>
			<BHS.3>VHA_HDR</BHS.3>
			<BHS.4>HDR</BHS.4>
			<BHS.5>CHDR SENDER</BHS.5>
			<BHS.6>CHDR</BHS.6>
			<BHS.7>
				<TS.1><xsl:value-of select="$messageDateTime"/></TS.1>
			</BHS.7>
			<BHS.9><xsl:text>RSP*Z98*QRY_Q01</xsl:text></BHS.9>
		</BHS>
	</xsl:template>
	<xsl:template name="getERR">
		<ERR>
			<xsl:if test="saxon:get-exception-count($global.workState) > 0">
				<ERR.1>
					<ELD.4>
						<CE.1>
							<xsl:text>MEDIATOR-ERROR</xsl:text>
						</CE.1>
						<CE.2>
							<xsl:value-of select="saxon:get-formatted-exception-detail($global.workState)" />
						</CE.2>
						<CE.3>
							<xsl:text>NA</xsl:text>
						</CE.3>
					</ELD.4>
				</ERR.1>
			</xsl:if>
			<xsl:for-each select="errorSection/fatalErrors">
				<ERR.1>
					<ELD.4>
						<CE.1>
							<xsl:value-of select="errorId" />
						</CE.1>
						<CE.2>
							<xsl:value-of select="displayMessage" />
						</CE.2>
						<CE.3>
							<xsl:value-of select="errorCode" />
						</CE.3>
					</ELD.4>
				</ERR.1>
			</xsl:for-each>
			<xsl:for-each select="errorSection/warnings">
				<xsl:if test="(errorCode='READ_REQUEST_DATA_SOURCE_FAILURE') or (errorCode='READ_REQUEST_DATA_SOURCE_ALL_EXCEPTIONS')">
					<ERR.1>
						<ELD.4>
							<CE.1>
								<xsl:value-of select="errorId" />
							</CE.1>
							<CE.2>
								<xsl:value-of select="displayMessage" />
							</CE.2>
							<CE.3>
								<xsl:value-of select="errorCode" />
							</CE.3>
						</ELD.4>
					</ERR.1>
				</xsl:if>
			</xsl:for-each>
		</ERR>
	</xsl:template>
	<xsl:template name="getQPD">
		<xsl:param name="messageDateTime" />
		<QPD>
			<QPD.1>
				<CE.1>OC_CHDR</CE.1>
			</QPD.1>
			<QPD.3>
				<xsl:value-of select="patient/requestedNationalId"/>
			</QPD.3>
			<QPD.4>CHDR_RXOP</QPD.4>
			<!-- <QPD.5><xsl:value-of select="saxon:get-message-data($global.hl7Support, '/QPD-5')"/></QPD.5>
			<QPD.6><xsl:value-of select="saxon:get-message-data($global.hl7Support, '/QPD-6')"/></QPD.6> -->
		</QPD>
	</xsl:template>
	<xsl:template name="getRCP">
		<RCP>
			<RCP.1>I</RCP.1>
			<RCP.2>
				<CQ.1>100</CQ.1>
				<CQ.2>
					<CE.1>RD</CE.1>
				</CQ.2>
			</RCP.2>
			<RCP.3>
				<CE.1>B</CE.1>
			</RCP.3>
			<RCP.4>
				<TS.1></TS.1>
			</RCP.4>
		</RCP>
	</xsl:template>
	<xsl:template name="getRDS">
		<xsl:for-each select="patient/outpatientMedicationPromises">
			<RDS_O13>
				<xsl:call-template name="getMSH" />
				<RDS_O13.PATIENT>
					<xsl:call-template name="getPID"/>
				</RDS_O13.PATIENT>
				<RDS_O13.ORDER>
					<xsl:call-template name="getORC-OriginalDispense" />
					<RDS_O13.ENCODING>
						<xsl:call-template
							name="getRXE-OriginalDispense" />
						<xsl:call-template
							name="getRXR-OriginalDispense" />
						<xsl:call-template
							name="getFT1-OriginalDispense" />
						<xsl:call-template
							name="getFT1-CopayOriginalDispense" />
						<xsl:call-template
							name="getOBX-OriginalDispense" />
						<xsl:call-template
							name="getNTE-OriginalDispense" />
					</RDS_O13.ENCODING>
				</RDS_O13.ORDER>
				<xsl:for-each select="refillDispense">
					<RDS_O13.ORDER>
						<xsl:call-template name="getORC-RefillDispense" />
						<RDS_O13.ENCODING>
							<xsl:call-template
								name="getRXE-RefillDispense" />
							<xsl:call-template
								name="getNTE-RefillDispense" />
							<xsl:call-template
								name="getFT1-RefillDispense" />
						</RDS_O13.ENCODING>
					</RDS_O13.ORDER>
				</xsl:for-each>
				<xsl:for-each select="partialDispense">
					<RDS_O13.ORDER>
						<xsl:call-template
							name="getORC-PartialDispense" />
						<RDS_O13.ENCODING>
							<xsl:call-template
								name="getRXE-PartialDispense" />
							<xsl:call-template
								name="getNTE-PartialDispense" />
							<xsl:call-template
								name="getFT1-PartialDispense" />
						</RDS_O13.ENCODING>
					</RDS_O13.ORDER>
				</xsl:for-each>
			</RDS_O13>
		</xsl:for-each>
	</xsl:template>
	<!--
		############################################################################

		getORC-OriginalDispense
		applies to the entire ORC Segment concerning the original dispense

	-->
	<xsl:template name="getORC-OriginalDispense">
		<ORC>
			<ORC.1>RE</ORC.1>
			<ORC.2>
				<EI.1>
					<xsl:value-of
						select="pharmacyRequest/genericRequestIdentifier/identity" />
				</EI.1>
				<EI.2>
					<xsl:value-of
						select="pharmacyRequest/genericRequestIdentifier/namespaceId" />
				</EI.2>
			</ORC.2>
			<ORC.3>
				<EI.1>
					<xsl:value-of select="recordIdentifier/identity" />
				</EI.1>
				<EI.2>
					<xsl:value-of select="recordIdentifier/namespaceId" />
				</EI.2>
			</ORC.3>
			<ORC.5>
				<xsl:value-of select="pharmacyRequest/status" />
			</ORC.5>
			<xsl:variable name="originalFillDate"
				select="originalDispense/fillDate/literal" />
			<xsl:variable name="expirationDate"
				select="expirationDate/literal" />
			<xsl:if
				test="$originalFillDate != '' or $expirationDate != ''">
				<ORC.7>
					<xsl:if test="$originalFillDate != ''">
						<TQ.4>
							<TS.1>
								<xsl:value-of
									select="$originalFillDate" />
							</TS.1>
						</TQ.4>
					</xsl:if>
					<xsl:if test="$expirationDate != ''">
						<TQ.5>
							<TS.1>
								<xsl:value-of select="$expirationDate" />
							</TS.1>
						</TQ.5>
					</xsl:if>
					<xsl:choose>
						<xsl:when
							test="$originalFillDate != '' and $expirationDate != ''">
							<TQ.7>FILL/EXPIRATION</TQ.7>
						</xsl:when>
						<xsl:when
							test="$originalFillDate != '' and not($expirationDate != '')">
							<TQ.7>FILL</TQ.7>
						</xsl:when>
						<xsl:when
							test="not($originalFillDate != '') and $expirationDate != ''">
							<TQ.7>EXPIRATION</TQ.7>
						</xsl:when>
					</xsl:choose>
				</ORC.7>
			</xsl:if>
			<xsl:variable name="issueDate"
				select="pharmacyRequest/orderDate/literal" />
			<xsl:if test="$issueDate != ''">
				<ORC.7>
					<TQ.5>
						<TS.1>
							<xsl:value-of select="$issueDate" />
						</TS.1>
					</TQ.5>
					<TQ.7>ISSUED</TQ.7>
				</ORC.7>
			</xsl:if>
			<xsl:variable name="dispenseDate"
				select="originalDispense/dispenseDate/literal" />
			<xsl:variable name="lastDispenseDate"
				select="lastDispenseDate/literal" />
			<xsl:if
				test="$dispenseDate != '' or $lastDispenseDate != ''">
				<ORC.7>
					<xsl:if test="$dispenseDate != ''">
						<TQ.4>
							<TS.1>
								<xsl:value-of select="$dispenseDate" />
							</TS.1>
						</TQ.4>
					</xsl:if>
					<xsl:if test="$lastDispenseDate != ''">
						<TQ.5>
							<TS.1>
								<xsl:value-of
									select="$lastDispenseDate" />
							</TS.1>
						</TQ.5>
					</xsl:if>
					<xsl:choose>
						<xsl:when
							test="$dispenseDate != '' and $lastDispenseDate != ''">
							<TQ.7>DISPENSED/LAST DISPENSED</TQ.7>
						</xsl:when>
						<xsl:when
							test="$dispenseDate != '' and not($lastDispenseDate != '')">
							<TQ.7>DISPENSED</TQ.7>
						</xsl:when>
						<xsl:when
							test="not($dispenseDate != '') and $lastDispenseDate != ''">
							<TQ.7>LAST DISPENSED</TQ.7>
						</xsl:when>
					</xsl:choose>
				</ORC.7>
			</xsl:if>
			<xsl:variable name="cancelDate"
				select="cancel/cancelDate/literal" />
			<xsl:if test="$cancelDate != ''">
				<ORC.7>
					<TQ.5>
						<TS.1>
							<xsl:value-of select="$cancelDate" />
						</TS.1>
					</TQ.5>
					<TQ.7>CANCEL</TQ.7>
				</ORC.7>
			</xsl:if>
			<ORC.9>
				<TS.1>
					<xsl:value-of
						select="originalDispense/loginDate/literal" />
				</TS.1>
			</ORC.9>
			<ORC.10>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver"
						select="dataEnterer/practitioner" />
				</xsl:call-template>
			</ORC.10>
			<xsl:variable name="orc12">
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver"
						select="originalDispense/currentProvider" />
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="string-length($orc12) > 0">
				<ORC.12>
					<xsl:call-template name="getResponsibleObserver">
						<xsl:with-param name="theObserver"
							select="originalDispense/currentProvider" />
					</xsl:call-template>
				</ORC.12>
			</xsl:if>
			<xsl:variable name="orc12">
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver"
						select="pharmacyRequest/cosigner/practitioner" />
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="string-length($orc12) > 0">
				<ORC.12>
					<xsl:call-template name="getResponsibleObserver">
						<xsl:with-param name="theObserver"
							select="pharmacyRequest/cosigner/practitioner" />
					</xsl:call-template>
				</ORC.12>
			</xsl:if>
			<ORC.13>
				<PL.1>
					<xsl:value-of
						select="pharmacyRequest/orderLocationIdentifier/pointOfCare" />
				</PL.1>
				<PL.2>
					<xsl:value-of
						select="pharmacyRequest/orderLocationIdentifier/room" />
				</PL.2>
			</ORC.13>
			<ORC.17>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="originalDispense/division/divisionId" />
				</xsl:call-template>
				<CE.4>
					<xsl:value-of
						select="originalDispense/division/ncpdpId/code" />
				</CE.4>
				<CE.5>
					<xsl:value-of
						select="originalDispense/division/ncpdpId/displayText" />
				</CE.5>
				<CE.6>
					<xsl:value-of
						select="originalDispense/division/ncpdpId/codingSystem" />
				</CE.6>
			</ORC.17>
			<ORC.21>
				<XON.1>
					<xsl:value-of
						select="pharmacyRequest/orderingInstitutionIdentifier/name" />
				</XON.1>
			</ORC.21>
			<ORC.25>
				<CWE.1>
					<xsl:value-of
						select="pharmacyRequest/statusModifier/code" />
				</CWE.1>
				<CWE.2>
					<xsl:value-of
						select="pharmacyRequest/statusModifier/displayText" />
				</CWE.2>
				<CWE.3>
					<xsl:value-of
						select="pharmacyRequest/statusModifier/codingSystem" />
				</CWE.3>
				<CWE.4>
					<xsl:value-of
						select="originalDispense/cmopEventStatus/code" />
				</CWE.4>
				<CWE.5>
					<xsl:value-of
						select="originalDispense/cmopEventStatus/displayText" />
				</CWE.5>
				<CWE.6>
					<xsl:value-of
						select="originalDispense/cmopEventStatus/codingSystem" />
				</CWE.6>
			</ORC.25>
		</ORC>
	</xsl:template>
	<!--
		############################################################################

		getRXE-OriginalDispense
		applies to the entire RXE Segment concerning the original dispense

	-->
	<xsl:template name="getRXE-OriginalDispense">
		<RXE>
			<!-- RXE.1 is transformed using the recursive call below 'getRXE-1detail' -->
			<xsl:variable name="index" select="1" />
			<xsl:variable name="medicationInstructionsCount"
				select="count(medicationInstructions) + 1" />
			<xsl:call-template name="getRXE-1detail">
				<xsl:with-param name="theIndex" select="$index" />
				<xsl:with-param name="theCount"
					select="$medicationInstructionsCount" />
			</xsl:call-template>
			<RXE.2>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="pharmacyRequest/orderedMedication/medicationCode" />
				</xsl:call-template>
				<CE.4>
					<xsl:value-of
						select="originalDispense/dispensedDrug/ndc/code" />
				</CE.4>
				<CE.5>
					<xsl:value-of
						select="originalDispense/dispensedDrug/ndc/displayText" />
				</CE.5>
				<CE.6>
					<xsl:value-of
						select="originalDispense/dispensedDrug/ndc/codingSystem" />
				</CE.6>
			</RXE.2>
			<RXE.3>0</RXE.3>
			<RXE.5>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="medicationInstructions[1]/giveUnits" />
				</xsl:call-template>
			</RXE.5>
			<RXE.6>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="pharmacyRequest/orderedItem/dosageFormCode" />
				</xsl:call-template>
			</RXE.6>
			<xsl:for-each select="medicationInstructions">
				<xsl:variable name="theVerb">
					<xsl:call-template name="getCodedElement">
						<xsl:with-param name="theElement" select="verb" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="string-length($theVerb) > 0">
					<RXE.7>
						<xsl:call-template name="getCodedElement">
							<xsl:with-param name="theElement"
								select="verb" />
						</xsl:call-template>
					</RXE.7>
				</xsl:if>
				<xsl:variable name="theNoun">
					<xsl:call-template name="getCodedElement">
						<xsl:with-param name="theElement" select="noun" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="string-length($theNoun) > 0">
					<RXE.7>
						<xsl:call-template name="getCodedElement">
							<xsl:with-param name="theElement"
								select="noun" />
						</xsl:call-template>
					</RXE.7>
				</xsl:if>
				<xsl:variable name="theSchedule">
					<xsl:call-template name="getCodedElement">
						<xsl:with-param name="theElement"
							select="schedule" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="string-length($theSchedule) > 0">
					<RXE.7>
						<xsl:call-template name="getCodedElement">
							<xsl:with-param name="theElement"
								select="schedule" />
						</xsl:call-template>
					</RXE.7>
				</xsl:if>
				<xsl:variable name="theConjunction">
					<xsl:call-template name="getCodedElement">
						<xsl:with-param name="theElement"
							select="conjunction" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="string-length($theConjunction) > 0">
					<RXE.7>
						<xsl:call-template name="getCodedElement">
							<xsl:with-param name="theElement"
								select="conjunction" />
						</xsl:call-template>
					</RXE.7>
				</xsl:if>
			</xsl:for-each>
			<xsl:if test="patientInstructions">
				<RXE.7>
					<CE.2>
						<xsl:value-of select="patientInstructions" />
					</CE.2>
					<CE.3>
						<xsl:value-of
							select="./patient/identifier/assigningFacility" />
						<xsl:text>_52_114</xsl:text>
					</CE.3>
				</RXE.7>
			</xsl:if>
			<xsl:if test="otherPatientInstructions">
				<RXE.7>
					<CE.2>
						<xsl:value-of select="otherPatientInstructions" />
					</CE.2>
					<CE.3>
						<xsl:value-of
							select="./patient/identifier/assigningFacility" />
						<xsl:text>_52_114.1</xsl:text>
					</CE.3>
				</RXE.7>
			</xsl:if>
			<xsl:if test="expandedPatientInstructions">
				<RXE.7>
					<CE.2>
						<xsl:value-of
							select="expandedPatientInstructions" />
					</CE.2>
					<CE.3>
						<xsl:value-of
							select="./patient/identifier/assigningFacility" />
						<xsl:text>_52_115</xsl:text>
					</CE.3>
				</RXE.7>
			</xsl:if>
			<RXE.8>
				<LA1.6>
					<xsl:value-of select="originalDispense/mailWindow" />
				</LA1.6>
			</RXE.8>
			<RXE.10>
				<xsl:value-of
					select="originalDispense/quantityDispensed/value" />
			</RXE.10>
			<RXE.12>
				<xsl:value-of select="numberOfRefillsAuthorized" />
			</RXE.12>
			<RXE.14>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver"
						select="originalDispense/pharmacist/practitioner" />
				</xsl:call-template>
			</RXE.14>
			<RXE.15>
				<xsl:value-of select="prescriptionId" />
			</RXE.15>
			<RXE.16>
				<xsl:choose>
					<xsl:when test="(string(number(originalDispense/numberOfRefillsRemaining)) != 'NaN')">
						<xsl:value-of select="originalDispense/numberOfRefillsRemaining" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="calculateRefillsRemaining">
							<xsl:with-param name="refills" select="count(refillDispense)"/>
							<xsl:with-param name="authorized" select="numberOfRefillsAuthorized"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</RXE.16>
			<RXE.18>
				<TS.1>
					<xsl:value-of select="originalDispense/releaseDate/literal" />
				</TS.1>
			</RXE.18>
			<RXE.21>
				<CE.1>
					<xsl:value-of select="sig" />
				</CE.1>
				<CE.3>
					<xsl:value-of
						select="./patient/identifier/assigningFacility" />
					<xsl:text>_52_10.2</xsl:text>
				</CE.3>
			</RXE.21>
			<RXE.22>
				<xsl:value-of select="originalDispense/daysSupply" />
			</RXE.22>
			<xsl:variable name="rxe31">
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="pharmacyRequest/orderedMedication/tradeName" />
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="string-length($rxe31) > 0">
				<RXE.31>
					<xsl:call-template name="getCodedElement">
						<xsl:with-param name="theElement"
							select="pharmacyRequest/orderedMedication/tradeName" />
					</xsl:call-template>
				</RXE.31>
			</xsl:if>
			<RXE.31>
				<CE.1>
					<xsl:value-of
						select="pharmacyRequest/orderedMedication/medicationCode/alternateCode" />
				</CE.1>
				<CE.2>
					<xsl:value-of
						select="pharmacyRequest/orderedMedication/medicationCode/alternateDisplayText" />
				</CE.2>
				<CE.3>
					<xsl:value-of
						select="pharmacyRequest/orderedMedication/medicationCode/alternateCodingSystem" />
				</CE.3>
			</RXE.31>
			<xsl:variable name="rxe31-2">
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="pharmacyRequest/orderedMedication/cmopDrugCode" />
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="string-length($rxe31-2) > 0">
				<RXE.31>
					<xsl:call-template name="getCodedElement">
						<xsl:with-param name="theElement"
							select="pharmacyRequest/orderedMedication/cmopDrugCode" />
					</xsl:call-template>
				</RXE.31>
			</xsl:if>
		</RXE>
	</xsl:template>
	<!--
		############################################################################

		getRXE-1detail
		applies to the entire RXE-1 field
		NOTE: this is a recursively called template
	-->
	<xsl:template name="getRXE-1detail">
		<xsl:param name="theIndex" />
		<xsl:param name="theCount" />
		<xsl:if test="$theCount > $theIndex">
			<RXE.1>
				<xsl:if
					test="medicationInstructions[$theIndex]/dispenseUnitsPerDose or medicationInstructions[$theIndex]/dosageOrdered">
					<TQ.1>
						<CQ.1>
							<xsl:value-of
								select="medicationInstructions[$theIndex]/dispenseUnitsPerDose" />
						</CQ.1>
						<CQ.2>
							<CE.1>
								<xsl:value-of
									select="medicationInstructions[$theIndex]/dosageOrdered" />
							</CE.1>
						</CQ.2>
					</TQ.1>
				</xsl:if>
				<xsl:if
					test="medicationInstructions[$theIndex]/intendedDuration">
					<TQ.3>
						<xsl:value-of
							select="medicationInstructions[$theIndex]/intendedDuration" />
					</TQ.3>
				</xsl:if>
				<!-- TQ.4 through TQ.7 are only transformed on the first pass through this recursive template -->
				<xsl:if test="$theIndex = 1">
					<TQ.4>
						<TS.1>
							<xsl:value-of
								select="originalDispense/fillDate/literal" />
						</TS.1>
					</TQ.4>
					<!-- if a cancel date exists then use it, otherwise use expiration date -->
					<xsl:choose>
						<xsl:when test="cancel/cancelDate/literal">
							<TQ.5>
								<TS.1>
									<xsl:value-of
										select="cancel/cancelDate/literal" />
								</TS.1>
							</TQ.5>
							<TQ.7>FILL/CANCEL</TQ.7>
						</xsl:when>
						<xsl:otherwise>
							<TQ.5>
								<TS.1>
									<xsl:value-of
										select="expirationDate/literal" />
								</TS.1>
							</TQ.5>
							<TQ.7>FILL/EXPIRATION</TQ.7>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</RXE.1>
			<xsl:call-template name="getRXE-1detail">
				<xsl:with-param name="theIndex" select="$theIndex + 1" />
				<xsl:with-param name="theCount" select="$theCount" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!--
		############################################################################

		getRXR-OriginalDispense
		applies to the entire RXR Segment concerning the original dispense

	-->
	<xsl:template name="getRXR-OriginalDispense">
		<xsl:if test="medicationInstructions/route">
			<RXR>
				<xsl:for-each select="medicationInstructions">
					<xsl:variable name="theRoute">
						<xsl:call-template name="getCodedElement">
							<xsl:with-param name="theElement"
								select="route" />
						</xsl:call-template>
					</xsl:variable>
					<xsl:if test="string-length($theRoute) > 0">
						<RXR.1>
							<xsl:call-template name="getCodedElement">
								<xsl:with-param name="theElement"
									select="route" />
							</xsl:call-template>
						</RXR.1>
					</xsl:if>
				</xsl:for-each>
			</RXR>
		</xsl:if>
	</xsl:template>
	<!--
		############################################################################

		getFT1-OriginalDispense
		applies to the entire FT1 Segment concerning the original dispense

	-->
	<xsl:template name="getFT1-OriginalDispense">
		<FT1>
			<FT1.1>1</FT1.1>
			<FT1.4>
				<TS.1>
					<xsl:value-of
						select="originalDispense/fillDate/literal" />
				</TS.1>
			</FT1.4>
			<FT1.6>CG</FT1.6>
			<FT1.7>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="pharmacyRequest/orderedItem/itemCode" />
				</xsl:call-template>
			</FT1.7>
			<FT1.12>
				<CP.1>
					<MO.1>
						<xsl:value-of
							select="originalDispense/dispensedDrug/drugUnitPrice/value" />
					</MO.1>
				</CP.1>
			</FT1.12>
			<FT1.18>
				<xsl:value-of select="pharmacyPatientType" />
			</FT1.18>
			<FT1.20>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver"
						select="finisher/practitioner" />
				</xsl:call-template>
			</FT1.20>
		</FT1>
	</xsl:template>
	<!--
		############################################################################

		getFT1-CopayOriginalDispense
		applies to the entire FT1 Copay Segment concerning the original dispense

	-->
	<xsl:template name="getFT1-CopayOriginalDispense">
		<xsl:if test="copayTransactionType">
			<FT1>
				<FT1.1>2</FT1.1>
				<FT1.4>
					<TS.1>
						<xsl:value-of
							select="originalDispense/fillDate/literal" />
					</TS.1>
				</FT1.4>
				<FT1.6>CO</FT1.6>
				<FT1.7>
					<xsl:call-template name="getCodedElement">
						<xsl:with-param name="theElement"
							select="copayTransactionType" />
					</xsl:call-template>
				</FT1.7>
			</FT1>
		</xsl:if>
	</xsl:template>
	<!--
		############################################################################

		getOBX-OriginalDispense
		applies to many OBX Segments

	-->
	<xsl:template name="getOBX-OriginalDispense">
		<xsl:variable name="setIdentifier" select="0" />
		<xsl:variable name="patientCounseledCount"
			select="count(originalDispense/wasPatientCounseled)" />
		<xsl:if test="$patientCounseledCount > 0">
			<xsl:call-template name="getOBXdetail">
				<xsl:with-param name="theIndex" select="1" />
				<xsl:with-param name="theCount"
					select="$patientCounseledCount + 1" />
				<xsl:with-param name="theSetIdentifier"
					select="$setIdentifier + 1" />
				<xsl:with-param name="theObservationIdentifier"
					select=" 'WAS THE PATIENT COUNSELED' " />
				<xsl:with-param name="theObservationValue"
					select="originalDispense/wasPatientCounseled" />
			</xsl:call-template>
		</xsl:if>
		<xsl:variable name="setIdentifier"
			select="$setIdentifier + $patientCounseledCount" />
		<xsl:variable name="counselingUnderstoodCount"
			select="count(originalDispense/levelOfUnderstanding)" />
		<xsl:if test="$counselingUnderstoodCount > 0">
			<xsl:call-template name="getOBXdetail">
				<xsl:with-param name="theIndex" select="1" />
				<xsl:with-param name="theCount"
					select="$counselingUnderstoodCount + 1" />
				<xsl:with-param name="theSetIdentifier"
					select="$setIdentifier + 1" />
				<xsl:with-param name="theObservationIdentifier"
					select=" 'WAS COUNSELING UNDERSTOOD' " />
				<xsl:with-param name="theObservationValue"
					select="originalDispense/levelOfUnderstanding" />
			</xsl:call-template>
		</xsl:if>
		<xsl:variable name="setIdentifier"
			select="$setIdentifier + $counselingUnderstoodCount" />
		<xsl:variable name="treatmentFactorCount"
			select="count(treatmentFactor)" />
		<xsl:if test="$treatmentFactorCount > 0">
			<xsl:call-template name="getOBXdetail">
				<xsl:with-param name="theIndex" select="1" />
				<xsl:with-param name="theCount"
					select="$treatmentFactorCount + 1" />
				<xsl:with-param name="theSetIdentifier"
					select="$setIdentifier + 1" />
				<xsl:with-param name="theObservationIdentifier"
					select="treatmentFactor/factor/code" />
				<xsl:with-param name="theObservationValue"
					select="treatmentFactor/factorValue" />
			</xsl:call-template>
		</xsl:if>
		<xsl:variable name="setIdentifier"
			select="$setIdentifier + $treatmentFactorCount" />
		<xsl:variable name="transitionalRxBenefitCount"
			select="count(transitionalRxBenefit)" />
		<xsl:if test="$transitionalRxBenefitCount > 0">
			<xsl:call-template name="getOBXdetail">
				<xsl:with-param name="theIndex" select="1" />
				<xsl:with-param name="theCount"
					select="$transitionalRxBenefitCount + 1" />
				<xsl:with-param name="theSetIdentifier"
					select="$setIdentifier + 1" />
				<xsl:with-param name="theObservationIdentifier"
					select=" 'PRESCRIPTION RESULT OF TRANSITIONAL PHARMACY BENEFIT PROJECT' " />
				<xsl:with-param name="theObservationValue"
					select="transitionalRxBenefit" />
			</xsl:call-template>
		</xsl:if>
		<xsl:variable name="setIdentifier"
			select="$setIdentifier + $transitionalRxBenefitCount" />
		<xsl:variable name="totalDailyDosageCount"
			select="count(specialDrugTracking/totalDailyDosage/value)" />
		<xsl:if test="$totalDailyDosageCount > 0">
			<OBX>
				<OBX.1>
					<xsl:value-of select="$setIdentifier + 1" />
				</OBX.1>
				<OBX.2>NM</OBX.2>
				<OBX.3>
					<CE.1>
						<xsl:value-of select=" 'CLOZAPINE DOSAGE' " />
					</CE.1>
				</OBX.3>
				<OBX.5>
					<xsl:value-of
						select="specialDrugTracking/totalDailyDosage/value" />
				</OBX.5>
				<OBX.6>
					<CE.1>
						<xsl:value-of
							select="specialDrugTracking/totalDailyDosage/unit/code" />
					</CE.1>
				</OBX.6>
				<OBX.11>F</OBX.11>
			</OBX>
		</xsl:if>
		<xsl:variable name="setIdentifier"
			select="$setIdentifier + $totalDailyDosageCount" />
		<xsl:variable name="wbcResultCount"
			select="count(specialDrugTracking/wbcObservation/count/value)" />
		<xsl:if test="$wbcResultCount > 0">
			<OBX>
				<OBX.1>
					<xsl:value-of select="$setIdentifier + 1" />
				</OBX.1>
				<OBX.2>NM</OBX.2>
				<OBX.3>
					<CE.1>
						<xsl:value-of select=" 'WBC RESULTS' " />
					</CE.1>
				</OBX.3>
				<OBX.5>
					<xsl:value-of
						select="specialDrugTracking/wbcObservation/count/value" />
				</OBX.5>
				<OBX.11>F</OBX.11>
				<OBX.14>
					<TS.1>
						<xsl:value-of
							select="specialDrugTracking/wbcObservation/testDate/literal" />
					</TS.1>
				</OBX.14>
			</OBX>
		</xsl:if>
		<xsl:variable name="setIdentifier"
			select="$setIdentifier + $wbcResultCount" />
		<xsl:variable name="otcCount"
			select="count(pharmacyRequest/orderedMedication/otcCode)" />
		<xsl:if test="$otcCount > 0">
			<xsl:call-template name="getOBXdetail">
				<xsl:with-param name="theIndex" select="1" />
				<xsl:with-param name="theCount" select="$otcCount + 1" />
				<xsl:with-param name="theSetIdentifier"
					select="$setIdentifier + 1" />
				<xsl:with-param name="theObservationIdentifier"
					select=" 'OTC FLAG' " />
				<xsl:with-param name="theObservationValue"
					select="pharmacyRequest/orderedMedication/otcCode" />
			</xsl:call-template>
		</xsl:if>
		<xsl:variable name="setIdentifier"
			select="$setIdentifier + $otcCount" />
		<xsl:variable name="pdtsResultCount"
			select="count(pdtsPrescriptionId)" />
		<xsl:if test="$pdtsResultCount > 0">
			<OBX>
				<OBX.1>
					<xsl:value-of select="$setIdentifier + 1" />
				</OBX.1>
				<OBX.2>ST</OBX.2>
				<OBX.3>
					<CE.1>
						<xsl:value-of
							select=" 'PDTS_PRESCRIPTION_NUMBER' " />
					</CE.1>
				</OBX.3>
				<OBX.5>
					<xsl:value-of select="pdtsPrescriptionId" />
				</OBX.5>
				<OBX.11>F</OBX.11>
			</OBX>
		</xsl:if>
	</xsl:template>
	<!--
		############################################################################

		getOBXdetail
		applies to the one of many OBX Segment
		NOTE: The 'Count' and 'Index' of this template are used to allow the template to be called recursively;
		the 'if' test will end the recursive call.  Recursion was needed to allow the 'setIdentifier' to
		progressively count up with each successive call.

	-->
	<xsl:template name="getOBXdetail">
		<xsl:param name="theIndex" />
		<xsl:param name="theCount" />
		<xsl:param name="theSetIdentifier" />
		<xsl:param name="theObservationIdentifier" />
		<xsl:param name="theObservationValue" />
		<xsl:if test="$theCount > $theIndex">
			<OBX>
				<OBX.1>
					<xsl:value-of select="$theSetIdentifier" />
				</OBX.1>
				<OBX.2>CE</OBX.2>
				<OBX.3>
					<CE.1>
						<xsl:value-of
							select="$theObservationIdentifier[$theIndex]" />
					</CE.1>
				</OBX.3>
				<OBX.5>
					<xsl:call-template name="getCodedElement">
						<xsl:with-param name="theElement"
							select="$theObservationValue[$theIndex]" />
					</xsl:call-template>
				</OBX.5>
				<OBX.11>F</OBX.11>
			</OBX>
			<xsl:call-template name="getOBXdetail">
				<xsl:with-param name="theIndex" select="$theIndex + 1" />
				<xsl:with-param name="theCount" select="$theCount" />
				<xsl:with-param name="theSetIdentifier"
					select="$theSetIdentifier + 1" />
				<xsl:with-param name="theObservationIdentifier"
					select="treatmentFactor/factor/code" />
				<xsl:with-param name="theObservationValue"
					select="treatmentFactor/factorValue" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!--
		############################################################################

		getNTE-OriginalDispense
		applies to many NTE Segments concerning the original dispense

	-->
	<xsl:template name="getNTE-OriginalDispense">
		<xsl:variable name="setIdentifier" select="0" />
		<xsl:variable name="commentsCount"
			select="count(originalDispense/comments)" />
		<xsl:if test="$commentsCount > 0">
			<NTE>
				<NTE.1>
					<xsl:value-of select="$setIdentifier + 1" />
				</NTE.1>
				<NTE.3>
					<xsl:value-of select="originalDispense/comments" />
				</NTE.3>
				<NTE.4>
					<CE.1>RE</CE.1>
					<CE.2>REMARKS</CE.2>
					<CE.3>
						<xsl:value-of
							select="./patient/identifier/assigningFacility" />
						<xsl:text>_52_12</xsl:text>
					</CE.3>
				</NTE.4>
			</NTE>
		</xsl:if>
		<xsl:variable name="setIdentifier"
			select="$setIdentifier + $commentsCount" />
		<xsl:variable name="commentsCount"
			select="count(originalDispense/currentProviderComments)" />
		<xsl:if test="$commentsCount > 0">
			<NTE>
				<NTE.1>
					<xsl:value-of select="$setIdentifier + 1" />
				</NTE.1>
				<NTE.3>
					<xsl:value-of
						select="originalDispense/currentProviderComments" />
				</NTE.3>
				<NTE.4>
					<CE.1>PR</CE.1>
					<CE.2>PROVIDER COMMENTS</CE.2>
					<CE.3>
						<xsl:value-of
							select="./patient/identifier/assigningFacility" />
						<xsl:text>_52.039_.01</xsl:text>
					</CE.3>
				</NTE.4>
			</NTE>
		</xsl:if>
		<xsl:variable name="setIdentifier"
			select="$setIdentifier + $commentsCount" />
		<xsl:variable name="commentsCount"
			select="count(cancel/comments)" />
		<xsl:if test="$commentsCount > 0">
			<NTE>
				<NTE.1>
					<xsl:value-of select="$setIdentifier + 1" />
				</NTE.1>
				<NTE.3>
					<xsl:value-of select="cancel/comments" />
				</NTE.3>
				<NTE.4>
					<CE.1>DE</CE.1>
					<CE.2>DELETION REASON</CE.2>
					<CE.3>
						<xsl:value-of
							select="./patient/identifier/assigningFacility" />
						<xsl:text>_52_108</xsl:text>
					</CE.3>
				</NTE.4>
			</NTE>
		</xsl:if>
	</xsl:template>
	<!--
		############################################################################

		getORC-RefillDispense
		applies to entire ORC Segment concerning the refill dispense

	-->
	<xsl:template name="getORC-RefillDispense">
		<ORC>
			<ORC.1>RF</ORC.1>
			<ORC.3>
				<EI.1>
					<xsl:value-of select="identifier/identity" />
				</EI.1>
				<EI.2>
					<xsl:value-of select="identifier/namespaceId" />
				</EI.2>
			</ORC.3>
			<xsl:variable name="dispenseDate"
				select="dispenseDate/literal" />
			<xsl:variable name="expirationDate"
				select="dispenseDrug/expirationDate/literal" />
			<xsl:if
				test="$dispenseDate != '' or $expirationDate != ''">
				<ORC.7>
					<xsl:if test="$dispenseDate != ''">
						<TQ.4>
							<TS.1>
								<xsl:value-of select="$dispenseDate" />
							</TS.1>
						</TQ.4>
					</xsl:if>
					<xsl:if test="$expirationDate != ''">
						<TQ.5>
							<TS.1>
								<xsl:value-of select="$expirationDate" />
							</TS.1>
						</TQ.5>
					</xsl:if>
					<xsl:choose>
						<xsl:when
							test="$dispenseDate != '' and $expirationDate != ''">
							<TQ.7>DISPENSED/EXPIRATION</TQ.7>
						</xsl:when>
						<xsl:when
							test="$dispenseDate != '' and not($expirationDate != '')">
							<TQ.7>DISPENSED</TQ.7>
						</xsl:when>
						<xsl:when
							test="not($dispenseDate != '') and $expirationDate != ''">
							<TQ.7>EXPIRATION</TQ.7>
						</xsl:when>
					</xsl:choose>
				</ORC.7>
			</xsl:if>
			<ORC.8>
				<EIP.2>
					<EI.1>
						<xsl:value-of
							select="../recordIdentifier/identity" />
					</EI.1>
				</EIP.2>
			</ORC.8>
			<ORC.9>
				<TS.1>
					<xsl:value-of select="loginDate/literal" />
				</TS.1>
			</ORC.9>
			<ORC.12>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver"
						select="currentProvider" />
				</xsl:call-template>
			</ORC.12>
			<ORC.16>
				<CE.1>REFILL</CE.1>
			</ORC.16>
			<ORC.17>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="division/divisionId" />
				</xsl:call-template>
				<CE.4>
					<xsl:value-of select="division/ncpdpId/code" />
				</CE.4>
				<CE.5>
					<xsl:value-of select="division/ncpdpId/displayText" />
				</CE.5>
				<CE.6>
					<xsl:value-of
						select="division/ncpdpId/codingSystem" />
				</CE.6>
			</ORC.17>
			<ORC.21>
				<XON.1>
					<xsl:value-of
						select="../pharmacyRequest/orderingInstitutionIdentifier/name" />
				</XON.1>
			</ORC.21>
			<ORC.25>
				<CWE.4>
					<xsl:value-of select="cmopEventStatus/code" />
				</CWE.4>
				<CWE.5>
					<xsl:value-of select="cmopEventStatus/displayText" />
				</CWE.5>
				<CWE.6>
					<xsl:value-of select="cmopEventStatus/codingSystem" />
				</CWE.6>
			</ORC.25>
		</ORC>
	</xsl:template>
	<!--
		############################################################################

		getRXE-RefillDispense
		applies to the entire RXE Segment concerning the refill dispense

	-->
	<xsl:template name="getRXE-RefillDispense">
		<RXE>
			<RXE.1>
				<TQ.4>
					<TS.1>
						<xsl:value-of select="fillDate/literal" />
					</TS.1>
				</TQ.4>
				<TQ.7>REFILL</TQ.7>
			</RXE.1>
			<RXE.2>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="../pharmacyRequest/orderedMedication/medicationCode" />
				</xsl:call-template>
				<CE.4>
					<xsl:value-of select="dispensedDrug/ndc/code" />
				</CE.4>
				<CE.5>
					<xsl:value-of
						select="dispensedDrug/ndc/displayText" />
				</CE.5>
				<CE.6>
					<xsl:value-of
						select="dispensedDrug/ndc/codingSystem" />
				</CE.6>
			</RXE.2>
			<RXE.3>0</RXE.3>
			<RXE.5>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="../medicationInstructions[1]/giveUnits" />
				</xsl:call-template>
			</RXE.5>
			<RXE.8>
				<LA1.6>
					<xsl:value-of select="mailWindow" />
				</LA1.6>
			</RXE.8>
			<RXE.10>
				<xsl:value-of select="quantityDispensed/value" />
			</RXE.10>
			<RXE.14>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver"
						select="pharmacist/practitioner" />
				</xsl:call-template>
			</RXE.14>
			<RXE.16>
				<xsl:choose>
					<xsl:when test="(string(number(../originalDispense/numberOfRefillsRemaining)) != 'NaN')">
						<xsl:value-of select="../originalDispense/numberOfRefillsRemaining" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="calculateRefillsRemaining">
							<xsl:with-param name="refills" select="count(../refillDispense)"/>
							<xsl:with-param name="authorized" select="../numberOfRefillsAuthorized"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</RXE.16>
			<RXE.18>
				<TS.1>
					<xsl:value-of select="releaseDate/literal" />
				</TS.1>
			</RXE.18>
			<RXE.22>
				<xsl:value-of select="daysSupply" />
			</RXE.22>
			<RXE.31>
				<CE.1>
					<xsl:value-of
						select="../pharmacyRequest/orderedMedication/medicationCode/alternateCode" />
				</CE.1>
				<CE.2>
					<xsl:value-of
						select="../pharmacyRequest/orderedMedication/medicationCode/alternateDisplayText" />
				</CE.2>
				<CE.3>
					<xsl:value-of
						select="../pharmacyRequest/orderedMedication/medicationCode/alternateCodingSystem" />
				</CE.3>
			</RXE.31>
			<xsl:variable name="rxe31-RF">
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="../pharmacyRequest/orderedMedication/cmopDrugCode" />
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="string-length($rxe31-RF) > 0">
				<RXE.31>
					<xsl:call-template name="getCodedElement">
						<xsl:with-param name="theElement"
							select="../pharmacyRequest/orderedMedication/cmopDrugCode" />
					</xsl:call-template>
				</RXE.31>
			</xsl:if>	
		</RXE>
	</xsl:template>
	<!--
		############################################################################

		getNTE-RefillDispense
		applies to many NTE Segments concerning the refill dispense

	-->
	<xsl:template name="getNTE-RefillDispense">
		<NTE>
			<xsl:if test="comments">
				<NTE.1>1</NTE.1>
				<NTE.3>
					<xsl:value-of select="comments" />
				</NTE.3>
				<NTE.4>
					<CE.1>RE</CE.1>
					<CE.2>REMARKS</CE.2>
					<CE.3>
						<xsl:value-of
							select="../patient/identifier/assigningFacility" />
						<xsl:text>_52.1_3</xsl:text>
					</CE.3>
				</NTE.4>
			</xsl:if>
		</NTE>
	</xsl:template>
	<!--
		############################################################################

		getFT1-RefillDispense
		applies to the entire FT1 Segment concerning the refill dispense

	-->
	<xsl:template name="getFT1-RefillDispense">
		<FT1>
			<FT1.1>1</FT1.1>
			<FT1.4>
				<TS.1>
					<xsl:value-of select="fillDate/literal" />
				</TS.1>
			</FT1.4>
			<FT1.6>CG</FT1.6>
			<FT1.7>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="../pharmacyRequest/orderedItem/itemCode" />
				</xsl:call-template>
			</FT1.7>
			<FT1.12>
				<CP.1>
					<MO.1>
						<xsl:value-of
							select="dispensedDrug/drugUnitPrice/value" />
					</MO.1>
				</CP.1>
			</FT1.12>
		</FT1>
	</xsl:template>
	<!--
		############################################################################

		getORC-PartialDispense
		applies to entire ORC Segment concerning the partial dispense

	-->
	<xsl:template name="getORC-PartialDispense">
		<ORC>
			<ORC.1>RF</ORC.1>
			<ORC.3>
				<EI.1>
					<xsl:value-of select="identifier/identity" />
				</EI.1>
				<EI.2>
					<xsl:value-of select="identifier/namespaceId" />
				</EI.2>
			</ORC.3>
			<xsl:variable name="dispenseDate"
				select="dispenseDate/literal" />
			<xsl:if test="$dispenseDate != ''">
				<ORC.7>
					<TQ.4>
						<TS.1>
							<xsl:value-of select="$dispenseDate" />
						</TS.1>
					</TQ.4>
					<TQ.7>DISPENSED</TQ.7>
				</ORC.7>
			</xsl:if>
			<ORC.8>
				<EIP.2>
					<EI.1>
						<xsl:value-of
							select="../recordIdentifier/identity" />
					</EI.1>
				</EIP.2>
			</ORC.8>
			<ORC.9>
				<TS.1>
					<xsl:value-of select="loginDate/literal" />
				</TS.1>
			</ORC.9>
			<ORC.12>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver"
						select="currentProvider" />
				</xsl:call-template>
			</ORC.12>
			<ORC.16>
				<CE.1>PARTIAL</CE.1>
			</ORC.16>
			<ORC.17>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="division/divisionId" />
				</xsl:call-template>
				<CE.4>
					<xsl:value-of select="division/ncpdpId/code" />
				</CE.4>
				<CE.5>
					<xsl:value-of select="division/ncpdpId/displayText" />
				</CE.5>
				<CE.6>
					<xsl:value-of
						select="division/ncpdpId/codingSystem" />
				</CE.6>
			</ORC.17>
			<ORC.21>
				<XON.1>
					<xsl:value-of
						select="../pharmacyRequest/orderingInstitutionIdentifier/name" />
				</XON.1>
			</ORC.21>
		</ORC>
	</xsl:template>
	<!--
		############################################################################

		getRXE-PartialDispense
		applies to the entire RXE Segment concerning the partial dispense

	-->
	<xsl:template name="getRXE-PartialDispense">
		<RXE>
			<RXE.1>
				<TQ.4>
					<TS.1>
						<xsl:value-of select="fillDate/literal" />
					</TS.1>
				</TQ.4>
				<TQ.7>PARTIAL</TQ.7>
			</RXE.1>
			<RXE.2>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="../pharmacyRequest/orderedMedication/medicationCode" />
				</xsl:call-template>
				<CE.4>
					<xsl:value-of select="dispensedDrug/ndc/code" />
				</CE.4>
				<CE.5>
					<xsl:value-of
						select="dispensedDrug/ndc/displayText" />
				</CE.5>
				<CE.6>
					<xsl:value-of
						select="dispensedDrug/ndc/codingSystem" />
				</CE.6>
			</RXE.2>
			<RXE.3>0</RXE.3>
			<RXE.5>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="../medicationInstructions[1]/giveUnits" />
				</xsl:call-template>
			</RXE.5>
			<RXE.8>
				<LA1.6>
					<xsl:value-of select="mailWindow" />
				</LA1.6>
			</RXE.8>
			<RXE.10>
				<xsl:value-of select="quantityDispensed/value" />
			</RXE.10>
			<RXE.14>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver"
						select="pharmacist/practitioner" />
				</xsl:call-template>
			</RXE.14>
			<RXE.16>
				<xsl:choose>
					<xsl:when test="(string(number(../originalDispense/numberOfRefillsRemaining)) != 'NaN')">
						<xsl:value-of select="../originalDispense/numberOfRefillsRemaining" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="calculateRefillsRemaining">
							<xsl:with-param name="refills" select="count(../refillDispense)"/>
							<xsl:with-param name="authorized" select="../numberOfRefillsAuthorized"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</RXE.16>
			<RXE.18>
				<TS.1>
					<xsl:value-of select="releaseDate/literal" />
				</TS.1>
			</RXE.18>
			<RXE.22>
				<xsl:value-of select="daysSupply" />
			</RXE.22>
			<RXE.31>
				<CE.1>
					<xsl:value-of
						select="../pharmacyRequest/orderedMedication/medicationCode/alternateCode" />
				</CE.1>
				<CE.2>
					<xsl:value-of
						select="../pharmacyRequest/orderedMedication/medicationCode/alternateDisplayText" />
				</CE.2>
				<CE.3>
					<xsl:value-of
						select="../pharmacyRequest/orderedMedication/medicationCode/alternateCodingSystem" />
				</CE.3>
			</RXE.31>
			<!--RXE.31>
				<xsl:call-template name="getCodedElement">
				<xsl:with-param name="theElement" select="../pharmacyRequest/orderedMedication/cmopDrugCode"/>
				</xsl:call-template>
				</RXE.31-->
		</RXE>
	</xsl:template>
	<!--
		############################################################################

		getNTE-PartialDispense
		applies to many NTE Segments concerning the partial dispense

	-->
	<xsl:template name="getNTE-PartialDispense">
		<NTE>
			<xsl:if test="comments">
				<NTE.1>1</NTE.1>
				<NTE.3>
					<xsl:value-of select="comments" />
				</NTE.3>
				<NTE.4>
					<CE.1>RE</CE.1>
					<CE.2>REMARKS</CE.2>
					<CE.3>
						<xsl:value-of
							select="../patient/identifier/assigningFacility" />
						<xsl:text>_52.2_.03</xsl:text>
					</CE.3>
				</NTE.4>
			</xsl:if>
		</NTE>
	</xsl:template>
	<!--
		############################################################################

		getFT1-PartialDispense
		applies to the entire FT1 Segment concerning the partial dispense

	-->
	<xsl:template name="getFT1-PartialDispense">
		<FT1>
			<FT1.1>1</FT1.1>
			<FT1.4>
				<TS.1>
					<xsl:value-of select="fillDate/literal" />
				</TS.1>
			</FT1.4>
			<FT1.6>CG</FT1.6>
			<FT1.7>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="../pharmacyRequest/orderedItem/itemCode" />
				</xsl:call-template>
			</FT1.7>
			<FT1.12>
				<CP.1>
					<MO.1>
						<xsl:value-of
							select="dispensedDrug/drugUnitPrice/value" />
					</MO.1>
				</CP.1>
			</FT1.12>
		</FT1>
	</xsl:template>
	<!--
		###########################################################################
		################################# COMMON #################################
		###########################################################################
	-->
	<!--
		###########################################################################

		getMSH
		applies to the entire MSH Segment

	-->
	<xsl:template name="getMSH">
		<MSH>
			<MSH.1>^</MSH.1>
			<MSH.2>~|\&amp;</MSH.2>
			<MSH.3>
				<HD.1>HDRPRES</HD.1>
			</MSH.3>
			<MSH.4>
				<xsl:variable name="assigningFacility" select="patient/identifier/assigningFacility"/>
				<HD.1><xsl:value-of select="$assigningFacility" /></HD.1>
				<!-- <HD.2><xsl:value-of select="saxon:get-sendingfacility($global.hl7Utility, $assigningFacility)"/></HD.2> -->
				<HD.3>DNS</HD.3>
			</MSH.4>
			<MSH.5>
				<HD.1>PSO VDEF IE SIDE</HD.1>
			</MSH.5>
			<MSH.6>
				<HD.1>200HD</HD.1>
				<HD.2>HDRURL        </HD.2>
				<HD.3>DNS</HD.3>
			</MSH.6>
			<MSH.7>
				<TS.1>
					<xsl:value-of select="recordUpdateTime/literal" />
				</TS.1>
			</MSH.7>
			<MSH.9>
				<MSG.1>RDE</MSG.1>
				<MSG.2>O11</MSG.2>
			</MSH.9>
			<MSH.10><xsl:value-of select="saxon:create-message-controlid($global.hl7Support)" /></MSH.10>
			<MSH.11>
				<PT.1>P</PT.1>
			</MSH.11>
			<MSH.12>
				<VID.1>2.4</VID.1>
			</MSH.12>
			<MSH.15>NE</MSH.15>
			<MSH.16>NE</MSH.16>
			<MSH.17>USA</MSH.17>
		</MSH>
	</xsl:template>
	<!--
		############################################################################

		getPID
		applies to the entire PID Segment

	-->
	<xsl:template name="getPID">
		<PID>
			<PID.1>1</PID.1>
			<xsl:variable name="icn" select="/clinicaldata:ClinicalData/patient/requestedNationalId"/>
			<PID.2>
				<CX.1>
					<xsl:value-of select="saxon:add-checksum($icn)"/>
				</CX.1>
			</PID.2>
			<PID.3>
				<CX.1>
					<xsl:value-of select="saxon:add-checksum($icn)"/>
				</CX.1>
				<CX.4>
					<HD.1>USVHA</HD.1>
					<HD.3>0363</HD.3>
				</CX.4>
				<CX.5>NI</CX.5>
				<CX.6>
					<HD.1>VA FACILITY ID</HD.1>
					<HD.2>200M</HD.2>
					<HD.3>L</HD.3>
				</CX.6>
			</PID.3>
			<PID.3>
				<CX.1>
					<xsl:value-of select="patient/identifier/identity" />
				</CX.1>
				<CX.4>
					<HD.1>
						<xsl:value-of
							select="patient/identifier/assigningAuthority" />
					</HD.1>
					<HD.3>0363</HD.3>
				</CX.4>
				<CX.5>PI</CX.5>
				<CX.6>
					<HD.1>VA FACILITY ID</HD.1>
					<HD.2>
						<xsl:value-of
							select="patient/identifier/assigningFacility" />
					</HD.2>
					<HD.3>L</HD.3>
				</CX.6>
			</PID.3>
			<PID.5>
				<XPN.1>
					<FN.1>
						<xsl:value-of select="patient/name/family" />
					</FN.1>
				</XPN.1>
				<XPN.2>
					<xsl:value-of select="patient/name/given" />
				</XPN.2>
				<XPN.3>
					<xsl:value-of select="patient/name/middle" />
				</XPN.3>
				<XPN.7>L</XPN.7>
			</PID.5>
		</PID>
	</xsl:template>
	<!--
		############################################################################

		getCodedElement (CE)
		applies to the CE HL7 datatype

	-->
	<xsl:template name="getCodedElement">
		<xsl:param name="theElement" />
		<CE.1>
			<xsl:value-of select="$theElement/code" />
		</CE.1>
		<CE.2>
			<xsl:value-of select="$theElement/displayText" />
		</CE.2>
		<CE.3>
			<xsl:value-of select="$theElement/codingSystem" />
		</CE.3>
	</xsl:template>
	<!--
		############################################################################

		getCodedElementAlternate (CE - alternate values)
		applies to the CE HL7 datatype

	-->
	<xsl:template name="getCodedElementAlternate">
		<xsl:param name="theElement" />
		<CE.4>
			<xsl:value-of select="$theElement/alternateCode" />
		</CE.4>
		<CE.5>
			<xsl:value-of select="$theElement/alternateDisplayText" />
		</CE.5>
		<CE.6>
			<xsl:value-of select="$theElement/alternateCodingSystem" />
		</CE.6>
	</xsl:template>
	<!--
		############################################################################

		getObservingPractitioner (CM_NDL)
		applies to the CM_NDL HL7 datatype

	-->
	<xsl:template name="getObservingPractitioner">
		<xsl:param name="thePractitioner" />
		<xsl:param name="theTime" />
		<!--xsl:param name="theSource"/-->
		<CM_NDL.1>
			<CN.1>
				<xsl:value-of
					select="$thePractitioner/identifier/identity" />
			</CN.1>
			<CN.2>
				<FN.1>
					<xsl:value-of select="$thePractitioner/name/family" />
				</FN.1>
			</CN.2>
			<CN.3>
				<xsl:value-of select="$thePractitioner/name/given" />
			</CN.3>
			<CN.4>
				<xsl:value-of select="$thePractitioner/name/middle" />
			</CN.4>
			<CN.5>
				<xsl:value-of select="$thePractitioner/name/suffix" />
			</CN.5>
			<CN.6>
				<xsl:value-of select="$thePractitioner/name/prefix" />
			</CN.6>
			<CN.7>
				<xsl:value-of select="$thePractitioner/name/title" />
			</CN.7>
			<CN.8>
				<xsl:value-of select="$thePractitioner/idSourceTable" />
				<!--xsl:value-of select="$theSource"/-->
			</CN.8>
		</CM_NDL.1>
		<CM_NDL.2>
			<TS.1>
				<xsl:value-of select="$theTime" />
			</TS.1>
		</CM_NDL.2>
	</xsl:template>
	<!--
		############################################################################

		getResponsibleObserver (XCN)
		applies to the XCN HL7 datatype

	-->
	<xsl:template name="getResponsibleObserver">
		<xsl:param name="theObserver" />
		<XCN.1>
			<xsl:value-of select="$theObserver/identifier/identity" />
		</XCN.1>
		<XCN.2>
			<FN.1>
				<xsl:value-of select="$theObserver/name/family" />
			</FN.1>
		</XCN.2>
		<XCN.3>
			<xsl:value-of select="$theObserver/name/given" />
		</XCN.3>
		<XCN.4>
			<xsl:value-of select="$theObserver/name/middle" />
		</XCN.4>
		<XCN.5>
			<xsl:value-of select="$theObserver/name/suffix" />
		</XCN.5>
		<XCN.6>
			<xsl:value-of select="$theObserver/name/prefix" />
		</XCN.6>
		<XCN.7>
			<xsl:value-of select="$theObserver/name/title" />
		</XCN.7>
		<XCN.8>
			<xsl:value-of select="$theObserver/idSourceTable" />
		</XCN.8>
	</xsl:template>
	<xsl:template name="getBTS">
		<BTS>
			<BTS.1>
				{FINAL_BTS_COUNT}
			</BTS.1>
		</BTS>
	</xsl:template>
	
	<xsl:template name="calculateRefillsRemaining">
		<xsl:param name="refills" />
		<xsl:param name="authorized" />
		<xsl:choose>
			<xsl:when test="(string(number($authorized)) != 'NaN')">
				<xsl:if test="$authorized != '' ">
					<xsl:value-of select="$authorized - $refills" />
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$authorized" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
