<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:saxon="http://saxon.sf.net/"
	exclude-result-prefixes="fn xs xsi xsl saxon"
	xmlns:clinicaldata="Clinicaldata" xmlns="urn:hl7-org:v2xml">
	<xsl:output method="xml" encoding="UTF-8" indent="yes" />

	<xsl:param name="global.hl7Support"/>
	<xsl:param name="global.workState"/>
	<xsl:param name="global.hl7Utility"/>

	<xsl:template match="/clinicaldata:ClinicalData">
		<xsl:variable name="messageDateTime" as="xs:string"
					select="saxon:create-message-datetime($global.hl7Support)" />
		<QRY_Q01>
			<xsl:call-template name="getBHS" >
				<xsl:with-param name="messageDateTime" select="$messageDateTime"/>
			</xsl:call-template>
			<xsl:call-template name="getERR" />
			<xsl:call-template name="getQPD" >
				<xsl:with-param name="messageDateTime" select="$messageDateTime"/>
			</xsl:call-template>
			<xsl:call-template name="getRCP" />
			<xsl:for-each select="patient/intoleranceConditions">
				<xsl:call-template name="getORU" />
			</xsl:for-each>
			<xsl:for-each select="patient/allergyAssessments">
				<xsl:call-template name="getAssessment" />
			</xsl:for-each>
			<xsl:call-template name="getBTS" />
		</QRY_Q01>
	</xsl:template>
	<xsl:template name="getBHS">
		<xsl:param name="messageDateTime"/>
		<BHS>
			<BHS.1>^</BHS.1>
			<BHS.2>~|\&amp;</BHS.2>
			<BHS.3>VHA_HDR</BHS.3>
			<BHS.4>HDR</BHS.4>
			<BHS.5>CHDR SENDER</BHS.5>
			<BHS.6>CHDR</BHS.6>
			<BHS.7>
				<TS.1><xsl:value-of select="$messageDateTime"/></TS.1>
			</BHS.7>
			<BHS.9><xsl:text>RSP*Z98*QRY_Q01</xsl:text></BHS.9>
		</BHS>
	</xsl:template>
	<xsl:template name="getERR">
		<ERR>		
			<xsl:if test="saxon:get-exception-count($global.workState) > 0">
				<ERR.1>
					<ELD.4>
						<CE.1>
							<xsl:text>MEDIATOR-ERROR</xsl:text>
						</CE.1>
						<CE.2>
							<xsl:value-of select="saxon:get-formatted-exception-detail($global.workState)" />
						</CE.2>
						<CE.3>
							<xsl:text>NA</xsl:text>
						</CE.3>
					</ELD.4>
				</ERR.1>
			</xsl:if>
			<xsl:for-each select="errorSection/fatalErrors">
				<ERR.1>
					<ELD.4>
						<CE.1>
							<xsl:value-of select="errorId" />
						</CE.1>
						<CE.2>
							<xsl:value-of select="displayMessage" />
						</CE.2>
						<CE.3>
							<xsl:value-of select="errorCode" />
						</CE.3>
					</ELD.4>
				</ERR.1>
			</xsl:for-each>
			<xsl:for-each select="errorSection/warnings">
				<xsl:if test="(errorCode='READ_REQUEST_DATA_SOURCE_FAILURE') or (errorCode='READ_REQUEST_DATA_SOURCE_ALL_EXCEPTIONS')">
							<ERR.1>
						<ELD.4>
							<CE.1>
								<xsl:value-of select="errorId" />
							</CE.1>
							<CE.2>
								<xsl:value-of select="displayMessage" />
							</CE.2>
							<CE.3>
								<xsl:value-of select="errorCode" />
							</CE.3>
						</ELD.4>
					</ERR.1>
				</xsl:if>
			</xsl:for-each>
		</ERR>
	</xsl:template>
	<xsl:template name="getQPD">
		<xsl:param name="messageDateTime" />
		<QPD>
			<QPD.1>
				<CE.1>OC_CHDR</CE.1>
			</QPD.1>
			<QPD.3>
				<xsl:value-of select="patient/requestedNationalId"/>
			</QPD.3>
			<QPD.4>CHDR_ALGY</QPD.4>
			<QPD.5><xsl:value-of select="saxon:get-message-data($global.hl7Support, '/QPD-5')"/></QPD.5>
			<QPD.6><xsl:value-of select="saxon:get-message-data($global.hl7Support, '/QPD-6')"/></QPD.6>
		</QPD>
	</xsl:template>
	<xsl:template name="getRCP">
		<RCP>
			<RCP.1>I</RCP.1>
			<RCP.2>
				<CQ.1>100</CQ.1>
				<CQ.2>
					<CE.1>RD</CE.1>
				</CQ.2>
			</RCP.2>
			<RCP.3>
				<CE.1>B</CE.1>
			</RCP.3>
			<RCP.4>
				<TS.1></TS.1>
			</RCP.4>
		</RCP>
	</xsl:template>
	<xsl:template name="getORU">
	<xsl:variable name="allergySendingApp">HDRALGY</xsl:variable>
		<ORU_R01>
			<xsl:call-template name="getMSH">
				<xsl:with-param name="sendingApp" select="$allergySendingApp"/>
			</xsl:call-template>
			<ORU_R01.PATIENT_RESULT>
				<ORU_R01.PATIENT>
					<xsl:call-template name="getPID"/>
				</ORU_R01.PATIENT>
				<ORU_R01.ORDER_OBSERVATION>
					<xsl:call-template name="getOBR" />
					<ORU_R01.OBSERVATION>
						<xsl:call-template name="getOBX1" />
					</ORU_R01.OBSERVATION>
					<ORU_R01.OBSERVATION>
						<xsl:call-template name="getOBX2" />
					</ORU_R01.OBSERVATION>
					<ORU_R01.OBSERVATION>
						<xsl:call-template name="getOBX3" />
					</ORU_R01.OBSERVATION>
					<ORU_R01.OBSERVATION>
						<xsl:call-template name="getOBX4" />
					</ORU_R01.OBSERVATION>
					<ORU_R01.OBSERVATION>
						<xsl:call-template name="getOBX5" />
					</ORU_R01.OBSERVATION>
					<ORU_R01.OBSERVATION>
						<xsl:call-template name="getOBX6" />
					</ORU_R01.OBSERVATION>
					<xsl:for-each select="reaction">
						<ORU_R01.OBSERVATION>
							<xsl:call-template name="getOBX7" />
						</ORU_R01.OBSERVATION>
					</xsl:for-each>
					<xsl:for-each select="commentEvents">
						<ORU_R01.OBSERVATION>
							<xsl:call-template name="getOBX8" />
						</ORU_R01.OBSERVATION>
					</xsl:for-each>
				</ORU_R01.ORDER_OBSERVATION>
			</ORU_R01.PATIENT_RESULT>
		</ORU_R01>
	</xsl:template>
	<!--
		############################################################################

		getAssessment
		applies to the entire Allergy Assessment record
		adding text for not purpose

	-->
	<xsl:template name="getAssessment">
		<ORU_R01>
		<xsl:variable name="assessmentSendingApp">HDRADAS</xsl:variable>
			<xsl:call-template name="getMSH">
				<xsl:with-param name="sendingApp" select="$assessmentSendingApp"/>
			</xsl:call-template>
			<ORU_R01.PATIENT_RESULT>
				<ORU_R01.PATIENT>
					<xsl:call-template name="getPID"/>
				</ORU_R01.PATIENT>
				<ORU_R01.ORDER_OBSERVATION>
					<xsl:call-template name="getAssessmentOBR" />
					<ORU_R01.OBSERVATION>
						<xsl:call-template name="getAssessmentOBX" />
					</ORU_R01.OBSERVATION>
				</ORU_R01.ORDER_OBSERVATION>
			</ORU_R01.PATIENT_RESULT>
		</ORU_R01>
	</xsl:template>
	<!--
		############################################################################

		getOBR
		applies to the entire OBR Segment

	-->
	<xsl:template name="getOBR">
		<OBR>
			<OBR.1>1</OBR.1>
			<OBR.3>
				<EI.1>
					<xsl:value-of select="recordIdentifier/identity" />
				</EI.1>
				<EI.2>
					<xsl:value-of select="recordIdentifier/namespaceId" />
				</EI.2>
			</OBR.3>
			<OBR.4>
				<CE.1>ALLERGY</CE.1>
				<CE.3>L</CE.3>
			</OBR.4>
			<OBR.7>
				<TS.1>
					<xsl:value-of select="observationTime/literal" />
				</TS.1>
			</OBR.7>
			<OBR.25>
				<xsl:choose>
					<xsl:when test="status='E'"><xsl:text>E</xsl:text></xsl:when>
					<xsl:otherwise><xsl:text>F</xsl:text></xsl:otherwise>
				</xsl:choose>
			</OBR.25>
			<OBR.32>
				<xsl:call-template name="getObservingPractitioner">
					<xsl:with-param name="thePractitioner"
						select="author/practitioner" />
						<xsl:with-param name="theSource" select="author/practitioner/idSourceTable"/>
				</xsl:call-template>
			</OBR.32>
			<xsl:for-each select="author">
				<OBR.34>
					<xsl:call-template name="getObservingPractitioner">
					<xsl:with-param name="thePractitioner" select="practitioner"/>
					<xsl:with-param name="theTime" select="../observationTime/literal"/>
					<xsl:with-param name="theSource"><xsl:text>E</xsl:text></xsl:with-param>
					</xsl:call-template>
					</OBR.34>
			</xsl:for-each>
			<xsl:for-each select="verifier">
				<OBR.34>
					<xsl:call-template
						name="getObservingPractitioner">
						<xsl:with-param name="thePractitioner"
							select="practitioner" />
						<xsl:with-param name="theTime"
							select="time/literal" />
						<xsl:with-param name="theSource" select="practitioner/idSourceTable"/>
					</xsl:call-template>
				</OBR.34>
			</xsl:for-each>
			<xsl:for-each select="errorEnterer">
				<OBR.34>
					<xsl:call-template
						name="getObservingPractitioner">
						<xsl:with-param name="thePractitioner"
							select="practitioner" />
						<xsl:with-param name="theTime"
							select="time/literal" />
						<xsl:with-param name="theSource" select="practitioner/idSourceTable"/>
					</xsl:call-template>
				</OBR.34>
			</xsl:for-each>
			<xsl:for-each select="idBandMarker">
				<OBR.34>
					<xsl:call-template
						name="getObservingPractitioner">
						<xsl:with-param name="thePractitioner"
							select="practitioner" />
						<xsl:with-param name="theTime"
							select="time/literal" />
						<xsl:with-param name="theSource" select="practitioner/idSourceTable"/>
					</xsl:call-template>
				</OBR.34>
			</xsl:for-each>
			<xsl:for-each select="chartMarker">
				<OBR.34>
					<xsl:call-template
						name="getObservingPractitioner">
						<xsl:with-param name="thePractitioner"
							select="practitioner" />
						<xsl:with-param name="theTime"
							select="time/literal" />
						<xsl:with-param name="theSource" select="practitioner/idSourceTable"/>
					</xsl:call-template>
				</OBR.34>
			</xsl:for-each>
			<OBR.47>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="informationSourceCategory" />
				</xsl:call-template>
			</OBR.47>
		</OBR>
	</xsl:template>
	<!--
		############################################################################

		getAssessmentOBR
		applies to the entire Assessment OBR Segment

	-->
	<xsl:template name="getAssessmentOBR">
		<OBR>
			<OBR.1>1</OBR.1>
			<OBR.3>
				<EI.1>
					<xsl:value-of select="recordIdentifier/identity" />
				</EI.1>
				<EI.2>
					<xsl:value-of select="recordIdentifier/namespaceId" />
				</EI.2>
			</OBR.3>
			<OBR.4>
				<CE.1>ASSESSMENT</CE.1>
				<CE.3>L</CE.3>
			</OBR.4>
			<OBR.7>
				<TS.1>
					<xsl:value-of select="observationTime/literal" />
				</TS.1>
			</OBR.7>
			<OBR.25>
				<xsl:value-of select="status" />
			</OBR.25>
			<OBR.32>
				<xsl:call-template name="getObservingPractitioner">
					<xsl:with-param name="thePractitioner"
						select="author/practitioner" />
						<xsl:with-param name="theSource" select="author/practitioner/idSourceTable"/>
				</xsl:call-template>
			</OBR.32>
		</OBR>
	</xsl:template>
	<!--
		############################################################################

		getAssessmentOBX
		applies to the Assessment OBX Segment
	-->
	<xsl:template name="getAssessmentOBX">
		<OBX>
			<OBX.1>1</OBX.1>
			<OBX.2>CE</OBX.2>
			<OBX.3>
				<CNE.1>ASSESSMENT</CNE.1>
			</OBX.3>
			<OBX.5>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement" select="assessmentValue" />
				</xsl:call-template>
			</OBX.5>
			<OBX.11>
				<xsl:call-template name="decodeStatus">
					<xsl:with-param name="status" select="status" />
				</xsl:call-template>
			</OBX.11>
			<OBX.14>
				<TS.1>
					<xsl:value-of select="observationTime/literal" />
				</TS.1>
			</OBX.14>
			<OBX.16>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver"
						select="author/practitioner" />
				</xsl:call-template>
			</OBX.16>
		</OBX>
	</xsl:template>
	<!--
		############################################################################

		getOBX1
		applies to the one of many OBX Segment

	-->
	<xsl:template name="getOBX1">
		<OBX>
			<OBX.1>1</OBX.1>
			<OBX.2>CE</OBX.2>
			<OBX.3>
				<CNE.1>AGENT</CNE.1>
			</OBX.3>
			<OBX.5>
				<CE.1>
					<xsl:value-of select="agent/code" />
				</CE.1>
			</OBX.5>
			<OBX.11>
				<xsl:call-template name="decodeStatus">
					<xsl:with-param name="status" select="status" />
				</xsl:call-template>
			</OBX.11>
			<OBX.15>
				<CE.1>
					<xsl:value-of select="facilityIdentifier/identity" />
				</CE.1>
				<CE.2>
					<xsl:value-of select="facilityIdentifier/name" />
				</CE.2>
				<CE.3>L</CE.3>
			</OBX.15>
		</OBX>
	</xsl:template>
	<!--
		############################################################################

		getOBX2
		applies to the one of many OBX Segment

	-->
	<xsl:template name="getOBX2">
		<OBX>
			<OBX.1>1</OBX.1>
			<OBX.2>CE</OBX.2>
			<OBX.3>
				<CNE.1>ALLERGY TYPE</CNE.1>
			</OBX.3>
			<OBX.5>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="allergyType" />
				</xsl:call-template>
			</OBX.5>
			<OBX.11>
				<xsl:call-template name="decodeStatus">
					<xsl:with-param name="status" select="status" />
				</xsl:call-template>
			</OBX.11>
		</OBX>
	</xsl:template>
	<!--
		############################################################################

		getOBX3
		applies to the one of many OBX Segment

	-->
	<xsl:template name="getOBX3">
		<OBX>
			<OBX.1>1</OBX.1>
			<OBX.2>CE</OBX.2>
			<OBX.3>
				<CNE.1>GMR ALLERGY</CNE.1>
			</OBX.3>
			<OBX.5>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="gmrAllergyAgent" />
				</xsl:call-template>
				<xsl:call-template name="getCodedElementAlternate">
					<xsl:with-param name="theElement"
						select="gmrAllergyAgent" />
				</xsl:call-template>
			</OBX.5>
			<OBX.11>
				<xsl:call-template name="decodeStatus">
					<xsl:with-param name="status" select="status" />
				</xsl:call-template>
			</OBX.11>
		</OBX>
	</xsl:template>
	<!--
		############################################################################

		getOBX4
		applies to the one of many OBX Segment

	-->
	<xsl:template name="getOBX4">
		<OBX>
			<OBX.1>1</OBX.1>
			<OBX.2>CE</OBX.2>
			<OBX.3>
				<CNE.1>DRUG INGREDIENTS</CNE.1>
			</OBX.3>
			<xsl:for-each select="drugIngredient">
				<OBX.5>
					<xsl:call-template name="getCodedElement">
						<xsl:with-param name="theElement" select="code" />
					</xsl:call-template>
				</OBX.5>
			</xsl:for-each>
			<OBX.11>
				<xsl:call-template name="decodeStatus">
					<xsl:with-param name="status" select="status" />
				</xsl:call-template>
			</OBX.11>
		</OBX>
	</xsl:template>
	<!--
		############################################################################

		getOBX5
		applies to the one of many OBX Segment

	-->
	<xsl:template name="getOBX5">
		<OBX>
			<OBX.1>1</OBX.1>
			<OBX.2>CE</OBX.2>
			<OBX.3>
				<CNE.1>DRUG CLASSES</CNE.1>
			</OBX.3>
			<xsl:for-each select="drugClass">
				<OBX.5>
					<xsl:call-template name="getCodedElement">
						<xsl:with-param name="theElement" select="code" />
					</xsl:call-template>
					<xsl:call-template
						name="getCodedElementAlternate">
						<xsl:with-param name="theElement" select="code" />
					</xsl:call-template>
				</OBX.5>
			</xsl:for-each>
			<OBX.11>
				<xsl:call-template name="decodeStatus">
					<xsl:with-param name="status" select="status" />
				</xsl:call-template>
			</OBX.11>
		</OBX>
	</xsl:template>
	<!--
		############################################################################

		getOBX6
		applies to the one of many OBX Segment

	-->
	<xsl:template name="getOBX6">
		<OBX>
			<OBX.1>1</OBX.1>
			<OBX.2>CE</OBX.2>
			<OBX.3>
				<CNE.1>MECHANISM</CNE.1>
			</OBX.3>
			<OBX.5>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="mechanism" />
				</xsl:call-template>
			</OBX.5>
			<OBX.11>
				<xsl:call-template name="decodeStatus">
					<xsl:with-param name="status" select="status" />
				</xsl:call-template>
			</OBX.11>
		</OBX>
	</xsl:template>
	<!--
		############################################################################

		getOBX7
		applies to the one of many OBX Segment

	-->
	<xsl:template name="getOBX7">
		<OBX>
			<OBX.1>1</OBX.1>
			<OBX.2>CE</OBX.2>
			<OBX.3>
				<CNE.1>REACTION</CNE.1>
			</OBX.3>
			<OBX.5>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement" select="reaction" />
				</xsl:call-template>
			</OBX.5>
			<OBX.11>
				<xsl:call-template name="decodeStatus">
					<xsl:with-param name="status" select="../status" />
				</xsl:call-template>
			</OBX.11>
			<OBX.14>
				<TS.1>
					<xsl:value-of select="observationTime/literal" />
				</TS.1>
			</OBX.14>
			<OBX.16>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver"
						select="author/practitioner" />
				</xsl:call-template>
			</OBX.16>
		</OBX>
	</xsl:template>
	<!--
		############################################################################

		getOBX8
		applies to the one of many OBX Segment

	-->
	<xsl:template name="getOBX8">
		<OBX>
			<OBX.1>1</OBX.1>
			<OBX.2>TX</OBX.2>
			<OBX.3>
				<CNE.1>COMMENT</CNE.1>
			</OBX.3>
				<xsl:for-each select="comments">
					<OBX.5>
						<xsl:value-of select="." />
					</OBX.5>
				</xsl:for-each>
			<OBX.11>
				<xsl:call-template name="decodeStatus">
					<xsl:with-param name="status" select="../status" />
				</xsl:call-template>
			</OBX.11>
			<OBX.16>
				<xsl:call-template name="getResponsibleObserver">
					<xsl:with-param name="theObserver" select="author" />
				</xsl:call-template>
			</OBX.16>
			<OBX.17>
				<xsl:call-template name="getCodedElement">
					<xsl:with-param name="theElement"
						select="commentType" />
				</xsl:call-template>
			</OBX.17>
			<OBX.19>
				<TS.1>
					<xsl:value-of select="date/literal" />
				</TS.1>
			</OBX.19>
		</OBX>
	</xsl:template>

	<!--
		###########################################################################
		################################# COMMON #################################
		###########################################################################
	-->
	<!--
		###########################################################################

		getMSH
		applies to the entire MSH Segment

	-->
	<xsl:template name="getMSH">
		<xsl:param name="sendingApp"/>
		<MSH>
			<MSH.1>^</MSH.1>
			<MSH.2>~|\&amp;</MSH.2>
			<MSH.3>
				<HD.1><xsl:value-of select="$sendingApp" /></HD.1>
			</MSH.3>
			<MSH.4>
				<xsl:variable name="assigningFacility" select="patient/identifier/assigningFacility"/>
				<HD.1><xsl:value-of select="$assigningFacility" /></HD.1>
				<HD.2><xsl:value-of select="saxon:get-sendingfacility($global.hl7Utility, $assigningFacility)"/></HD.2>
				<HD.3>DNS</HD.3>
			</MSH.4>
			<MSH.5>
				<HD.1>GMRA VDEF IE SIDE</HD.1>
			</MSH.5>
			<MSH.6>
				<HD.1>200HD</HD.1>
				<HD.2>HDRURL        </HD.2>
				<HD.3>DNS</HD.3>
			</MSH.6>
			<MSH.7>
				<TS.1>
					<xsl:value-of select="recordUpdateTime/literal" />
				</TS.1>
			</MSH.7>
			<MSH.9>
				<MSG.1>ORU</MSG.1>
				<MSG.2>R01</MSG.2>
			</MSH.9>
			<MSH.10><xsl:value-of select="saxon:create-message-controlid($global.hl7Support)" /></MSH.10>
			<MSH.11>
				<PT.1>P</PT.1>
			</MSH.11>
			<MSH.12>
				<VID.1>2.4</VID.1>
			</MSH.12>
			<MSH.15>NE</MSH.15>
			<MSH.16>NE</MSH.16>
			<MSH.17>USA</MSH.17>
		</MSH>
	</xsl:template>
	<!--
		############################################################################

		getPID
		applies to the entire PID Segment

	-->
	<xsl:template name="getPID">
		<PID>
			<PID.1>1</PID.1>
			<xsl:variable name="icn" select="/clinicaldata:ClinicalData/patient/requestedNationalId"/>
			<PID.2>
				<CX.1>
					<xsl:value-of select="saxon:add-checksum($icn)"/>
				</CX.1>
			</PID.2>
			<PID.3>
				<CX.1>
					<xsl:value-of select="saxon:add-checksum($icn)"/>
				</CX.1>
				<CX.4>
					<HD.1>USVHA</HD.1>
					<HD.3>0363</HD.3>
				</CX.4>
				<CX.5>NI</CX.5>
				<CX.6>
					<HD.1>VA FACILITY ID</HD.1>
					<HD.2>200M</HD.2>
					<HD.3>L</HD.3>
				</CX.6>
			</PID.3>
			<PID.3>
				<CX.1>
					<xsl:value-of select="patient/identifier/identity" />
				</CX.1>
				<CX.4>
					<HD.1>
						<xsl:value-of
							select="patient/identifier/assigningAuthority" />
					</HD.1>
					<HD.3>0363</HD.3>
				</CX.4>
				<CX.5>PI</CX.5>
				<CX.6>
					<HD.1>VA FACILITY ID</HD.1>
					<HD.2>
						<xsl:value-of
							select="patient/identifier/assigningFacility" />
					</HD.2>
					<HD.3>L</HD.3>
				</CX.6>
			</PID.3>
			<PID.5>
				<XPN.1>
					<FN.1>
						<xsl:value-of select="patient/name/family" />
					</FN.1>
				</XPN.1>
				<XPN.2>
					<xsl:value-of select="patient/name/given" />
				</XPN.2>
				<XPN.3>
					<xsl:value-of select="patient/name/middle" />
				</XPN.3>
				<XPN.7>L</XPN.7>
			</PID.5>
		</PID>
	</xsl:template>
	<!--
		############################################################################

		getCodedElement (CE)
		applies to the CE HL7 datatype

	-->
	<xsl:template name="getCodedElement">
		<xsl:param name="theElement" />
		<CE.1>
			<xsl:value-of select="$theElement/code" />
		</CE.1>
		<CE.2>
			<xsl:value-of select="$theElement/displayText" />
		</CE.2>
		<CE.3>
			<xsl:value-of select="$theElement/codingSystem" />
		</CE.3>
	</xsl:template>
	<!--
		############################################################################

		getCodedElementAlternate (CE - alternate values)
		applies to the CE HL7 datatype

	-->
	<xsl:template name="getCodedElementAlternate">
		<xsl:param name="theElement" />
		<CE.4>
			<xsl:value-of select="$theElement/alternateCode" />
		</CE.4>
		<CE.5>
			<xsl:value-of select="$theElement/alternateDisplayText" />
		</CE.5>
		<CE.6>
			<xsl:value-of select="$theElement/alternateCodingSystem" />
		</CE.6>
	</xsl:template>
	<!--
		############################################################################

		getObservingPractitioner (CM_NDL) - *HAPI sees this as NDL
		applies to the CM_NDL HL7 datatype
	-->
	<xsl:template name="getObservingPractitioner">
		<xsl:param name="thePractitioner" />
		<xsl:param name="theTime" />
		<xsl:param name="theSource"/>
		<NDL.1>
			<CNN.1>
				<xsl:value-of select="$thePractitioner/identifier/identity" />
			</CNN.1>
			<CNN.2>
				<xsl:value-of select="$thePractitioner/name/family" />
			</CNN.2>
			<CNN.3>
				<xsl:value-of select="$thePractitioner/name/given" />
			</CNN.3>
			<CNN.4>
				<xsl:value-of select="$thePractitioner/name/middle" />
			</CNN.4>
			<CNN.5>
				<xsl:value-of select="$thePractitioner/name/suffix" />
			</CNN.5>
			<CNN.6>
				<xsl:value-of select="$thePractitioner/name/prefix" />
			</CNN.6>
			<CNN.7>
				<xsl:value-of select="$thePractitioner/name/title" />
			</CNN.7>
			<CNN.8>
				<xsl:value-of select="$theSource"/>
			</CNN.8>
		</NDL.1>
		<xsl:if test="$theTime != ''">
			<NDL.2>
				<TS.1>
					<xsl:value-of select="$theTime" />
				</TS.1>
			</NDL.2>
		</xsl:if>
	</xsl:template>
	<!--
		############################################################################

		getResponsibleObserver (XCN)
		applies to the XCN HL7 datatype

	-->
	<xsl:template name="getResponsibleObserver">
		<xsl:param name="theObserver" />
		<XCN.1>
			<xsl:value-of select="$theObserver/identifier/identity" />
		</XCN.1>
		<XCN.2>
			<FN.1>
				<xsl:value-of select="$theObserver/name/family" />
			</FN.1>
		</XCN.2>
		<XCN.3>
			<xsl:value-of select="$theObserver/name/given" />
		</XCN.3>
		<XCN.4>
			<xsl:value-of select="$theObserver/name/middle" />
		</XCN.4>
		<XCN.5>
			<xsl:value-of select="$theObserver/name/suffix" />
		</XCN.5>
		<XCN.6>
			<xsl:value-of select="$theObserver/name/prefix" />
		</XCN.6>
		<XCN.7>
			<xsl:value-of select="$theObserver/name/title" />
		</XCN.7>
		<XCN.8>
			<xsl:value-of select="$theObserver/idSourceTable" />
		</XCN.8>
	</xsl:template>
	<xsl:template name="getBTS">
		<BTS>
			<BTS.1>
				{FINAL_BTS_COUNT}
			</BTS.1>
		</BTS>
	</xsl:template>
	<!--
		Template determines if the returned status value needs to be transformed
		from 'E' to 'W' - else it remains what it is - 'F'
	 -->
	<xsl:template name="decodeStatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status='E'"><xsl:text>W</xsl:text></xsl:when>
			<xsl:otherwise><xsl:text>F</xsl:text></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
