<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:ns0="urn:hl7-org:v2xml" exclude-result-prefixes="xs fn ns0" xmlns:saxon="http://saxon.sf.net/" xmlns:hthsurvey="HT_DMP_RESPONSE">

<!-- 

	<xsl:include href="SurveyCommonTemplates.xsl"/> 

	<xsl:include href="Hl7CommonTemplates.xsl"/>

-->



<!--  From HL7CommonTemplates.xsl -->	



	<!--

		##################################################################################################################

		########################################## HL7 COMMON TEMPLATES ###############################################



		getRecordIdentifier template

		applies to any path ending in EI and transforming EI.1 and EI.2 into identity and namespaceId respectively



	-->

	<xsl:template name="getRecordIdentifier">

		<xsl:if test="((ns0:EI.1 != '') and (ns0:EI.2 != ''))">

			<recordIdentifier>

				<identity>

					<xsl:value-of select="ns0:EI.1"/>

				</identity>

				<namespaceId>

					<xsl:value-of select="ns0:EI.2"/>

				</namespaceId>

			</recordIdentifier>

		</xsl:if>

	</xsl:template>

	

	<!--

		##################################################################################################################



		getNationalId template

		applies to any path ending in EI and transforming EI.1 and EI.2 into identity and namespaceId respectively



	-->

	<xsl:template name="getNationalId">

		

		<xsl:if test="(ns0:CX.1 != '')">

			<icn>

				<xsl:value-of select="ns0:CX.1"/>

			</icn>

		</xsl:if>

		

	</xsl:template>

	

	<!--

		##################################################################################################################



		getSsn template

		applies to any path ending in EI and transforming EI.1 and EI.2 into identity and namespaceId respectively



	-->

	<xsl:template name="getSsn">

		

		<xsl:if test="(ns0:CX.1 != '')">

			<ssn>

				<xsl:value-of select="ns0:CX.1"/>

			</ssn>

		</xsl:if>

		

	</xsl:template>

	

	<!--

		##################################################################################################################



		getPatientLite template

		applies to PID/ns0:PID.3[ns0:CX.5 = 'PI'] path



	-->

	<xsl:template name="getPatientLite">

		<xsl:if test="((ns0:CX.1 != '') and (ns0:CX.6/ns0:HD.2 != '') and (ns0:CX.4/ns0:HD.1 != ''))">

			<patient>

				<identifier>

					<identity>

						<xsl:value-of select="ns0:CX.1"/>

					</identity>

					<assigningFacility>

						<xsl:value-of select="ns0:CX.6/ns0:HD.2"/>

					</assigningFacility>

					<assigningAuthority>

						<xsl:value-of select="ns0:CX.4/ns0:HD.1"/>

					</assigningAuthority>

				</identifier>

				<!-- get  'L' (legal) name of this patient when possible otherwise take the first occurrence-->

				<xsl:choose>

					<xsl:when test="../ns0:PID.5[ns0:XPN.7 = 'L']">

						<name>

							<prefix>

								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.5"/>

							</prefix>

							<given>

								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.2"/>

							</given>

							<middle>

								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.3"/>

							</middle>

							<family>

								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.1/ns0:FN.1"/>

							</family>

							<suffix>

								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.4"/>

							</suffix>

							<title>

								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.6"/>

							</title>

						</name>

					</xsl:when>

					<xsl:otherwise>

						<xsl:if test="../ns0:PID.5[1]/ns0:XPN.1/ns0:FN.1">

							<name>

								<prefix>

									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.5"/>

								</prefix>

								<given>

									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.2"/>

								</given>

								<middle>

									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.3"/>

								</middle>

								<family>

									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.1/ns0:FN.1"/>

								</family>

								<suffix>

									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.4"/>

								</suffix>

								<title>

									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.6"/>

								</title>

							</name>

						</xsl:if>

					</xsl:otherwise>

				</xsl:choose>

			</patient>

		</xsl:if>

	</xsl:template>

	<!--

		##################################################################################################################



		getRecordInformation template

		applies to MSH path



	-->

	<xsl:template name="getRecordInformation">

		<xsl:if test="(ns0:MSH.4/ns0:HD.1 != '')">

			<recordSource>

				<namespaceId>

					<xsl:value-of select="ns0:MSH.4/ns0:HD.1"/>

				</namespaceId>

				<universalId>

					<xsl:value-of select="ns0:MSH.4/ns0:HD.2"/>

				</universalId>

				<universalIdType>

					<xsl:value-of select="ns0:MSH.4/ns0:HD.3"/>

				</universalIdType>

			</recordSource>

		</xsl:if>

		<xsl:if test="(ns0:MSH.7/ns0:TS.1 != '')">

			<recordUpdateTime>

				<literal>

					<xsl:value-of select="ns0:MSH.7/ns0:TS.1"/>

				</literal>

			</recordUpdateTime>

		</xsl:if>

	</xsl:template>





<!--  End of  HL7CommonTemplates.xsl -->	

	

	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>

	<xsl:template match="/">

		<xsl:variable name="var1_MDM_T02" as="node()?" select="ns0:MDM_T02"/>

		

		<!-- Use Below for Message Mediator -->

			<xsl:variable name="fullSurvey" select="saxon:parse-survey($var1_MDM_T02/ns0:OBX/ns0:OBX.5)"/>

			<xsl:variable name="survey" select="$fullSurvey/hthsurvey:dmpResponse"/>

			<xsl:variable name="facility" select="ns0:MDM_T02/ns0:PID/ns0:PID.3[ns0:CX.5 = 'PI']/ns0:CX.6/ns0:HD.2"/>

		 

		<!-- Use below for testing in XMLSpy -->

		<!-- 

		<xsl:variable name="survey" select="hthsurvey:dmpResponse"/>

		<xsl:variable name="facility" select="facility"/>

		-->

		<!--  common for XMLSpy and Mediator  -->						

		<ClinicalData xmlns="Clinicaldata" xmlns:basedatatypes="Basedatatypes" xmlns:common="Common" xmlns:surveys="Surveys">

					<templateId xmlns="">

						<xsl:sequence select="'DMPSurveyCreate40024'"/>

					</templateId>

					<patient xmlns="">

						<dmpSurveyResponse>

				 

				 			<xsl:for-each select="$survey/dmpGenericResponse">

				 			 

								<xmlVersion>

										<xsl:sequence select="fn:string(xmlVersion)"/>

								</xmlVersion>

							

								<xsl:call-template name="getSurveyType"/>

								

							</xsl:for-each>

							

							<surveyPatient>

								<xsl:for-each select="$var1_MDM_T02/ns0:PID/ns0:PID.3[ns0:CX.5 = 'PI']">

										<xsl:call-template name="getPatientLite"/>

								</xsl:for-each>

								<xsl:for-each select="$var1_MDM_T02/ns0:PID/ns0:PID.3[ns0:CX.5 = 'NI']">

									<xsl:call-template name="getNationalId"/>

								</xsl:for-each>

							</surveyPatient>

					

							<xsl:for-each select="$survey/dmpGenericResponse">

								<xsl:call-template name="getSurveyCommon">

									<xsl:with-param name="aFacility" select="$facility"/>

								</xsl:call-template> 

					 			<xsl:for-each select="$var1_MDM_T02//ns0:MSH">

									<xsl:call-template name="getRecordInformation"/>

								</xsl:for-each>

								<!-- <xsl:call-template name="getSurveyType"/>  -->

								<xsl:call-template name="getSurveyQuestionsAndAnswers"/>

							</xsl:for-each>

					

						</dmpSurveyResponse>

					</patient>



		</ClinicalData>

	</xsl:template>

	

	<xsl:template name="getSurveyCommon">

		<xsl:param name="aFacility"/>

				

  		<vendorMRN>

			<xsl:sequence select="fn:string(dmpVendorMRN)"/>

		</vendorMRN>

		<facility>

			<facilityNumber>

				<xsl:value-of select="$aFacility"/>

			</facilityNumber>

		</facility>

		<vendor>

			<vendorNumber>

				<xsl:sequence select="fn:string(dmpVendorFacility)"/>

			</vendorNumber>

			<vendorName>

				<xsl:sequence select="fn:string(dmpVendorName)"/>

			</vendorName>

		</vendor>

		<xsl:if test="(dmpScheduledDate != '')">

			<xsl:for-each select="dmpScheduledDate">

				<scheduledDate>

					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>

				</scheduledDate>

			</xsl:for-each>

		</xsl:if>

		<completedDate>

			<xsl:sequence select="xs:string(xs:dateTime(fn:string(dmpCompletedDate)))"/>

		</completedDate>

		<xsl:for-each select="dmpProgramName">

			<programName>

				<xsl:sequence select="fn:string(.)"/>

			</programName>

		</xsl:for-each>

		<xsl:for-each select="dmpDeviceName">

			<deviceName>

				<xsl:sequence select="fn:string(.)"/>

			</deviceName>

		</xsl:for-each>

		<xsl:for-each select="dmpResponseStatus">

			<responseStatus>

				<xsl:sequence select="fn:string(.)"/>

			</responseStatus>

		</xsl:for-each>



	</xsl:template>

		

	<xsl:template name="getSurveyType">

		<survey>

			<surveyTitle>

				<xsl:sequence select="fn:string(dmpTitle)"/>

			</surveyTitle>

			<surveyVersion>

				<xsl:sequence select="fn:string(dmpVersion)"/>

			</surveyVersion>

		</survey>

	</xsl:template>

	

	<xsl:template name="getSurveyQuestionsAndAnswers">

		<surveyQuestionsAndAnswersWithScores>

			<xsl:for-each select="dmpQuestionsAndAnswers/dmpQuestionAndAnswer">

				<surveyQuestionAndAnswerWithScore>

					<questionNumber>

						<xsl:sequence select="xs:string(xs:integer(fn:string(dmpQuestionNumber)))"/>

					</questionNumber>

					<answer>

						<xsl:sequence select="xs:string(xs:integer(fn:string(dmpAnswer)))"/>

					</answer>

					<xsl:if test="(dmpScore != '')">

						<score>

							<xsl:sequence select="xs:string(xs:integer(fn:string(dmpScore)))"/>

						</score>

					</xsl:if>

				</surveyQuestionAndAnswerWithScore>

			</xsl:for-each>

		</surveyQuestionsAndAnswersWithScores>

	</xsl:template>

	</xsl:stylesheet>

