<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:ns0="urn:hl7-org:v2xml" exclude-result-prefixes="xs fn ns0" xmlns:saxon="http://saxon.sf.net/">



	<!-- USE BELOW FOR MESSAGE MEDIATOR -->

	<!-- -->

	<xsl:variable name="var1_MDM_T02" as="node()?" select="ns0:MDM_T02"/>

	<xsl:variable name="fullSurvey" select="saxon:parse-survey($var1_MDM_T02/ns0:OBX/ns0:OBX.5)"/>

	<xsl:variable name="survey" select="$fullSurvey/HTCensus"/>

	<xsl:variable name="recordData">

		<xsl:if test="($var1_MDM_T02//ns0:MSH/ns0:MSH.4/ns0:HD.1 != '')">

	 		<xsl:for-each select="$var1_MDM_T02//ns0:MSH">

				<recordSource>

					<namespaceId>

						<xsl:value-of select="ns0:MSH.4/ns0:HD.1"/>

					</namespaceId>

					<universalId>

						<xsl:value-of select="ns0:MSH.4/ns0:HD.2"/>

					</universalId>

					<universalIdType>

						<xsl:value-of select="ns0:MSH.4/ns0:HD.3"/>

					</universalIdType>

				</recordSource>

			</xsl:for-each>

		</xsl:if>

		<xsl:if test="($var1_MDM_T02//ns0:MSH/ns0:MSH.7/ns0:TS.1 != '')">

	 		<xsl:for-each select="$var1_MDM_T02//ns0:MSH">

				<recordUpdateTime>

					<literal>

						<xsl:value-of select="ns0:MSH.7/ns0:TS.1"/>

					</literal>

				</recordUpdateTime>

			</xsl:for-each>

		</xsl:if>
		
	</xsl:variable>
	<!-- end of using Mediator-->

	<!-- elements data in routingData is used to send census acknowledgements at the end of the census transformation process -->
	<xsl:variable name="routingData">
		<routingData>
			<xsl:if test="($var1_MDM_T02//ns0:MSH/ns0:MSH.3/ns0:HD.1 != '')">
	 			<xsl:for-each select="$var1_MDM_T02//ns0:MSH">
	 				<sendingApplication>
	 					<xsl:value-of select="ns0:MSH.3/ns0:HD.1"/>
	 				</sendingApplication>
				</xsl:for-each>
			</xsl:if>
	 		
			<xsl:if test="($var1_MDM_T02//ns0:MSH/ns0:MSH.4/ns0:HD.1 != '')">
	 			<xsl:for-each select="$var1_MDM_T02//ns0:MSH">
					<stationNumber>
						<xsl:value-of select="ns0:MSH.4/ns0:HD.1"/>
					</stationNumber>
					<sendingFacility>
						<xsl:value-of select="ns0:MSH.4/ns0:HD.2"/>
					</sendingFacility>
				</xsl:for-each>
			</xsl:if>
			
			<xsl:if test="($var1_MDM_T02//ns0:MSH/ns0:MSH.5/ns0:HD.1 != '')">
	 			<xsl:for-each select="$var1_MDM_T02//ns0:MSH">
	 				<receivingApplication>
	 					<xsl:value-of select="ns0:MSH.5/ns0:HD.1"/>
	 				</receivingApplication>
				</xsl:for-each>
			</xsl:if>
			
			<xsl:if test="($var1_MDM_T02//ns0:MSH/ns0:MSH.6/ns0:HD.2 != '')">
	 			<xsl:for-each select="$var1_MDM_T02//ns0:MSH">
	 				<receivingFacility>
	 					<xsl:value-of select="ns0:MSH.6/ns0:HD.2"/>
	 				</receivingFacility>
				</xsl:for-each>
			</xsl:if>
			
		</routingData>
	</xsl:variable>	

	<!-- USE BELOW FOR TESTING IN XMLSPY -->

	<!-- 

	<xsl:variable name="survey" select="HTCensus"/>

	<xsl:variable name="recordData">

		<recordSource>

			<namespaceId>RSNSID</namespaceId>

			<universalId>RSUSID</universalId>

			<universalIdType>RSUIT</universalIdType>

		</recordSource>

		<recordUpdateTime>

			<literal>2014-06-10T08:41:47-07:00</literal>

		</recordUpdateTime>

	</xsl:variable>

	-->

	<!-- end of using XMLSpy -->



	<xsl:variable name="censusVersion" select="$survey/Version"/>

	<xsl:variable name="vendorNumber" select="$survey/VendorFacilityNumber"/>

	<xsl:variable name="vendorName" select="$survey/VendorName"/>

	<xsl:variable name="submittedDate" select="$survey/SubmissionDateTime"/>

	<xsl:variable name="reportStartDate" select="$survey/ReportStartDate"/>

	<xsl:variable name="reportEndDate" select="$survey/ReportEndDate"/>

	<!--

		####################################################################################################################

		                                                                           START OF MAIN TEMPLATE 

		####################################################################################################################

	-->

	<xsl:template match="/">

		<clinicaldata:ClinicalData xmlns:clinicaldata="Clinicaldata" xmlns:surveys="Surveys">

			<templateId>

				<xsl:sequence select="'CensusSurveyCreate40025'"/>

			</templateId>

			<patients>

				<xsl:for-each select="$survey/Segment">

					<xsl:call-template name="getSegment"/>

					<!-- RoutingData is used to send census acknowledgements at the end of the census transformation process -->
					<xsl:call-template name="getRoutingData"/>

 				</xsl:for-each>


				<xsl:for-each select="$survey/Patient">

					<patient>

						<censusSurveyResponse>

							<xsl:call-template name="getSurveyType"/>

							<xsl:call-template name="getSurveyCommon"/>

							<xsl:call-template name="getSurveyExtensions"/>

						</censusSurveyResponse>

					</patient>

				</xsl:for-each>

			</patients>

		</clinicaldata:ClinicalData>

	</xsl:template>

	<!--

		####################################################################################################################

		                                                                         START OF LOCAL TEMPLATES

		####################################################################################################################

	-->

	<xsl:template name="getSegment">

		<segment>

			<datetime>

				<xsl:sequence select="xs:string(Datetime)"/>

			</datetime>

			<current>

				<xsl:sequence select="xs:string(Current)"/>

			</current>

			<last>

				<xsl:sequence select="xs:string(Last)"/>

			</last>

		</segment>

	</xsl:template>
	
	<xsl:template name="getRoutingData">

		<xsl:copy-of select="$routingData"/>

	</xsl:template>
	
	<xsl:template name="getSurveyType">

		<survey>

			<title>

				<xsl:sequence select="'Census'"/>

			</title>

			<version>

				<xsl:sequence select="fn:string($censusVersion)"/>

			</version>

		</survey>

	</xsl:template>

	<xsl:template name="getName">

		<name>

			<xsl:if test="(Given != '')">

				<given>

					<xsl:sequence select="fn:string(Given)"/>

				</given>

			</xsl:if>

			<xsl:if test="(Middle != '')">

				<middle>

					<xsl:sequence select="fn:string(Middle)"/>

				</middle>

			</xsl:if>

			<xsl:if test="(Family != '')">

				<family>

					<xsl:sequence select="fn:string(Family)"/>

				</family>

			</xsl:if>

		</name>

	</xsl:template>

	<xsl:template name="getSurveyPatient">

		<surveyPatient>

			<vendorMRN>

				<xsl:sequence select="fn:string(VendorMRN)"/>

			</vendorMRN>

			<xsl:if test="(ICN != '')">

				<icn>

					<xsl:sequence select="fn:string(ICN)"/>

				</icn>

			</xsl:if>

			<xsl:if test="(SSN != '')">

				<ssn>

					<xsl:sequence select="fn:string(SSN)"/>

				</ssn>

			</xsl:if>

			<xsl:for-each select="Name">

				<xsl:call-template name="getName"/>

			</xsl:for-each>

			<birthdate>

				<xsl:sequence select="fn:string(DOB)"/>

			</birthdate>

		</surveyPatient>

	</xsl:template>

	<xsl:template name="getSurveyCommon">

		<xsl:call-template name="getSurveyPatient"/>

		<xsl:for-each select="EnrollmentDate">

			<enrollmentDate>

				<xsl:sequence select="fn:string(.)"/>

			</enrollmentDate>

		</xsl:for-each>

		<xsl:if test="(fn:string(DisenrollmentDate) != '')">

			<xsl:for-each select="DisenrollmentDate">

				<disenrollmentDate>

					<xsl:sequence select="fn:string(.)"/>

				</disenrollmentDate>

			</xsl:for-each>

		</xsl:if>

		<xsl:for-each select="ActivationDate">

			<activationDate>

				<xsl:sequence select="fn:string(.)"/>

			</activationDate>

		</xsl:for-each>

		<xsl:if test="(fn:string(InactivationDate) != '')">

			<xsl:for-each select="InactivationDate">

				<inactivationDate>

					<xsl:sequence select="fn:string(.)"/>

				</inactivationDate>

			</xsl:for-each>

		</xsl:if>

		<facility>

			<location>

				<xsl:sequence select="fn:string(FacilityLocation)"/>

			</location>

		</facility>

		<vendor>

			<number>

				<xsl:value-of select="fn:string($vendorNumber)"/>

			</number>

			<name>

				<xsl:value-of select="fn:string($vendorName)"/>

			</name>

		</vendor>

		<careCoordinator>

			<xsl:for-each select="CareCoordinator">

				<id>

					<xsl:sequence select="fn:string(DUZ)"/>

				</id>

				<facilityNumber>

					<xsl:sequence select="fn:string(FacilityNumber)"/>

				</facilityNumber>

				<xsl:for-each select="Name">

					<xsl:call-template name="getName"/>

				</xsl:for-each>

			</xsl:for-each>

		</careCoordinator>

		<programName>

			<xsl:sequence select="fn:string(ProgramName)"/>

		</programName>

		<xsl:copy-of select="$recordData"/>

	</xsl:template>

	<xsl:template name="getSurveyExtensions">

		<submittedDate>

			<xsl:value-of select="fn:string($submittedDate)"/>

		</submittedDate>

		<xsl:for-each select="HomeDevice">

			<homeDevice>

				<model>

					<xsl:value-of select="fn:string(Model)"/>

				</model>

				<serial>

					<xsl:value-of select="fn:string(Serial)"/>

				</serial>

			</homeDevice>

		</xsl:for-each>

		<reportStartDate>

			<xsl:value-of select="fn:string($reportStartDate)"/>

		</reportStartDate>

		<reportEndDate>

			<xsl:value-of select="fn:string($reportEndDate)"/>

		</reportEndDate>

		<levelOfCare>

			<xsl:value-of select="xs:string(xs:integer(fn:string(LevelOfCare)))"/>

		</levelOfCare>

		<compliance>

			<xsl:if test="(fn:string(Compliance) != '')">

				<xsl:sequence select="xs:string(xs:decimal(fn:string(Compliance)))"/>

			</xsl:if>

		</compliance>

		<responseRate>

			<actual>

				<xsl:value-of select="xs:string(xs:integer(fn:string(Responses)))"/>

			</actual>

			<expected>

				<xsl:value-of select="xs:string(xs:integer(fn:string(Expectations)))"/>

			</expected>

		</responseRate>

		<dataAge>

			<xsl:value-of select="xs:string(xs:integer(fn:string(DataAge)))"/>

		</dataAge>

		<xsl:call-template name="getSurveyModalities"/>

	</xsl:template>

	<xsl:template name="getSurveyModalities">

		<!--

		<modalities>

			<modality xsi:type="surveys:DMPCensusModality">

				<modalityType>DMP</modalityType>

				<modalityName>

					<xsl:sequence select="xs:string(DMP)"/>

				</modalityName>

			</modality>

			<xsl:for-each select="Measurement">

				<modality xsi:type="surveys:MeasurementCensusModality">

					<modalityType>Measurement</modalityType>

					<modalityName>

						<xsl:sequence select="xs:string(.)"/>

					</modalityName>

				</modality>

			</xsl:for-each>

			<xsl:if test="(Video != '')">

				<modality xsi:type="surveys:VideoCensusModality">

					<modalityType>Video</modalityType>

					<modalityName>

						<xsl:sequence select="xs:string(Video)"/>

					</modalityName>

				</modality>

			</xsl:if>

			<modality xsi:type="surveys:TelecomCensusModality">

				<modalityType>Telecom</modalityType>

				<modalityName>

					<xsl:sequence select="xs:string(Telecom)"/>

				</modalityName>

			</modality>

			<xsl:if test="(Image != '')">

				<modality xsi:type="surveys:ImageCensusModality">

					<modalityType>Image</modalityType>

					<modalityName>

						<xsl:sequence select="xs:string(Image)"/>

					</modalityName>

				</modality>

			</xsl:if>

		</modalities>

	-->

		<dmp><xsl:sequence select="xs:string(DMP)"/></dmp>

		<xsl:variable name="measurements">

			<xsl:for-each select="Measurement">

				<xsl:value-of select="."/>

				<xsl:if test="not(position()=last())">

					<xsl:text disable-output-escaping="yes">+</xsl:text>

				</xsl:if>

			</xsl:for-each>

		</xsl:variable>

		<xsl:if test="($measurements != '')">

			<measurement><xsl:sequence select="$measurements"/></measurement>

		</xsl:if>

		<xsl:if test="(Video != '')">

			<video><xsl:sequence select="xs:string(Video)"/></video>

		</xsl:if>

		<telecom><xsl:sequence select="xs:string(Telecom)"/></telecom>

		<xsl:if test="(Image != '')">

			<image><xsl:sequence select="xs:string(Image)"/></image>

		</xsl:if>

	</xsl:template>

</xsl:stylesheet>

