<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:ns0="urn:hl7-org:v2xml" exclude-result-prefixes="xs fn ns0" xmlns:saxon="http://saxon.sf.net/" xmlns:hthsurvey="HTHSurvey">
	<!--
		##################################################################################################################
		########################################## HL7 COMMON TEMPLATES ###############################################

		getRecordIdentifier template
		applies to any path ending in EI and transforming EI.1 and EI.2 into identity and namespaceId respectively

	-->
	<xsl:template name="getRecordIdentifier">
		<xsl:if test="((ns0:EI.1 != '') and (ns0:EI.2 != ''))">
			<recordIdentifier>
				<identity>
					<xsl:value-of select="ns0:EI.1"/>
				</identity>
				<namespaceId>
					<xsl:value-of select="ns0:EI.2"/>
				</namespaceId>
			</recordIdentifier>
		</xsl:if>
	</xsl:template>
	
	<!--
		##################################################################################################################

		getNationalId template
		applies to any path ending in EI and transforming EI.1 and EI.2 into identity and namespaceId respectively

	-->
	<xsl:template name="getNationalId">
		
		<xsl:if test="(ns0:CX.1 != '')">
			<icn>
				<xsl:value-of select="ns0:CX.1"/>
			</icn>
		</xsl:if>
		
	</xsl:template>
	
	<!--
		##################################################################################################################

		getSsn template
		applies to any path ending in EI and transforming EI.1 and EI.2 into identity and namespaceId respectively

	-->
	<xsl:template name="getSsn">
		
		<xsl:if test="(ns0:CX.1 != '')">
			<ssn>
				<xsl:value-of select="ns0:CX.1"/>
			</ssn>
		</xsl:if>
		
	</xsl:template>
	
	<!--
		##################################################################################################################

		getPatientLite template
		applies to PID/ns0:PID.3[ns0:CX.5 = 'PI'] path

	-->
	<xsl:template name="getPatientLite">
		<xsl:if test="((ns0:CX.1 != '') and (ns0:CX.6/ns0:HD.2 != '') and (ns0:CX.4/ns0:HD.1 != ''))">
			<patient>
				<identifier>
					<identity>
						<xsl:value-of select="ns0:CX.1"/>
					</identity>
					<assigningFacility>
						<xsl:value-of select="ns0:CX.6/ns0:HD.2"/>
					</assigningFacility>
					<assigningAuthority>
						<xsl:value-of select="ns0:CX.4/ns0:HD.1"/>
					</assigningAuthority>
				</identifier>
				<!-- get  'L' (legal) name of this patient when possible otherwise take the first occurrence-->
				<xsl:choose>
					<xsl:when test="../ns0:PID.5[ns0:XPN.7 = 'L']">
						<name>
							<prefix>
								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.5"/>
							</prefix>
							<given>
								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.2"/>
							</given>
							<middle>
								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.3"/>
							</middle>
							<family>
								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.1/ns0:FN.1"/>
							</family>
							<suffix>
								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.4"/>
							</suffix>
							<title>
								<xsl:value-of select="../ns0:PID.5[ns0:XPN.7 = 'L']/ns0:XPN.6"/>
							</title>
						</name>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="../ns0:PID.5[1]/ns0:XPN.1/ns0:FN.1">
							<name>
								<prefix>
									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.5"/>
								</prefix>
								<given>
									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.2"/>
								</given>
								<middle>
									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.3"/>
								</middle>
								<family>
									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.1/ns0:FN.1"/>
								</family>
								<suffix>
									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.4"/>
								</suffix>
								<title>
									<xsl:value-of select="../ns0:PID.5[1]/ns0:XPN.6"/>
								</title>
							</name>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</patient>
		</xsl:if>
	</xsl:template>
	<!--
		##################################################################################################################

		getRecordInformation template
		applies to MSH path

	-->
	<xsl:template name="getRecordInformation">
		<xsl:if test="(ns0:MSH.4/ns0:HD.1 != '')">
			<recordSource>
				<namespaceId>
					<xsl:value-of select="ns0:MSH.4/ns0:HD.1"/>
				</namespaceId>
				<universalId>
					<xsl:value-of select="ns0:MSH.4/ns0:HD.2"/>
				</universalId>
				<universalIdType>
					<xsl:value-of select="ns0:MSH.4/ns0:HD.3"/>
				</universalIdType>
			</recordSource>
		</xsl:if>
		<xsl:if test="(ns0:MSH.7/ns0:TS.1 != '')">
			<recordUpdateTime>
				<literal>
					<xsl:value-of select="ns0:MSH.7/ns0:TS.1"/>
				</literal>
			</recordUpdateTime>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
