DROP USER QUARTZ CASCADE;

CREATE USER QUARTZ
  IDENTIFIED BY <password>
  DEFAULT TABLESPACE LOGGER_OBJECTS
  TEMPORARY TABLESPACE TEMP
  PROFILE DEFAULT
  ACCOUNT UNLOCK;
  -- 3 Roles for QUARTZ 
  GRANT DBA TO QUARTZ;
  GRANT HDR_APPLICATION_ROLE TO QUARTZ;
  GRANT SELECT_CATALOG_ROLE TO QUARTZ;
  ALTER USER QUARTZ DEFAULT ROLE ALL;
  -- 5 System Privileges for QUARTZ 
  GRANT CREATE ANY TABLE TO QUARTZ;
  GRANT CREATE PROCEDURE TO QUARTZ;
  GRANT CREATE SESSION TO QUARTZ;
  GRANT CREATE TRIGGER TO QUARTZ;
  GRANT UNLIMITED TABLESPACE TO QUARTZ;
  -- 3 Tablespace Quotas for QUARTZ 
  ALTER USER QUARTZ QUOTA UNLIMITED ON LOGGER_CLOB;
  ALTER USER QUARTZ QUOTA UNLIMITED ON LOGGER_OBJECTS;
  ALTER USER QUARTZ QUOTA UNLIMITED ON USERS;
