

package gov.va.med.cds.scheduler.persistence;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;

import gov.va.med.cds.scheduler.CensusAcknowledgementWorkInterface;


public abstract class AbstractHibernatePersistenceManager
{

    protected static final Log LOGGER = LogFactory.getLog( AbstractHibernatePersistenceManager.class );
    protected SessionFactory sessionFactory;
    protected CensusAcknowledgementWorkInterface censusAcknowledgementWork;


    public SessionFactory getSessionFactory( )
    {
        return sessionFactory;
    }


    /**
     * Loads the session factory on start-up as directed by Spring injection.
     * 
     * @param sessionFactory session factory passed in from spring injection.
     */
    final public void setSessionFactory( SessionFactory sessionFactory )
    {
        this.sessionFactory = sessionFactory;
    }


    public void setCensusAcknowledgementWork( CensusAcknowledgementWorkInterface censusAcknowledgementWork )
    {
        this.censusAcknowledgementWork = censusAcknowledgementWork;
    }
}
