package gov.va.med.cds.mediator.xml.transform.saxonextensions;

import gov.va.med.cds.mediator.work.WorkStateInterface;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;


public class WorkStateExceptionCountExtFunc extends ExtensionFunctionDefinition {

	private static final long serialVersionUID = -2349518788057837704L;
	private static final StructuredQName qName = new StructuredQName("", NamespaceConstant.SAXON, "get-exception-count");
	
	@Override
	public StructuredQName getFunctionQName() {
		
		return qName;
	}

	@Override
	public SequenceType[] getArgumentTypes() {
		
		return new SequenceType[]{SequenceType.SINGLE_ITEM};

	}

	@Override
	public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
		
		return SequenceType.SINGLE_INTEGER;
	}
	

	@Override
	public ExtensionFunctionCall makeCallExpression() {
		
		return new ExceptionCountCall();
	}
	
	private static class ExceptionCountCall extends ExtensionFunctionCall{

		private static final long serialVersionUID = 1L;

		@Override
		public Sequence call(XPathContext context, Sequence[] arguments)
				throws XPathException {
			
			ObjectValue objV = (ObjectValue)arguments[0];
			WorkStateInterface workstate = (WorkStateInterface)objV.getObject();
						
			return Int64Value.makeIntegerValue(workstate.getExceptionCount());
		}

	}

}
