

package gov.va.med.cds.mediator.work;


import gov.va.med.cds.client.proxy.NetworkClientProxyInterface;
import gov.va.med.cds.exception.ApplicationAcknowledgmentException;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.SocketClientException;
import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.mediator.persistence.Hl7AuditDaoInterface;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Properties;


public class ApplicationAcknowledgementWork
    implements
        WorkerInterface,
        ApplicationAcknowledgementMBeanInterface
{
    private static final String COMMIT_ACK = "CA";
    private static final String DOD_DATA = "DOD_DATA";
    private static final String VA_DATA = "VA_DATA";
    private static final int THREAD_SLEEP_TIME = 30000;

    private static Log logger = LogFactory.getLog( ApplicationAcknowledgementWork.class );

    private String wsnHl7Support;
    private String wsnCdsVhimResponse;
    private Map<String, NetworkClientProxyInterface> clientProxiesMap;
    private boolean isEnabled = true;
    private Map<String, Hl7AuditDaoInterface> hl7AuditDaoMap = null;
    private List<String> ignoreAppAckSendingApps;


    public void doWork( WorkStateInterface workState )
    {
        if ( isEnabled )
        {
            try
            {
                HL7SupportInterface hl7Support = ( HL7SupportInterface )workState.locateWorkState( wsnHl7Support );
                String sendingFacility = hl7Support.getSendingFacility();
                String sentFrom = ( "200CH".equals( sendingFacility ) || "200HD".equals( sendingFacility ) ) ? DOD_DATA : VA_DATA;

                String vhimResponse = ( String )workState.locateWorkState( wsnCdsVhimResponse );

                List<Exception> exceptionList = workState.getExceptions();

                //stop sending AA for each census segments at ingest level, send AA at the end of the transformation 
                String appAck = hl7Support.getApplicationAcknowledgement( exceptionList, vhimResponse, ignoreAppAckSendingApps );

                if ( appAck != null )
                {
                    sendAcknowledgementResponse( appAck, hl7Support.getSendingApplication(), hl7Support.getSendingFacility(), sentFrom );
                }
            }
            catch ( Exception e )
            {
                workState.addException( e );
            }
        }
    }


    public boolean isEnabled( )
    {
        return isEnabled;
    }


    public void setEnabled( boolean isEnabled )
    {
        this.isEnabled = isEnabled;
    }


    public void sendAcknowledgementResponse( String acknowledgement, String sendingApp, String sendingFacility, String sentFrom )
    {
        NetworkClientProxyInterface clientProxy = clientProxiesMap.get( sendingApp );
        String acknowledgmentCommitAck = null;

        if ( clientProxy != null )
        {
            // write the acknowledgment to the HL7 Message Log
            HL7SupportInterface hl7supportACK = HL7SupportHAPI.createTranslationSupport( acknowledgement );

            Hl7AuditDaoInterface hl7AuditDao = null;
            if ( hl7AuditDaoMap != null )
            {
                hl7AuditDao = hl7AuditDaoMap.get( sentFrom );
            }

            if ( ( hl7AuditDao != null ) && ( hl7supportACK != null ) )
            {
                hl7AuditDao.addMessage( hl7supportACK.getMessageControlId(), acknowledgement );
            }
            
            acknowledgmentCommitAck = sendApplicationAcknowledgement( acknowledgement, sendingFacility, clientProxy );
            
            /*
             * JLA Fortify Quality Code Scan update for Poor Style: Value Never Read
             * Commenting out hl7SupportCA
             */
//            HL7SupportInterface hl7SupportCA = null;

            if ( !StringUtils.hasLength( acknowledgmentCommitAck ) )//retry
            {
                String messageControlId = "UNKNOWN";
                String[] appAckMsgCntrlId = new String[1];
                if ( hl7supportACK != null )
                {
                    messageControlId = hl7supportACK.getMessageControlId();
                }
                appAckMsgCntrlId[0] = messageControlId;

                
                for ( int i = 1; i <= 5; i++ )
                {

                    if ( i == 5 )
                    {
                        //String[] ackMsgCntrlId = { hl7supportACK.getMessageControlId()};                  
                        gov.va.med.cds.exception.ApplicationAcknowledgmentException appException = new ApplicationAcknowledgmentException(
                                        ErrorCodeEnum.APPLICATION_ACKNOWLEDGEMENT_RETRIES_EXCEEDED, null, null );
                        appException.setCustomMsgValues( appAckMsgCntrlId );
                        throw appException;
                    }
                    else
                    {
                        try
                        {
                            Thread.sleep( THREAD_SLEEP_TIME );
                        }
                        catch ( InterruptedException ex )
                        {
                            gov.va.med.cds.exception.ApplicationAcknowledgmentException appException = new ApplicationAcknowledgmentException(
                                            ErrorCodeEnum.APPLICATION_ACKNOWLEDGEMENT_RETRIES_PAUSE_EXCEPTION, ex, null );
                            appException.setCustomMsgValues( appAckMsgCntrlId );
                            throw appException;

                        }

                        if ( null != hl7AuditDao )
                        {
                            hl7AuditDao.addMessage( messageControlId, acknowledgement );
                        }
                        acknowledgmentCommitAck = sendApplicationAcknowledgement( acknowledgement, sendingFacility, clientProxy );
                        if ( StringUtils.hasLength( acknowledgmentCommitAck ) )
                        {
                            break;
                        }
                    }
                }
            }

            if ( StringUtils.hasLength( acknowledgmentCommitAck ) )
            {
                logCommitAcknowledgement( acknowledgement, acknowledgmentCommitAck, hl7supportACK, hl7AuditDao );
            }
        }

    }


    private String sendApplicationAcknowledgement( String acknowledgement, String sendingFacility, NetworkClientProxyInterface clientProxy )
    {
        String acknowledgmentCommitAck = null;
        Properties properties = new Properties();
        properties.setProperty( NetworkClientProxyInterface.PROP_DNS_NAME, sendingFacility );
        
        // send the acknowledgment
        try
        {
            acknowledgmentCommitAck = clientProxy.sendMessage( acknowledgement, properties );
        }
        catch ( Exception e)
        {
            acknowledgmentCommitAck = null;
        }

        return acknowledgmentCommitAck;
    }


    private void logCommitAcknowledgement( String acknowledgement, String acknowledgmentCommitAck, HL7SupportInterface hl7supportACK,
                    Hl7AuditDaoInterface hl7AuditDao )
    {
        // Write an error message to the CDS Application Log if other than CA.
        HL7SupportInterface hl7SupportCA = HL7SupportHAPI.createTranslationSupport( acknowledgmentCommitAck );

        // write the CA message to the HL7 Message Log	
        hl7AuditDao.addMessage( hl7supportACK.getMessageControlId(), acknowledgmentCommitAck );

        if ( !StringUtils.hasLength( hl7SupportCA.getAcknowledgementCode() )
                        || !hl7SupportCA.getAcknowledgementCode().equalsIgnoreCase( COMMIT_ACK ) )
        {
            String[] msgCntrlIds = { hl7supportACK.getMessageControlId(), hl7SupportCA.getMessageControlId() };
            ApplicationAcknowledgmentException appException = new ApplicationAcknowledgmentException(
                            ErrorCodeEnum.APPLICATION_ACKNOWLEDGEMENT_CLIENT_COMMIT_ACKNOWLEDGMENT_NOT_CA, null, null );
            appException.setCustomMsgValues( msgCntrlIds );
            throw appException;
        }

    }


    public void setClientProxiesMap( Map<String, NetworkClientProxyInterface> clientProxiesMap )
    {
        this.clientProxiesMap = clientProxiesMap;
    }


    public void setWsnHl7Support( String wsnHl7Support )
    {
        this.wsnHl7Support = wsnHl7Support;
    }


    public void setWsnCdsVhimResponse( String wsnCdsVhimResponse )
    {
        this.wsnCdsVhimResponse = wsnCdsVhimResponse;
    }


    public void setHl7AuditDaoMap( Map<String, Hl7AuditDaoInterface> hl7AuditDaoMap )
    {
        this.hl7AuditDaoMap = hl7AuditDaoMap;
    }


    public void setIgnoreAppAckSendingApps( List<String> ignoreAppAckSendingApps )
    {
        this.ignoreAppAckSendingApps = ignoreAppAckSendingApps;
    }
}
