

package gov.va.med.cds.mediator.persistence;


import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;

import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.orm.hibernate5.HibernateOperations;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@EnableTransactionManagement
@EnableAspectJAutoProxy
public class HibernateHl7AuditDao
    implements
        Hl7AuditDaoInterface
{
    private HibernateOperations hl7AuditHibernateTemplate;

    @Transactional(value="hdr2TransactionManager", propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, readOnly=false)
    public void addMessage( String messageControlId, String message )
    {
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( message );

        String messageType = hl7Support.getMessageType();
        String messageDateTime = hl7Support.getMessageDateTime();

        Hl7MessageLog Hl7MessageLog = new Hl7MessageLog( null, message, messageControlId, messageDateTime, messageType );

        // persist the message in HL7 message log
        hl7AuditHibernateTemplate.save( Hl7MessageLog );
    }


    public void setHl7AuditHibernateTemplate( HibernateOperations hl7AuditHibernateTemplate )
    {
        this.hl7AuditHibernateTemplate = hl7AuditHibernateTemplate;
    }
}
