

package gov.va.med.cds.mediator;


import gov.va.med.cds.mediator.work.FilterInformation;
import gov.va.med.cds.mediator.work.TemplateInformation;

import java.util.Map;


public class WorkflowData
{
    private static final String KEY_TEMPLATE_INFORMATION = "templateInformation";
    private static final String KEY_FILTER_INFORMATION = "filterInformation";
    private static final String KEY_REQUEST_ID = "requestId";
    private static final String KEY_SENDING_APPLICATION = "sendingApplication";
    private static final String KEY_REQUEST_TYPE = "requestType";

    public enum RequestType
    {
        READ, WRITE
    };


    public static String getSendingApplication( Map<String, Object> data )
    {
        return ( String )getMapData( KEY_SENDING_APPLICATION, data );
    }


    public static void setSendingApplication( Map<String, Object> data, String sendingApplication )
    {
        putMapData( KEY_SENDING_APPLICATION, data, sendingApplication );
    }


    public static TemplateInformation getTemplateInformation( Map<String, Object> data )
    {
        return ( TemplateInformation )getMapData( KEY_TEMPLATE_INFORMATION, data );
    }


    public static void setTemplateInformation( Map<String, Object> data, TemplateInformation templateInformation )
    {
        putMapData( KEY_TEMPLATE_INFORMATION, data, templateInformation );
    }


    public static FilterInformation getFilterInformation( Map<String, Object> data )
    {
        return ( FilterInformation )getMapData( KEY_FILTER_INFORMATION, data );
    }


    public static void setFilterInformation( Map<String, Object> data, FilterInformation filterInformation )
    {
        putMapData( KEY_FILTER_INFORMATION, data, filterInformation );
    }


    public static String getRequestId( Map<String, Object> data )
    {
        return ( String )getMapData( KEY_REQUEST_ID, data );
    }


    public static void setRequestId( Map<String, Object> data, String requestId )
    {
        putMapData( KEY_REQUEST_ID, data, requestId );
    }


    public static void setRequestType( Map<String, Object> data, RequestType requestType )
    {
        putMapData( KEY_REQUEST_TYPE, data, requestType );
    }


    public static boolean isReadRequest( Map<String, Object> data )
    {
        return ( ( RequestType )getMapData( KEY_REQUEST_TYPE, data ) ).equals( RequestType.READ );
    }


    protected static Object getMapData( String key, Map<String, Object> data )
    {
        Object o = data.get( key );
        if ( o == null )
        {
            throw new IllegalArgumentException( String.format( "No '%s' in map.", key ) );
        }

        return o;
    }


    protected static void putMapData( String key, Map<String, Object> data, Object value )
    {
        if ( data == null )
        {
            throw new IllegalArgumentException( "Data map must not be null for this operation to succeed." );
        }

        data.put( key, value );
    }

}
