

package gov.va.med.mediator.client.messagemediator;


import static org.easymock.EasyMock.createMock;
import static org.easymock.EasyMock.expect;
import static org.easymock.EasyMock.replay;
import static org.easymock.EasyMock.verify;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.mediator.exception.ConfigurationException;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class MessageMediatorDelegateTest
{

    private static final String SYNCHRONOUS_CHECK_MESSAGE = "Synchronous";
    private MessageMediatorInterface mediatorSynchronousMock;
    private String hl7Message;


    @Before
    public void beforeMessageMediatorDelegateTest( )
        throws Exception
    {
        this.hl7Message = "hl7Message";

    }

    @Suite( groups = "checkintest" )
    @Test( expected = ConfigurationException.class )
    public void testIsAliveMediatorSynchronousNull( )
    {
        MessageMediatorDelegate messageMediatorDelegate = new MessageMediatorDelegate();
        messageMediatorDelegate.setMessageMediator( null );
        assertTrue( messageMediatorDelegate.isAlive() );
        throw new ConfigurationException( "The sub delegate dependencies need to be injected. None were. Please check the configuration" );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testIsAliveMediatorSynchronousNotNullandMediatorSynchronousAlive( )
    {

        MessageMediatorDelegate messageMediatorDelegate = new MessageMediatorDelegate();
        mediatorSynchronousMock = createMock( MessageMediatorInterface.class );
        messageMediatorDelegate.setMessageMediator( mediatorSynchronousMock );
        expect( mediatorSynchronousMock.isAlive() ).andReturn( true );
        replay( mediatorSynchronousMock );
        messageMediatorDelegate.isAlive();
        verify( mediatorSynchronousMock );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testIsAliveMediatorSynchronousNotNullandMediatorSynchronousNotAlive( )
    {

        MessageMediatorDelegate messageMediatorDelegate = new MessageMediatorDelegate();
        mediatorSynchronousMock = createMock( MessageMediatorInterface.class );
        messageMediatorDelegate.setMessageMediator( mediatorSynchronousMock );
        expect( mediatorSynchronousMock.isAlive() ).andReturn( false );
        replay( mediatorSynchronousMock );
        messageMediatorDelegate.isAlive();
        verify( mediatorSynchronousMock );
    }


    @Test( expected = ConfigurationException.class )
    @Suite( groups = "checkintest" )
    public void testProcessMessageNullMessageMediator( )
    {
        MessageMediatorDelegate messageMediatorDelegate = new MessageMediatorDelegate();
        messageMediatorDelegate.setMessageMediator( null );
        messageMediatorDelegate.processMessage( "anyMessage" );
        throw new ConfigurationException( "The Message Mediator delegate " + SYNCHRONOUS_CHECK_MESSAGE
                        + " is missing and has not been injected - please check configuration." );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testProcessMessageNotNullMessageMediator( )
    {

        MessageMediatorDelegate messageMediatorDelegate = new MessageMediatorDelegate();
        mediatorSynchronousMock = createMock( MessageMediatorInterface.class );
        messageMediatorDelegate.setMessageMediator( mediatorSynchronousMock );
        expect( mediatorSynchronousMock.processMessage( hl7Message, false ) ).andReturn( "someString" );
        replay( mediatorSynchronousMock );
        messageMediatorDelegate.processMessage( hl7Message );
        verify( mediatorSynchronousMock );
    }
}
