

package gov.va.med.cds.log4j.persistence.hibernate;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.log4j.ApplicationLogEvent;

import org.easymock.EasyMock;
import org.junit.Test;
import org.springframework.orm.hibernate5.HibernateTemplate;


public class HibernateLoggerPersistenceManagerTest
{
    @Test
    @Suite( groups = "checkintest" )
    public void testPersistApplicationLogEvent( )
    {
        String cdsAppName = "CDS 3.10";
        String pathwaysAppName = "Pathways 3.10";
        HibernateLoggerPersistenceManager loggerPersistenceManager = new HibernateLoggerPersistenceManager();

        HibernateTemplate hibernateTemplateMock = EasyMock.createMock( HibernateTemplate.class );

        loggerPersistenceManager.setCdsLoggerHibernateTemplate( hibernateTemplateMock );
        loggerPersistenceManager.setPathwaysLoggerHibernateTemplate( hibernateTemplateMock );
        loggerPersistenceManager.setPathwaysAppName( pathwaysAppName );

        ApplicationLogEvent appLogEvent = new ApplicationLogEvent();
        appLogEvent.setAppName( pathwaysAppName );

        EasyMock.expect( hibernateTemplateMock.save( appLogEvent ) ).andReturn( null ).anyTimes();

        EasyMock.replay( hibernateTemplateMock );
        // verify persistApplicationLogEvent() with application name as 'Pathways 1.0' 
        loggerPersistenceManager.persistApplicationLogEvent( appLogEvent );
        EasyMock.verify( hibernateTemplateMock );

        appLogEvent.setAppName( cdsAppName );
        // verify persistApplicationLogEvent() with application name as 'CDS 3.1'
        loggerPersistenceManager.persistApplicationLogEvent( appLogEvent );
        EasyMock.verify( hibernateTemplateMock );
    }
}
