/**
 * 
 */


package gov.va.med.cds.log4j.persistence.hibernate;


import gov.va.med.cds.log4j.ApplicationLogEvent;
import gov.va.med.cds.log4j.persistence.LoggerPersistenceManagerInterface;

import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;


/**
 * @author vhaislegberb
 *
 */
@EnableTransactionManagement
@EnableAspectJAutoProxy
public class HibernateLoggerPersistenceManager
    implements
        LoggerPersistenceManagerInterface
{
    private HibernateTemplate cdsLoggerHibernateTemplate;
    private HibernateTemplate pathwaysLoggerHibernateTemplate;
    private String pathwaysAppName;

    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.log4j.persistence.LoggerPersistenceManagerInterface#persistApplicationLogEvent(gov.va.med.cds.log4j.ApplicationLogEvent)
     */
    @Transactional(value="hdr2TransactionManager", propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, readOnly=false)    
    public void persistApplicationLogEvent( ApplicationLogEvent appLogEvent )
    {
        if ( null != pathwaysAppName && pathwaysAppName.equalsIgnoreCase( appLogEvent.getAppName() ) )
        {
            pathwaysLoggerHibernateTemplate.save( appLogEvent );
        }
        else
        {
            cdsLoggerHibernateTemplate.save( appLogEvent );
        }
    }


    public void setCdsLoggerHibernateTemplate( HibernateTemplate cdsLoggerHibernateTemplate )
    {
        this.cdsLoggerHibernateTemplate = cdsLoggerHibernateTemplate;
    }


    public void setPathwaysLoggerHibernateTemplate( HibernateTemplate pathwaysLoggerHibernateTemplate )
    {
        this.pathwaysLoggerHibernateTemplate = pathwaysLoggerHibernateTemplate;
    }


    public void setPathwaysAppName( String pathwaysAppName )
    {
        this.pathwaysAppName = pathwaysAppName;
    }
  
}