/**
 * 
 */


package gov.va.med.cds.log4j;

import org.apache.logging.log4j.core.LogEvent;

import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;


/**
 * @author vhaislegberb
 * 
 */
@EnableTransactionManagement
@EnableAspectJAutoProxy
public class RuntimeConfigurableJmsAppender
    extends
        JmsQueueAppender
{
    public RuntimeConfigurableJmsAppender( )
    {
        super();
    }


    @Override
    public void setProviderURL( String providerURL )
    {
        // use system property as the overriding value if available.
        String cdsProviderURL = System.getProperty( "cds.jndi.provider.url" );
        if ( cdsProviderURL != null )
        {
            providerURL = cdsProviderURL;
        }

        super.setProviderURL( providerURL );
    }
    
    @Transactional(value="hdr2TransactionManager", propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, readOnly=false)
    public void append( LogEvent event )
    {
    	super.append(event);
    }
    
}
