

package gov.va.med.cds.junit.runners;


import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sorter;
import org.junit.runners.model.InitializationError;
import org.powermock.modules.junit4.PowerMockRunner;


public class PowerMockSuiteAwareRunner extends PowerMockRunner
{
    private boolean keepExecution = true;


    public PowerMockSuiteAwareRunner( Class<?> klass )
        throws InitializationError,
            NoTestsRemainException, Exception
    {
        super( klass );
        filter( new GroupAwareFilter() );
        sort( new Sorter( new DependancyComparator() ) );
    }

    @Override
    public void filter( Filter filter )

    {
        try
        {
            super.filter( filter );
        }
        catch ( NoTestsRemainException e )
        {
            keepExecution = false;

        }
    }


    @Override
    public void sort( Sorter sorter )
    {
        if ( !keepExecution )
            return;
        super.sort( sorter );
    }
}
