/**
 * 
 */


package gov.va.med.cds.idm.client;


import static org.junit.Assert.assertTrue;
import gov.va.med.cds.common.person.correlation.PersonIdentifier;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exception.IdmPersonServiceException;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;

import java.util.Collection;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;


/**
 * @author susarlan
 * 
 */
@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/idm/client/idmWebserviceClientTestContext.xml" } )
public class IdmPersonIdentifierManagementTest
    extends
        AbstractBaseTest
{
    private IdmPersonIdentifierManagement patientIdentifierCorrelation;


    @Test
    @Suite( groups = "idmtest" )
    public void testObtainPersonIdentifiers( )
    {
        PersonIdentifierInterface personIdentifier = new PersonIdentifier();
        personIdentifier.setIdentity( "1008523096V381537" );
        personIdentifier.setAssigningFacility( "200M" );
        personIdentifier.setAssigningAuthority( "USVHA" );

        // IdmPersonIdentifierManagement idmPersonIdentifierManagement = new IdmPersonIdentifierManagement();
        Collection<PersonIdentifierInterface> response = patientIdentifierCorrelation.obtainPersonIdentifiers( personIdentifier );
        assertTrue( response.size() > 0 );
    }


    @Test
    @Suite( groups = "idmtest" )
    public void testObtainPersonIdentifiersWithNoChecksumInIdentity( )
    {
        PersonIdentifierInterface personIdentifier = new PersonIdentifier();
        personIdentifier.setIdentity( "1008523096" );
        personIdentifier.setAssigningFacility( "200M" );
        personIdentifier.setAssigningAuthority( "USVHA" );

        // IdmPersonIdentifierManagement idmPersonIdentifierManagement = new IdmPersonIdentifierManagement();
        Collection<PersonIdentifierInterface> response = patientIdentifierCorrelation.obtainPersonIdentifiers( personIdentifier );
        assertTrue( response.size() > 0 );
    }

    @Test( expected = IdmPersonServiceException.class )
    @Suite( groups = { "idmtest" } )
    public void testObtainPersonIdentifiersWithNullIdentifier( )
    {
        patientIdentifierCorrelation.obtainPersonIdentifiers( null );
    }


    @Test( expected = IdmPersonServiceException.class )
    @Suite( groups = "idmtest" )
    public void testObtainPersonIdentifiersWithNullIdentity( )
    {
        PersonIdentifierInterface personIdentifier = new PersonIdentifier();
        personIdentifier.setIdentity( null );
        personIdentifier.setAssigningFacility( "200M" );
        personIdentifier.setAssigningAuthority( "USVHA" );

        // IdmPersonIdentifierManagement idmPersonIdentifierManagement = new IdmPersonIdentifierManagement();
        patientIdentifierCorrelation.obtainPersonIdentifiers( personIdentifier );
    }

    @Test( expected = IdmPersonServiceException.class )
    @Suite( groups = "idmtest" )
    public void testObtainPersonIdentifiersWithInvalidIdentityString( )
    {
        PersonIdentifierInterface personIdentifier = new PersonIdentifier();
        personIdentifier.setIdentity( "null" );
        personIdentifier.setAssigningFacility( "200M" );
        personIdentifier.setAssigningAuthority( "USVHA" );

        // IdmPersonIdentifierManagement idmPersonIdentifierManagement = new IdmPersonIdentifierManagement();
        patientIdentifierCorrelation.obtainPersonIdentifiers( personIdentifier );
    }

    @Resource
    public void setPatientIdentifierCorrelation( IdmPersonIdentifierManagement patientIdentifierCorrelation )
    {
        this.patientIdentifierCorrelation = patientIdentifierCorrelation;
    }
}
