

package gov.va.med.cds.hapi;


import static org.junit.Assert.fail;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import java.util.LinkedList;
import java.util.List;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class HL7SupportHAPITest
{

    /***
     * Test for exception missing MSH segment from validate message on
     * MllpMessageValidator
     */
    @Test( expected = HL7SupportException.class )
    @Suite( groups = "checkintest" )
    public void testValidateAccessMissingMsh( )
    {
        String hl7Request = "SSH^~|\\&^CHDR SENDER^HDR^VHA_HDR^CHDR^20080620150649.582-0400~D^^QBP~Z99~QRY_Q01^1213988809582^T^2.4\n";
        @SuppressWarnings("unused")
		HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( hl7Request );
    }


    /***
     * Test for exception badly formed MSH segment from validate message on
     * MllpMessageValidator
     */
    @Test( expected = HL7SupportException.class )
    @Suite( groups = "checkintest" )
    public void testValidateAccessBadMsh( )
    {
        String hl7Request = "MSH^~|\\&^CHDR SENDER\n";
        @SuppressWarnings("unused")
		HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( hl7Request );
    }


    @Test
    @Suite( groups = "checkintest" )
    /*  
    REQ 4.1 Sending Applications (MSH-3)- LA7LAB .
    REQ 4.3 Message Type (MSH-9) - ORU .
    REQ 4.2 Receiving Application (MSH-5) - LA7HDR.
    REQ 4.4 Message Processing ID (MSH-11) - P.
    REQ 4.5 Version (MSH-12) - 2.4.
     */
    public void testHL7LABMsg_NoParsingExceptions( )
    {
        String hl7Request = "MSH|^~\\&|LA7LAB|^^DNS|LA7HDR|200HD^HDRURL        ^DNS|20020921133629-0500||ORU^R01^ORU_R01|12345678|P|2.4|||NE|NE|USA\n";
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( hl7Request );
        Assert.assertNotNull( hl7Support );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testHL7PSWriteParsing( )
    {
        String hl7Request = "MSH^~|\\&^HTAPPL^200TX~SENDING_DNS~DNS^HDR HTPS^200HD~SERVER.AAC.VA.GOV~DNS^20130605-0600^^MDM~T02^10000000006^T^2.4^^^AL^AL^US\rPID^^^7890007890V666666~~~USVHA~PI~&540^^tPatient~HDRIIT~TT~Jr~Dr~MD~L|555555555~~~USVHA~PI~VA FACILITY&552&L|555555555~~~USSSA~SS~VA FACILITY ID&STATION&L^^TPatient~HDRIIT~TT~~~~L^Government~~~~~~M^19230512^m^^w^^^^^^M^C^^^^^American^^^^^veteran^\rPD1^^^^66666~DRHDR~SKY~M~~~~~USVHA~L~~~NI~facility&facility number&L\rTXA^^PR^TEXT^20130214214545-0500^^20130214214545-0500^^^33251~HDRDoctor~PHARM~~~~~~~~~~~facility&station&L^33251~HDRDoctor~PHARM~~~~~~~~~~~facility&station&L^^12345~USVHA^2.0~Patient Satisfaction^^320130214214545~HT^Patient Satisfaction^PA^U^Periodic Note Status is AV ^AC^end of collection period^\rOBX^1^TX^^^<hthsurvey:hthSurvey xsi:schemaLocation=\"HTHSurvey HTHSurveys.xsd\" xmlns:hthsurvey=\"HTHSurvey\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><psSurveyResponse><patient><icn>8888888888</icn><ssn>123123125</ssn><name><family>TTPATIENT</family><middle>P</middle><given>TRINITYPT</given></name><birthdate>1967-08-13</birthdate></patient><enrollmentDate>1967-08-13</enrollmentDate><disenrollmentDate>2012-08-13</disenrollmentDate><activationDate>1967-08-13</activationDate><inactivationDate>1967-08-13</inactivationDate><facilityNumber>402</facilityNumber><vendorNumber>200TX</vendorNumber><vendorName>Viterion</vendorName><vendorMRN>String</vendorMRN><careCoordinator><id>12345</id><name><family>HDRIITT</family><middle>T</middle><given>TRINITY</given></name></careCoordinator><scheduledDate>2012-08-13</scheduledDate><completedDate>2014-06-10T08:41:47-07:00</completedDate><currentDialogueName>String</currentDialogueName><programName>String</programName><deviceName>String</deviceName><surveyAcceptedStatus>DISENROLLED</surveyAcceptedStatus><surveyTitle>Patient Satisfaction</surveyTitle><surveyVersion>2.0</surveyVersion><surveyQuestionsAndAnswers><surveyQuestionAndAnswer><questionNumber>1</questionNumber><answer>2</answer></surveyQuestionAndAnswer><surveyQuestionAndAnswer><questionNumber>2</questionNumber><answer>1</answer></surveyQuestionAndAnswer><surveyQuestionAndAnswer><questionNumber>3</questionNumber><answer>2</answer></surveyQuestionAndAnswer><surveyQuestionAndAnswer><questionNumber>4</questionNumber><answer>2</answer></surveyQuestionAndAnswer><surveyQuestionAndAnswer><questionNumber>5</questionNumber><answer>2</answer></surveyQuestionAndAnswer><surveyQuestionAndAnswer><questionNumber>6</questionNumber><answer>2</answer></surveyQuestionAndAnswer><surveyQuestionAndAnswer><questionNumber>7</questionNumber><answer>2</answer></surveyQuestionAndAnswer><surveyQuestionAndAnswer><questionNumber>8</questionNumber><answer>2</answer></surveyQuestionAndAnswer></surveyQuestionsAndAnswers></psSurveyResponse></hthsurvey:hthSurvey>^^^^^^^^^^^^^VISN20_89004542.2~605_120.5~VISN11_90850576.2~VISN15_36032759.2\r";
        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( hl7Request );
        Assert.assertNotNull( hl7Support );
        String sendingApplication = hl7Support.getSendingApplication();
        Assert.assertEquals( "", "HTAPPL-PS2.0", sendingApplication );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testHL7SupportHAPI( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testCreateTranslationSupport( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testToEr7( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testToXml( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testGetMessageData( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testGetSendingApplication( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testGetMessageControlId( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testGetReceivingApplication( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testGetReceivingFacility( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testGetStationNumber( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testGetSendingFacility( )
    {
        fail( "Not yet implemented" );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testApplicationAcknowledgementHandlesNullVHIM( )
    {
        String hl7Request = "MSH^~|\\&^HDRVTLS^200TX~[LOCALHOST]~DNS^HTH HDR^200HD~DNS   .DNS      URL        ~DNS^20070215144357-0500^^ORU~R01^320070215144357^T^2.4^^^AL^SU^USA^^^^";
        String vhimResponse = null;

        List<Exception> messageMediatorExceptionList = new LinkedList<Exception>();

        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( hl7Request );

        hl7Support.getApplicationAcknowledgement( messageMediatorExceptionList, vhimResponse, null );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testApplicationAcknowledgementHandlesMalformedVHIM( )
    {
        String hl7Request = "MSH^~|\\&^HDRVTLS^200TX~[LOCALHOST]~DNS^HTH HDR^200HD~DNS   .DNS      URL        ~DNS^20070215144357-0500^^ORU~R01^320070215144357^T^2.4^^^AL^SU^USA^^^^";
        String vhimResponse = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"><BadElement><fatalErrors><errorCode>CATASTROPHIC ERROR - Unable to process message.  Following is a list of one or more exceptions encountered:</errorCode><displayMessage>Test Message</displayMessage></fatalErrors></errorSection></clinicaldata:ClinicalData>";

        List<Exception> messageMediatorExceptionList = new LinkedList<Exception>();

        HL7SupportInterface hl7Support = HL7SupportHAPI.createTranslationSupport( hl7Request );

        hl7Support.getApplicationAcknowledgement( messageMediatorExceptionList, vhimResponse, null );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testGetApplicationAcknowledgementType( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testGetAcknowledgementCode( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testCreateAckResponse( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testCreateMessageDateTime( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testCreateMessageControlId( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testGetRequestWhatCode( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testGetMessageUserId( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testGetMessageType( )
    {
        fail( "Not yet implemented" );
    }


    @Ignore
    @Test
    @Suite( groups = "checkintest" )
    public void testGetMessageDateTime( )
    {
        fail( "Not yet implemented" );
    }

}
