

package gov.va.med.cds.hapi.extension.segment;


import org.apache.commons.logging.LogFactory;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.QIP;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;


public class SPR
    extends
        AbstractSegment
{
    /**
     * 
     */
    private static final long serialVersionUID = 1L;


    public SPR( Group group, ModelClassFactory modelclassfactory )
    {
        super( group, modelclassfactory );
        ca.uhn.hl7v2.model.Message message = getMessage();
        try
        {
            add( ca.uhn.hl7v2.model.v24.datatype.ST.class, false, 1, 32, new Object[] { message }, null );
            add( ca.uhn.hl7v2.model.v24.datatype.ID.class, true, 1, 1, new Object[] { message, new Integer( 106 ) }, null );
            add( ca.uhn.hl7v2.model.v24.datatype.CE.class, true, 1, 60, new Object[] { message }, null );
            add( gov.va.med.cds.hapi.extension.type.QIP.class, true, 8, 2048, new Object[] { message }, null );
        }
        catch ( HL7Exception hl7exception )
        {
            LogFactory.getLog( getClass() ).error( "Can't instantiate " + getClass().getName(), hl7exception );
        }
    }


    public ST getQueryTag( )
    {
        ST st = null;
        try
        {
            ca.uhn.hl7v2.model.Type type = getField( 1, 0 );
            st = ( ST )type;
        }
        catch ( ClassCastException classcastexception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected problem obtaining field value.  This is a bug.", classcastexception );
            throw new RuntimeException( classcastexception );
        }
        catch ( HL7Exception hl7exception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected problem obtaining field value.  This is a bug.", hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return st;
    }


    public ID getQueryResponseFormatCode( )
    {
        ID id = null;
        try
        {
            ca.uhn.hl7v2.model.Type type = getField( 2, 0 );
            id = ( ID )type;
        }
        catch ( ClassCastException classcastexception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected problem obtaining field value.  This is a bug.", classcastexception );
            throw new RuntimeException( classcastexception );
        }
        catch ( HL7Exception hl7exception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected problem obtaining field value.  This is a bug.", hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return id;
    }


    public CE getStoredProcedureName( )
    {
        CE ce = null;
        try
        {
            ca.uhn.hl7v2.model.Type type = getField( 3, 0 );
            ce = ( CE )type;
        }
        catch ( ClassCastException classcastexception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected problem obtaining field value.  This is a bug.", classcastexception );
            throw new RuntimeException( classcastexception );
        }
        catch ( HL7Exception hl7exception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected problem obtaining field value.  This is a bug.", hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return ce;
    }


    public QIP getInputParameterList( int i )
        throws HL7Exception
    {
        QIP qip = null;
        try
        {
            ca.uhn.hl7v2.model.Type type = getField( 4, i );
            qip = ( QIP )type;
        }
        catch ( ClassCastException classcastexception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected problem obtaining field value.  This is a bug.", classcastexception );
            throw new RuntimeException( classcastexception );
        }
        return qip;
    }


    public QIP[] getInputParameterList( )
    {
        QIP aqip[] = null;
        try
        {
            ca.uhn.hl7v2.model.Type atype[] = getField( 4 );
            aqip = new QIP[atype.length];
            for ( int i = 0; i < aqip.length; i++ )
                aqip[i] = ( QIP )atype[i];
        }
        catch ( ClassCastException classcastexception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected problem obtaining field value.  This is a bug.", classcastexception );
            throw new RuntimeException( classcastexception );
        }
        catch ( HL7Exception hl7exception )
        {
            LogFactory.getLog( getClass() ).error( "Unexpected problem obtaining field value.  This is a bug.", hl7exception );
            throw new RuntimeException( hl7exception );
        }
        return aqip;
    }
}
