

package gov.va.med.cds.tools.cleanup.errorq;


import gov.va.med.cds.junit.runners.BeforeTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.util.StreamUtil;
import gov.va.med.hds.hdr.busobj.patient.Patient;
import gov.va.med.hds.hdr.busobj.patient.PatientBuilderException;
import gov.va.med.hds.hdr.busobj.patient.XMLPatientBuilder;

import java.io.IOException;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.context.ContextConfiguration;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/tools/cleanup/errorq/errorQCleanUpContext.xml",
                "classpath:gov/va/med/cds/tools/cleanup/errorq/test-errorQCleanUpContext.xml" } )
public class QueueSenderGraphMessageTest
    extends
        AbstractBaseTest
{
    private static Patient vaPatient;
    private static Patient dodPatient;
    private static Patient vaPatientWithLocalIdentifer;
    private static Patient dodPatientWithLocalIdentifer;
    private static Resource resource;

    private QueueSender queueSender;

    private ResourceLoader resourceLoader = new DefaultResourceLoader();


    @javax.annotation.Resource
    public void setQueueSender( QueueSender queueSender )
    {
        this.queueSender = queueSender;
    }


    private String getPatientGraphAsString( String pathToGraphXml )
        throws IOException
    {
        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/" + pathToGraphXml );

        return StreamUtil.resourceToString( resource );
    }


    @BeforeTestsOnce
    @Suite( groups = { "checkintest" } )
    public void setUp( )
        throws PatientBuilderException,
            IOException
    {
        vaPatient = XMLPatientBuilder.buildPaitient( getPatientGraphAsString( "psimGraphVa.xml" ) );
        dodPatient = XMLPatientBuilder.buildPaitient( getPatientGraphAsString( "psimGraphDod.xml" ) );
        vaPatientWithLocalIdentifer = XMLPatientBuilder.buildPaitient( getPatientGraphAsString( "psimGraphVaLocalIdentifier.xml" ) );
        dodPatientWithLocalIdentifer = XMLPatientBuilder.buildPaitient( getPatientGraphAsString( "psimGraphDodLocalIdentifier.xml" ) );
    }


    @Test
    @Suite( order = 2, groups = "checkintest" )
    public void sendGraphMessage( )
    {
        for ( int i = 0; i < 1; i++ )
        {
            queueSender.sendMessage( vaPatient.toString() );
            queueSender.sendMessage( dodPatient.toString() );
            queueSender.sendMessage( vaPatientWithLocalIdentifer.toString() );
            queueSender.sendMessage( dodPatientWithLocalIdentifer.toString() );
        }
    }
}
