package gov.va.med.cds.tools.cleanup.errorq;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

import ca.uhn.hl7v2.model.Message;
import gov.va.med.cds.util.StreamUtil;
import junit.framework.TestCase;


public class MessageParserTest extends TestCase
{
    private static Log logger = LogFactory.getLog( MessageParserTest.class );
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private Resource resource;
    private String hl7Message;
    private String MESSAGE_TIMESTAMP_FORMAT="yyyyMMddHHmmssZ";
    private SimpleDateFormat sdf= new SimpleDateFormat(MESSAGE_TIMESTAMP_FORMAT);
    
    public static void main( String[] args ) throws Exception
    {
        MessageParserTest test = new MessageParserTest();
//        test.testGoodPPARMessage();
//        test.testPRESParseFail();
        	test.getTimeInMillseconds();
    }
    public long getTimeInMillseconds()
    {
    	try {
			
			String nowStr =  "20170814143401-0800";
			Date now = sdf.parse(nowStr);
			System.out.println("Now : " + now.toString());
			System.out.println("Now : " + now.getTime());
			
			String timeStamp="20170810142001-0800";
			Date date = sdf.parse(timeStamp);
			System.out.println("Time stamp: " + date.toString());
			System.out.println("Time: " + date.getTime());
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	return 0;
    }

    public void testGoodPREFMessageWithNewLine() {
        try
        {
            GlobalValueObject gvo = new GlobalValueObject();
            ErrorQueueThreadLocal.set(gvo);
            // hdrpref3 contains new line '\n' after TABLET and DAILY
            String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrpref3.er7";
            resource = resourceLoader.getResource(fileName);      
            String ahl7Message = StreamUtil.resourceToString( resource );
            String hl7Message = MessagePreProcessor.preProcessHL7Message( ahl7Message);
            int index = ahl7Message.indexOf( "TAKE ONE TABLET BY MOUTH DAILY  FOR CIRCULATION" );
            assertTrue(index == -1); 
            index = hl7Message.indexOf( "TAKE ONE TABLET BY MOUTH DAILY  FOR CIRCULATION" );
            assertTrue(index == 1361); 
            ErrorQMessageParser.parseUsingHapi( hl7Message );
        }
        catch ( Exception e )
        {
            fail();
        }
       
    }
    public void testGoodPREFMessage() throws Exception {
        GlobalValueObject gvo = new GlobalValueObject();
        ErrorQueueThreadLocal.set(gvo);
        // hdrpref2 ai a good messag contains new line '\n' after TABLET and DAILY
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrpref2.er7";
        resource = resourceLoader.getResource(fileName);      
        String ahl7Message = StreamUtil.resourceToString( resource );
        String hl7Message = MessagePreProcessor.preProcessHL7Message( ahl7Message);
        
        assertTrue(ahl7Message.equals( hl7Message )); 
    }
    public void testGoodVitalMessage() throws Exception {
        GlobalValueObject gvo = new GlobalValueObject();
        ErrorQueueThreadLocal.set(gvo);
        // hdrpref2 ai a good messag contains new line '\n' after TABLET and DAILY
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdr_vital_good.er7";
        resource = resourceLoader.getResource(fileName);      
        String ahl7Message = StreamUtil.resourceToString( resource );
        String hl7Message = MessagePreProcessor.preProcessHL7Message( ahl7Message);
        assertTrue(ahl7Message.equals( hl7Message )); 
    }
    public void testGoodVitalMessageWithNewLine() throws Exception {
        GlobalValueObject gvo = new GlobalValueObject();
        ErrorQueueThreadLocal.set(gvo);
        // hdr_vital_good_with_new_line is a good messag contains new line '\n'
        // however, MessagePreProcessor only process ALLERGY, LAB and PHARMACY messages.
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdr_vital_good_with_new_line.er7";
        resource = resourceLoader.getResource(fileName);      
        String ahl7Message = StreamUtil.resourceToString( resource );
        String hl7Message = MessagePreProcessor.preProcessHL7Message( ahl7Message);
        assertTrue(ahl7Message.equals( hl7Message )); 
    }
    public void testGoodPPARMessage() throws Exception {
        GlobalValueObject gvo = new GlobalValueObject();
        ErrorQueueThreadLocal.set(gvo);
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrppar4.er7";
        resource = resourceLoader.getResource(fileName);      
        String ahl7Message = StreamUtil.resourceToString( resource );
        logger.debug( "Original message: " +  ahl7Message );
        
        try
        {
            ahl7Message = MessagePreProcessor.preProcessHL7Message( ahl7Message );
            logger.debug( "After pre-processed message: " +  ahl7Message );
            ErrorQMessageParser.parseUsingHapi( ahl7Message );
        }
        catch ( Exception e )
        {
            fail();
        }
    }
    public void testGoodPREFMessageWithExtraCR() throws Exception {
        GlobalValueObject gvo = new GlobalValueObject();
        ErrorQueueThreadLocal.set(gvo);
        // hdrpref3.er7 contain extra CR in segment. The pre-process will remove the extra CR 
        // parseUsingHapi() will be successfully. Otherwise it will failed
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrpref3.er7";
        
        resource = resourceLoader.getResource(fileName);      
        String ahl7Message = StreamUtil.resourceToString( resource );
        logger.debug( "Original message: " +  ahl7Message );
        
        try
        {
            ahl7Message = MessagePreProcessor.preProcessHL7Message( ahl7Message );
            logger.debug( "After pre-processed message: " +  ahl7Message );
            ErrorQMessageParser.parseUsingHapi( ahl7Message );
        }
        catch ( Exception e )
        {
              fail();
        }
              
    }
    public void testGoodPREFMessage2() throws Exception {
        GlobalValueObject gvo = new GlobalValueObject();
        ErrorQueueThreadLocal.set(gvo);
        // hdrpref2.er7 is a good message
        
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrpref2.er7";
        
        resource = resourceLoader.getResource(fileName);      
        String ahl7Message = StreamUtil.resourceToString( resource );
        logger.debug( "Original message: " +  ahl7Message );
        
        try
        {
            String hl7Message = MessagePreProcessor.preProcessHL7Message( ahl7Message );
            assertTrue(hl7Message.equals( ahl7Message ));
            logger.debug( "After pre-processed message: " +  hl7Message );
            ErrorQMessageParser.parseUsingHapi( hl7Message );
        }
        catch ( Exception e )
        {
              fail();
        }
              
    }
    public void testGoodPPARMessage2() throws Exception {
        GlobalValueObject gvo = new GlobalValueObject();
        ErrorQueueThreadLocal.set(gvo);
        // hdr_vital_good_with_new_line is a good messag contains new line '\n'
        // however, MessagePreProcessor only process ALLERGY, LAB and PHARMACY messages.
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrppar_good_or_bad.er7";
        
        resource = resourceLoader.getResource(fileName);      
        String ahl7Message = StreamUtil.resourceToString( resource );
        logger.debug( "Original message: " +  ahl7Message );
        
        try
        {
            ahl7Message = MessagePreProcessor.preProcessHL7Message( ahl7Message );
            logger.debug( "After pre-processed message: " +  ahl7Message );
            ErrorQMessageParser.parseUsingHapi( ahl7Message );
        }
        catch ( Exception e )
        {
            fail();
        }
    }
    public void testPPARParseFail() throws Exception {
        GlobalValueObject gvo = new GlobalValueObject();
        ErrorQueueThreadLocal.set(gvo);
        // hdr_vital_good_with_new_line is a good messag contains new line '\n'
        // however, MessagePreProcessor only process ALLERGY, LAB and PHARMACY messages.
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrppar_parse_fail.er7";
        
        resource = resourceLoader.getResource(fileName);      
        String ahl7Message = StreamUtil.resourceToString( resource );
        logger.debug( "Original message: " +  ahl7Message );
        
        try
        {
            ahl7Message = MessagePreProcessor.preProcessHL7Message( ahl7Message );
            logger.debug( "After pre-processed message: " +  ahl7Message );
            ErrorQMessageParser.parseUsingHapi( ahl7Message );
        }
        catch ( Exception e )
        {
            fail();
        }
    }
    public void testPREFParseFail() throws Exception {
        GlobalValueObject gvo = new GlobalValueObject();
        ErrorQueueThreadLocal.set(gvo);
        // hdr_vital_good_with_new_line is a good messag contains new line '\n'
        // however, MessagePreProcessor only process ALLERGY, LAB and PHARMACY messages.
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrpref_parse_fail.er7";
        
        resource = resourceLoader.getResource(fileName);      
        String ahl7Message = StreamUtil.resourceToString( resource );
        logger.debug( "Original message: " +  ahl7Message );
        
        try
        {
            ahl7Message = MessagePreProcessor.preProcessHL7Message( ahl7Message );
            logger.debug( "After pre-processed message: " +  ahl7Message );
            ErrorQMessageParser.parseUsingHapi( ahl7Message );
        }
        catch ( Exception e )
        {
            fail();
        }
    }
    public void testPRESParseFail() throws Exception {
        GlobalValueObject gvo = new GlobalValueObject();
        ErrorQueueThreadLocal.set(gvo);
        // hdr_vital_good_with_new_line is a good messag contains new line '\n'
        // however, MessagePreProcessor only process ALLERGY, LAB and PHARMACY messages.
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrpres_parse_fail.er7";
        
        resource = resourceLoader.getResource(fileName);      
        String ahl7Message = StreamUtil.resourceToString( resource );
        logger.debug( "Original message: " +  ahl7Message );
        
        try
        {
            ahl7Message = MessagePreProcessor.preProcessHL7Message( ahl7Message );
            logger.debug( "After pre-processed message: " +  ahl7Message );
            ErrorQMessageParser.parseUsingHapi( ahl7Message );
        }
        catch ( Exception e )
        {
            e.printStackTrace();
            fail();
        }
    }
    public void runTestGoodVitalMessage() throws Exception {
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdr_vital_good.er7";
        runTest(fileName);
    }
    public void runTestGoodMessage() throws Exception {
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrpref2.er7";
        runTest(fileName);
    }
 
    public void runTestHDRPPAR_failedMessage() throws Exception {
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrppar_fail.er7";
        runTest(fileName);
    }
    public void runTestHDRPPARMessage() throws Exception {
        String fileName= "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrppar.er7";
        runTest(fileName);
    }
    private void runTest(String fileName) 
        throws Exception 
    {   // hdrpref2.er7 is a good message.

        resource = resourceLoader.getResource(fileName);      
        hl7Message = StreamUtil.resourceToString( resource );
        if(logger.isDebugEnabled()){
            logger.debug( "Load file: " + fileName);
            logger.debug( "Original HL7 message: \n\n" + hl7Message );
            
        }

        Message message = ErrorQMessageParser.parseUsingHapi(hl7Message );
        if(logger.isDebugEnabled()){
                logger.debug( "=========================================================================================================");
                logger.debug( "parsed message: \n\n" + message.toString() );
        }
        
    }
}
