#!/bin/sh

PATH="~weblogic/bin:${PATH}:."
export BASE_PATH="${PATH}"
export TMP=/tmp
export TMPDIR=/var/tmp
export JAVA_HOME=/u01/app/oracle/java/jdk1.7.0_55
PATH="${WL_HOME}"/common/bin:"${WL_HOME}"/server/bin:"${JAVA_HOME}"/bin:"${PATH}"
log_file="/u01/app/errorq-cleanup/bin/errorq-cleanup-`date +%A`.log"

cd /u01/app/errorq-cleanup/bin


eq_pid=$(ps -ef |grep PORT | grep -v grep | awk '{print $2}')

if [[ -f $log_file && `date --rfc-3339=date -r $log_file` == `date +%Y-%m-%d` ]]; then
  echo " " >> $log_file
  echo " " >> $log_file
else
  echo " " > $log_file
  echo " " >> $log_file
fi
echo "#####################################################" >> $log_file
if [[ $eq_pid != "" ]]; then
   echo "Error Q Cleanup run away process found. PID = $eq_pid" >> $log_file
   echo "Killing process now..." >> $log_file
   kill -9 $eq_pid >> $log_file 2>&1
fi
echo "Start Time : `date`" >> $log_file
echo "#####################################################" >> $log_file


java -Dcds.run.properties.path=../errorqcleanup.properties -Derrorq.cleanup.run.duration=35 -Dcds.numtimesprocessed.count=4 -Djms.message.priority=8 -Djms.message.priority.threshold=3 -Djms.message.sendingapp="SendingApp='HDRALGY'" -Dcom.sun.management.jmxremote -Dcom.sun.management.jmxremote.port=PORT -Dcom.sun.management.jmxremote.authenticate=false -Dcom.sun.management.jmxremote.ssl=false -Dlog4j.configurationFile=../log4j2.xml -Djava.security.policy=../errorqcleanup.java.policy -Dcds.encrypt.password.properties=true -Dcds.keystore.password=[PASSWORD] -jar  ../lib/${project.artifactId}-${project.version}.jar >> $log_file 2>&1

echo "#####################################################" >> $log_file
echo "End Time : `date`" >> $log_file
echo "#####################################################" >> $log_file
