

package gov.va.med.mediator.client.messagemediator;


import gov.va.med.cds.registry.JAXRUtility;
import gov.va.med.mediator.client.messagemediator.jaxws.MessageMediatorServiceInterface;

import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.infomodel.Service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * 
 * Factory that creates MessageMediator delegate.
 * 
 */
public class MessageMediatorFactory
{
    // Use this version for Remote EJB
    private static Log logger = LogFactory.getLog( MessageMediatorFactory.class );

    private String serviceBindingId = null;

    private JAXRUtility jaxrUtility = null;


    public synchronized MessageMediatorInterface create( )
    {
        try
        {
            Service service = ( Service )jaxrUtility.findByIdAndType( serviceBindingId, LifeCycleManager.SERVICE );
            URL endpoint = jaxrUtility.serviceToServiceEndpointURL( service );
            MessageMediatorServiceInterface mediatorService = new MessageMediatorServiceInterface( endpoint, new QName(
                            "http://messagemediator.client.mediator.URL       ", "MessageMediatorServiceInterface" ) );
            return mediatorService.getMessageMediatorInterfaceHttpPort();
        }
        catch ( Exception ex )
        {
            logger.error( "Error creating mediator webservice cient.", ex );
            throw new MediatorClientException( "Error creating mediator service objects.", ex );
        }
    }


    public void setServiceBindingId( String serviceBindingId )
    {
        this.serviceBindingId = serviceBindingId;
    }


    public void setJaxrUtility( JAXRUtility jaxrUtility )
    {
        this.jaxrUtility = jaxrUtility;
    }

}
