package gov.va.med.cds.tools.cleanup.errorq;


//import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.cds.util.DateTimeUtil;


public class MessageDatetimeUtil
{
    private static Log logger = LogFactory.getLog( MessageDatetimeUtil.class );
 //   private static String MESSAGE_FORMAT = "yyyyMMddHHmmssZ"; // example: 20170315120856-0800

    /**
     * Verify is message datetime older than specified days from current time
     * 
     */
    public static void main( String[] args )
            throws Exception
    {
//            String currentZonedDatetimeDate = DateTimeUtil.getCurrentZonedDateTime( DateTimeUtil.FORMAT_HL7 );
//            System.out.println("Current zoned datetime: '" + currentZonedDatetimeDate + "'");
//            MessageDatetimeUtil.isMessageOutOfDate( strLastOldMessageProcessTime, DateTimeUtil.FORMAT_HL7,frequency ); 
    }

    public static boolean isMessageOutOfDate( String aMessageDatetime, String aFormat, long anAgeInDays )
    {
        boolean returnValue = false;
        
        if ( aMessageDatetime == null )
        {
            if ( logger.isDebugEnabled() )
            {
                logger.debug( "Bad message date time: " + aMessageDatetime );
            }
        }
        else
        {
            ZonedDateTime currentDateTime = ZonedDateTime.now();
            ZonedDateTime messageDateTime = DateTimeUtil.asZonedDateTime( aMessageDatetime, aFormat );
            
            if ( logger.isDebugEnabled() )
            {
                logger.debug( "Message date time: " + aMessageDatetime );
                logger.debug( "Current date time: " + currentDateTime + " Age (days): " + anAgeInDays );
            }
            
            if ( null != messageDateTime )
            {
                returnValue = ( currentDateTime.minusDays( anAgeInDays ).isAfter( messageDateTime ) ) ? true : false;
            }
        }
        
        return returnValue;
    }
}
