package gov.va.med.cds.tools.cleanup.errorq;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;  

public class ErrorQueueMessageDao {

	private static final String insertStr="insert into monitor.eq_audit_clob_str(eq_audit_clob_str_id, request_id, hl7_clob, message_date_time, message_typ, status ) values(?, ?, ?, ?, ?, ?)";
	private static final String SELECT_NEXT_ID = "select monitor.eq_audit_clob_str_seq_id.nextval from dual";
	private String requestId;
	private String hl7Clob;
	private String messageDateTime;
	private String messageType;
	private String messageStatus;
	private static Log logger = LogFactory.getLog( ErrorQueueMessageDao.class );
	private JdbcTemplate errorQueueJdbcTemplate;	// Will be set by Spring framework defined in errorQCleanupContext.xml 
//	private final StampedLock stampedLock = new StampedLock();

	
	public ErrorQueueMessageDao()
	{
	
	}
	public void setRequestId(String requestId)
	{
		this.requestId = requestId;
	}
	public String getRequestId()
	{
		return requestId;
	}
	public void setHl7Clob(String hl7Clob)
	{
		this.hl7Clob = hl7Clob;
	}
	public String getHl7Clob()
	{
		return hl7Clob;
	}
	public void setMessageDateTime(String messageDateTime)
	{
		this.messageDateTime = messageDateTime;
	}
	public String getMessageDateTime()
	{
		return messageDateTime;
	}
	public void setMessageType(String messageType)
	{
		this.messageType = messageType;
	}
	public String getMessageType(){
		return messageType;
	}
	public void setMessageStatus(String messageStatus)
	{
		this.messageStatus = messageStatus;
	}
	public String getMessageStatus(){
		return messageStatus;
	}
	@Required
	public void setErrorQueueJdbcTemplate( JdbcTemplate jdbcTemplate )
	{
			this.errorQueueJdbcTemplate = jdbcTemplate;
	}
	private Long getNextId()
	{

//		long stamp = stampedLock.writeLock();		
		Long nextId = null;
		try {
			
			nextId = errorQueueJdbcTemplate.queryForObject( SELECT_NEXT_ID, Long.class );
			
		} catch (DataAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally{
//			stampedLock.unlock(stamp);
		}
		
		return nextId;
	}
	
	public void testConnection() throws DataAccessException 
	{
		Long id = errorQueueJdbcTemplate.queryForObject(SELECT_NEXT_ID, Long.class);
		if( logger.isDebugEnabled() ){
			logger.debug("Next value(): " + id.longValue());
		}
	}
	
	/**
	 * Save message in monitor.eq_audit_clob_str
	 * 
	 */
 	public Boolean save() 
 	{
 		
 		return errorQueueJdbcTemplate.execute(ErrorQueueMessageDao.insertStr, new PreparedStatementCallback<Boolean>(){  
			@Override  
			public Boolean doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {  
				
				Long id = getNextId();
				
				if(logger.isDebugEnabled()){
					logger.debug(" - getNextId() return: " + id.toString());
					logger.debug("SQL insert String: '" + insertStr + "'");
					logger.debug("Values (" + id + ", " + getRequestId() + ", " + getMessageDateTime() + ", " + getMessageType() + ", " + getMessageStatus() + ")");
//					logger.debug("Message: " + getHl7Clob());    // should not log medical record in any not DB media.
				}
				ps.setLong(1, id);
				ps.setString(2, getRequestId());  
				ps.setString(3, getHl7Clob());  
				ps.setString(4, getMessageDateTime());  
				ps.setString(5, getMessageType());  
				ps.setString(6, getMessageStatus());  
				
				ps.execute();  
				if(logger.isDebugEnabled()){
					logger.debug("execute command completed without exception");
				}
				return true;
			}  
		});
		
	}
}

