/**
 * 
 */


package gov.va.med.cds.tools.cleanup.errorq;


import javax.jms.JMSException;
import javax.jms.Message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.MessagePostProcessor;


/**
 * @author sbrush
 *
 */
public class ErrorQListener
    extends
        AbstractErrorQListener
{
    private static Log logger = LogFactory.getLog( ErrorQListener.class );
    private int timesProcessed = -1;


    /**
     * Used in case of application exceptions and thus avoiding the reprocessing
     * of the failed message by setting a flag that the message is already
     * processed along with failure reason.
     * 
     * @param aMessage
     * @param aReason
     */
    void sendWithConversionToPreventReprocessing( Message aMessage, final String aReason, ErrorQueueCleanUpLogger aErrorQueueCleanUpLogger )
    {
        // jmsTemplate.setExplicitQosEnabled(true);

        GlobalValueObject gvo = ErrorQueueThreadLocal.get();
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "ErrorQListener.sendWithConversionToPreventReprocessing - " + gvo.toString() );
        }
        int messageNumberOfTimesProcessedCount = getMessageNumberOfTimesProcessed( aMessage ) + 1;
        jmsTemplate.convertAndSend( aMessage, new MessagePostProcessor()
        {
            public Message postProcessMessage( Message message ) throws JMSException
            {
                message.clearProperties();
                message.setBooleanProperty( "CDSProcessedMsg", true );
                message.setStringProperty( "CDSFailureReason", aReason );
                message.setIntProperty( "CDSNumTimesProcessed", timesProcessed ); // this tag is used for reprocessing all messages
                message.setStringProperty( ErrorQueueConstant.MESSAGE_CONTROL_ID, gvo.getMessageControlId() );
                message.setStringProperty( ErrorQueueConstant.SENDING_APP, gvo.getSendingApp() );
                message.setStringProperty( ErrorQueueConstant.SENDING_FACILITY, gvo.getSendingFacility() );
                message.setStringProperty( ErrorQueueConstant.MESSAGE_DATETIME, gvo.getMessageDateTime() );
                message.setIntProperty( ErrorQueueConstant.MESSAGE_PROCESSED_COUNT, messageNumberOfTimesProcessedCount );

                // message.setJMSPriority( 0 );
                return message;
            }
        } );

        aErrorQueueCleanUpLogger.logRequeued( false );
    }


    public void setTimesProcessed( int aTimesProcessed )
    {
        this.timesProcessed = aTimesProcessed;
    }

}
