

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;


public class DecodeFile
{
    public static void main( String[] anArgs )
    {
//        System.out.println( "DecodeFile" );
        String fileAsString;

        if ( ( anArgs != null ) && ( anArgs.length > 0 ) )
        {
            fileAsString = readFile( anArgs[0] );
        }
        else
        {
            fileAsString = readFile( "fileToDecode.txt" );
        }

        String unEncodedString = base64DecodeString( fileAsString );
//        int stringLength = unEncodedString.length();
        System.out.print( unEncodedString );
    }


    public static String readFile( String aFilename )
    {
//        System.out.println( "Reading File: " + aFilename );
        String fileString = "";
        File file = new File( aFilename );
        try
        {
            byte[] bytes = Files.readAllBytes( file.toPath() );
            fileString = new String( bytes, StandardCharsets.ISO_8859_1 );
        }
        catch ( FileNotFoundException fnfe )
        {
            fnfe.printStackTrace();
        }
        catch ( IOException ioe )
        {
            ioe.printStackTrace();
        }

        return fileString;
    }


    public static String base64EncodeString( String aStringToEncode )
    {
        byte[] bytesToEncode = aStringToEncode.getBytes( StandardCharsets.ISO_8859_1 );
        String encodedString = java.util.Base64.getEncoder().encodeToString( bytesToEncode );

        return encodedString;
    }


    public static String base64DecodeString( String aStringToDecode )
    {
        byte[] bytesToDecode = aStringToDecode.getBytes( StandardCharsets.ISO_8859_1 );
        byte[] decodedBytes = java.util.Base64.getDecoder().decode( bytesToDecode );
        String decodedString = new String( decodedBytes, StandardCharsets.ISO_8859_1 );

        return decodedString;
    }

}
