

package gov.va.med.cds.xml.transform;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

import java.io.IOException;

import javax.annotation.Resource;
import javax.xml.transform.TransformerConfigurationException;


@ContextConfiguration( locations = { "classpath:gov/va/med/cds/util/xmlValidatorTest-context.xml" } )
@RunWith( SuiteAwareSpringRunner.class )
public class XsltHelperTest
{

    private XsltHelper xsltHelper;

    private static Log logger = null;


    @Test
    @Suite( groups = { "checkintest" } )
    public void loadXsltTransformsIntoMemoryTest( )
        throws IOException,
            TransformerConfigurationException
    {
        xsltHelper.getXsltTransformer( "HL7ToAllergyAssessment.xsl" );
    }


    @Test( expected = XsltTransformationException.class )
    @Suite( groups = { "checkintest" } )
    public void xsltHelperExceptionTest( )
    {
        xsltHelper.transformMessage( "badSource", "badXsltKey" );
    }


    // This test need to be fixed
    // XML Transformation works fine in XMLSpy and does not work in test
    @Test( expected = XsltTransformationException.class )
    @Suite( groups = { "checkintest" } )
    public void xsltHelperTransformTest( )
    {
        xsltHelper.transformMessage( "AllergyAssessmentHL7.xml", "HL7ToAllergyAssessment.xsl" );
    }


    // This test need to be fixed
    // XML Transformation works fine in XMLSpy and does not work in test
    @Test( expected = XsltTransformationException.class )
    @Suite( groups = { "checkintest" } )
    public void testTransformMessageAsString( )
    {
        xsltHelper.transformMessageAsString( "AllergyAssessmentHL7.xml", "HL7ToAllergyAssessment.xsl" );
    }


    /**
     * Delegates to the JUnit setUp
     * 
     * @throws Exception
     */
    @BeforeClass
    @Suite( groups = { "checkintest" } )
    public static void beforeXsltHelperTestSetUp( )
        throws Exception
    {
        logger = LogFactory.getLog( XsltHelperTest.class );

        if ( logger.isDebugEnabled() )
            logger.debug( "just finished beforeXsltHelperTestSetUp" );
    }


    @AfterClass
    @Suite( groups = { "checkintest" } )
    public static void afterXsltHelperTestTearDown( )
        throws Exception
    {
        logger = null;
    }


    @Resource
    public void setXsltHelper( XsltHelper xsltHelper )
    {
        this.xsltHelper = xsltHelper;
    }

}
