<?xml version="1.0" encoding="ISO-8859-1"?>
	<!-- $Author: vhaislecclej $ -->
	<!-- $DateTime: 2009/04/07 12:03:52 $ -->
	<!--
		$File:
		//hdr/cdsn/branches/2.1/modules/redrock-message-mediator/src/main/resources/xslts/vhim400/HL7ToAllergyAssement.xsl
		$
	-->
	<!-- $Revision: #7 $ -->
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:b="urn:hl7-org:v2xml"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<!--
		<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	-->
	<xsl:template match="/">
		<clinicaldata:ClinicalData
			xmlns:clinicaldata="Clinicaldata">
			<templateId>AllergyAssessmentCreateOrUpdate40060</templateId>
			<patient>
				<xsl:variable name="nationalId"
					select="b:ORU_R01/b:ORU_R01.PATIENT_RESULT/b:ORU_R01.PATIENT/b:PID/b:PID.3[b:CX.5 = 'NI'][1]/b:CX.1" />
				<xsl:if test="string-length($nationalId) > 0">
					<requestedNationalId>
						<xsl:value-of select="$nationalId" />
					</requestedNationalId>
				</xsl:if>
				<xsl:for-each
					select="b:ORU_R01/b:ORU_R01.PATIENT_RESULT/b:ORU_R01.ORDER_OBSERVATION">
					<allergyAssessments>
						<xsl:for-each select="b:OBR/b:OBR.3">
							<xsl:call-template name="getRecordIdentifier" />
						</xsl:for-each>
						<xsl:for-each select="../b:ORU_R01.PATIENT/b:PID/b:PID.3[b:CX.5 = 'PI']">
							<xsl:call-template name="getPatientLite" />
						</xsl:for-each>
						<!--
							xsl:if test="(b:OBR/b:OBR.7/b:TS.1 != '') "> THIS MAY NOT BE USED
							AS THE CLINICALLY RELEVANT DATE because it is missing on
							EnteredInError
						-->
						<xsl:variable name="observationTime">
							<xsl:choose>
								<xsl:when test="b:OBR/b:OBR.25 = 'F' and b:OBR/b:OBR.7/b:TS.1/text()">
									<xsl:value-of select="b:OBR/b:OBR.7/b:TS.1" />
								</xsl:when>
								<xsl:otherwise>
									<!--For ENTERED IN ERROR messages -->
									<xsl:value-of select="/b:ORU_R01/b:MSH/b:MSH.7/b:TS.1" />
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:if test="$observationTime/text()">
							<observationTime>
								<literal>
									<xsl:value-of select="$observationTime" />
								</literal>
							</observationTime>
						</xsl:if>
						<!--/xsl:if-->
						<assessmentValue>
							<xsl:call-template name="getCodedElementLite">
								<xsl:with-param name="theCode"
									select="b:ORU_R01.OBSERVATION/b:OBX/b:OBX.5" />
							</xsl:call-template>
						</assessmentValue>
						<status>
							<xsl:value-of select="b:OBR/b:OBR.25" />
						</status>
						<author>
							<xsl:call-template name="getPractitioner">
								<xsl:with-param name="thePractitioner" select="b:OBR/b:OBR.32/b:NDL.1" />
							</xsl:call-template>
						</author>
						<xsl:for-each select="/b:ORU_R01/b:MSH">
							<xsl:call-template name="getRecordInformation" />
						</xsl:for-each>
					</allergyAssessments>
				</xsl:for-each>
			</patient>
		</clinicaldata:ClinicalData>
	</xsl:template>
	<!--
		##################################################################################################################
		############################################### COMMON TEMPLATES
		############################################### getRecordIdentifier
		template applies to any path ending in EI and transforming EI.1 and
		EI.2 into identity and namespaceId respectively
	-->
	<xsl:template name="getRecordIdentifier">
		<xsl:if test="((b:EI.1 != '') and (b:EI.2 != ''))">
			<recordIdentifier>
				<identity>
					<xsl:value-of select="b:EI.1" />
				</identity>
				<namespaceId>
					<xsl:value-of select="b:EI.2" />
				</namespaceId>
			</recordIdentifier>
		</xsl:if>
	</xsl:template>
	<!--
		##################################################################################################################

		getPatientLite template applies to PID/b:PID.3[b:CX.5 = 'PI'] path
	-->
	<xsl:template name="getPatientLite">
		<xsl:if
			test="((b:CX.1 != '') and (b:CX.6/b:HD.2 != '') and (b:CX.4/b:HD.1 != ''))">
			<patient>
				<identifier>
					<identity>
						<xsl:value-of select="b:CX.1" />
					</identity>
					<assigningFacility>
						<xsl:value-of select="b:CX.6/b:HD.2" />
					</assigningFacility>
					<assigningAuthority>
						<xsl:value-of select="b:CX.4/b:HD.1" />
					</assigningAuthority>
				</identifier>
				<!--
					get 'L' (legal) name of this patient when possible otherwise take
					the first occurrence
				-->
				<xsl:choose>
					<xsl:when test="../b:PID.5[b:XPN.7 = 'L']">
						<name>
							<given>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.2" />
							</given>
							<middle>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.3" />
							</middle>
							<family>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.1/b:FN.1" />
							</family>
							<suffix>
								<xsl:value-of select="../b:PID.5[b:XPN.7 = 'L']/b:XPN.4" />
							</suffix>
						</name>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="../b:PID.5[1]/b:XPN.1/b:FN.1">
							<name>
								<given>
									<xsl:value-of select="../b:PID.5[1]/b:XPN.2" />
								</given>
								<middle>
									<xsl:value-of select="../b:PID.5[1]/b:XPN.3" />
								</middle>
								<family>
									<xsl:value-of select="../b:PID.5[1]/b:XPN.1/b:FN.1" />
								</family>
								<suffix>
									<xsl:value-of select="../b:PID.5[1]/b:XPN.4" />
								</suffix>
							</name>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</patient>
		</xsl:if>
	</xsl:template>
	<!--
		##################################################################################################################

		getRecordInformation template applies to MSH path
	-->
	<xsl:template name="getRecordInformation">
		<xsl:if test="(b:MSH.4/b:HD.1 != '')">
			<recordSource>
				<namespaceId>
					<xsl:value-of select="b:MSH.4/b:HD.1" />
				</namespaceId>
				<universalId>
					<xsl:value-of select="b:MSH.4/b:HD.2" />
				</universalId>
				<universalIdType>
					<xsl:value-of select="b:MSH.4/b:HD.3" />
				</universalIdType>
			</recordSource>
		</xsl:if>
		<recordVersion>0</recordVersion>
		<xsl:if test="(b:MSH.7/b:TS.1 != '')">
			<recordUpdateTime>
				<literal>
					<xsl:value-of select="b:MSH.7/b:TS.1" />
				</literal>
			</recordUpdateTime>
		</xsl:if>
	</xsl:template>
	<!--
		#########################################################

		getCodedElementLite template applies to any path ending in CE or CNE
		and transforming CE.1/CNE.1, CE.2/CNE.2, and CE.3/CNE.3 into code,
		displayText, and codingSystem respectively
	-->
	<xsl:template name="getCodedElementLite">
		<xsl:param name="theCode" />
		<code>
			<xsl:value-of select="$theCode/(b:CE.1 | b:CNE.1)" />
		</code>
		<displayText>
			<xsl:value-of select="$theCode/(b:CE.2 | b:CNE.2)" />
		</displayText>
		<codingSystem>
			<xsl:value-of select="$theCode/(b:CE.3 | b:CNE.3)" />
		</codingSystem>
	</xsl:template>
	<!--
		##################################################################################################################

		getPractitioner template applies to any path ending in XCN or NDL and
		transforming (XCN)NDL.1 through (XCN)NDL.8 into the appropriate
		Pracitioner elements
	-->
	<xsl:template name="getPractitioner">
		<xsl:param name="thePractitioner" />
		<practitioner>
			<identifier>
				<identity>
					<xsl:value-of select="$thePractitioner/(b:XCN.1 | b:CNN.1)" />
				</identity>
				<assigningFacility />
			</identifier>
			<idSourceTable>
				<xsl:value-of select="$thePractitioner/(b:XCN.8 | b:CNN.8)" />
			</idSourceTable>
			<name>
				<prefix>
					<xsl:value-of select="$thePractitioner/(b:XCN.6 | b:CNN.6)" />
				</prefix>
				<given>
					<xsl:value-of select="$thePractitioner/(b:XCN.3 | b:CNN.3)" />
				</given>
				<middle>
					<xsl:value-of select="$thePractitioner/(b:XCN.4 | b:CNN.4)" />
				</middle>
				<family>
					<xsl:value-of select="$thePractitioner/(b:XCN.2/b:FN.1 | b:CNN.2)" />
				</family>
				<suffix>
					<xsl:value-of select="$thePractitioner/(b:XCN.5 | b:CNN.5)" />
				</suffix>
				<title>
					<xsl:value-of select="$thePractitioner/(b:XCN.7 | b:CNN.7)" />
				</title>
			</name>
		</practitioner>
	</xsl:template>
</xsl:stylesheet>
